/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.model;

import java.util.HashMap;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutNode;

public class LayoutElement
extends LayoutNode {
    private LayoutElement previous;
    private LayoutContext layoutContext;
    private HashMap strings;
    private HashMap counters;
    private boolean contentsConsumed;
    private int alternateOpen;

    public LayoutElement(LayoutElement layoutElement, LayoutElement layoutElement2, LayoutContext layoutContext) {
        super(layoutElement);
        if (layoutContext == null) {
            throw new NullPointerException();
        }
        this.previous = layoutElement2;
        this.layoutContext = layoutContext;
    }

    public LayoutElement getPrevious() {
        return this.previous;
    }

    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    public LayoutContext detachLayoutContext() {
        return this.layoutContext.detach(this.counters, this.strings);
    }

    public boolean isContentsConsumed() {
        LayoutElement layoutElement;
        if (this.isPseudoElement() && (layoutElement = this.getParent()) != null) {
            return layoutElement.isContentsConsumed();
        }
        return this.contentsConsumed;
    }

    private boolean isPseudoElement() {
        if (this.layoutContext == null) {
            return false;
        }
        return this.layoutContext.isPseudoElement();
    }

    public void setContentsConsumed(boolean bl) {
        LayoutElement layoutElement;
        if (this.isPseudoElement() && (layoutElement = this.getParent()) != null) {
            layoutElement.setContentsConsumed(bl);
            return;
        }
        this.contentsConsumed = bl;
    }

    public int getCounterValue(String string) {
        Integer n;
        if (this.counters != null && (n = (Integer)this.counters.get(string)) != null) {
            return n;
        }
        if (this.getParent() != null) {
            return this.getParent().getCounterValue(string);
        }
        return 0;
    }

    public void incrementCounter(String string, int n) {
        if (this.counters != null && this.counters.containsKey(string)) {
            int n2 = this.getCounterValue(string);
            this.counters.put(string, new Integer(n2 + n));
            return;
        }
        if (this.getParent() != null) {
            this.getParent().incrementCounter(string, n);
            return;
        }
        int n3 = this.getCounterValue(string);
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(string, new Integer(n3 + n));
    }

    public void resetCounter(String string, int n) {
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(string, new Integer(n));
    }

    public boolean isCounterDefined(String string) {
        if (this.counters == null) {
            return false;
        }
        return this.counters.containsKey(string);
    }

    public void setString(String string, String string2, boolean bl) {
        if (!bl && this.getParent() != null) {
            this.getParent().setString(string, string2, bl);
            return;
        }
        if (string2 == null) {
            if (this.strings != null) {
                this.strings.remove(string);
            }
        } else {
            if (this.strings == null) {
                this.strings = new HashMap();
            }
            this.strings.put(string, string2);
        }
    }

    public String getString(String string) {
        String string2;
        if (this.strings != null && (string2 = (String)this.strings.get(string)) != null) {
            return string2;
        }
        if (this.getParent() != null) {
            return this.getParent().getString(string);
        }
        return null;
    }

    public void openAlternate() {
        ++this.alternateOpen;
    }

    public boolean isAlternateOpen() {
        return this.alternateOpen != 0;
    }
}

