##! Events generated by the Finger analyzer.

@if ( have_spicy_analyzers() ) # prototypes below must not be used with legacy analyzer

## Generated for Finger requests.
##
## See `Wikipedia <https://en.wikipedia.org/wiki/Finger_protocol>`__ for more
## information about the Finger protocol.
##
## c: The connection.
##
## full: True if verbose information is requested (``/W`` switch).
##
## username: The request's user name.
##
## hostname: The request's host name.
##
## .. zeek:see:: finger_reply
global finger_request: event(c: connection, full: bool, username: string, hostname: string);

## Generated for Finger replies.
##
## See `Wikipedia <https://en.wikipedia.org/wiki/Finger_protocol>`__ for more
## information about the Finger protocol.
##
## c: The connection.
##
## reply_line: The reply as returned by the server
##
## .. zeek:see:: finger_request
global finger_reply: event(c: connection, reply_line: string);

@endif
