/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Web {
    public static String formatRequestAsTable(HttpServletRequest req) {
        String thisElement;
        StringBuffer sb = new StringBuffer(200);
        sb.append("<table border=\"1\">");
        sb.append("<tr><th colspan=\"2\">Request Parameters</th></tr>");
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            thisElement = (String)e.nextElement();
            sb.append("<tr><td>").append(thisElement).append("</td><td>[");
            String[] values = req.getParameterValues(thisElement);
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                if (i == values.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]</td></tr>");
        }
        sb.append("<tr><th colspan=\"2\">Request Attributes</th></tr>");
        e = req.getAttributeNames();
        while (e.hasMoreElements()) {
            thisElement = (String)e.nextElement();
            sb.append("<tr><td>").append(thisElement).append("</td><td>");
            sb.append(req.getAttribute(thisElement));
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    public static String formatSessionAsTable(HttpSession s) {
        Enumeration enm = s.getAttributeNames();
        StringBuffer sb = new StringBuffer(200);
        sb.append("<table border=\"1\">");
        while (enm.hasMoreElements()) {
            String thisElement = (String)enm.nextElement();
            if (thisElement == null) {
                sb.append("<tr><td>NULL ELEMENT!</td></tr>");
                continue;
            }
            sb.append("<tr><td>").append(thisElement).append("</td><td>");
            if (s.getAttribute(thisElement) == null) {
                sb.append("NULL!");
            } else {
                sb.append(s.getAttribute(thisElement).getClass().getName());
            }
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    public static String makeSelectionList(String name, List options, String defaultSelection, boolean hasAnyAll) {
        return Web.makeSelectionList(name, options, defaultSelection, hasAnyAll, hasAnyAll);
    }

    public static String makeSelectionList(String name, List options, String defaultSelection, boolean hasAny, boolean hasAll) {
        StringBuffer out = new StringBuffer();
        if (defaultSelection == null) {
            defaultSelection = "!@#$%^&*() NO DEFAULT ()*&^%$#@!";
        }
        out.append("<select size=\"1\" name=\"");
        out.append(name);
        out.append("\">");
        if (hasAny) {
            Web.appendOption(out, "---Total---", defaultSelection.equals("---Total---"));
        }
        if (hasAll) {
            Web.appendOption(out, "---All---", defaultSelection.equals("---All---"));
        }
        ListIterator i = options.listIterator();
        while (i.hasNext()) {
            String thisOption = (String)i.next();
            Web.appendOption(out, thisOption, thisOption.equals(defaultSelection));
        }
        out.append("</select>");
        return out.toString();
    }

    private static void appendOption(StringBuffer sb, String optionName, boolean selected) {
        sb.append(" <option");
        if (selected) {
            sb.append(" selected");
        }
        sb.append(">");
        sb.append(optionName);
        sb.append("</option>");
    }

    public static boolean containsHTMLMarkup(String testMe) {
        for (int i = 0; i < testMe.length(); ++i) {
            if (testMe.charAt(i) != '<' && testMe.charAt(i) != '>' && testMe.charAt(i) != '&') continue;
            return true;
        }
        return false;
    }

    public static String escapeAttribute(String attval) {
        return Web.escapeImpl(attval, false, false, true, true, false);
    }

    public static String escapeAttributeNbsp(String attval) {
        return Web.escapeImpl(attval, false, false, true, true, true);
    }

    public static String escapeHtml(String cdata) {
        return Web.escapeImpl(cdata, true, true, true, false, false);
    }

    static String escapeImpl(String str, boolean lt, boolean gt, boolean amp, boolean quot, boolean nbsp) {
        if (str == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer();
        int n = str.length();
        block7: for (int i = 0; i < n; ++i) {
            switch (str.charAt(i)) {
                case '<': {
                    if (lt) {
                        escaped.append("&lt;");
                        continue block7;
                    }
                    escaped.append('<');
                    continue block7;
                }
                case '>': {
                    if (lt) {
                        escaped.append("&gt;");
                        continue block7;
                    }
                    escaped.append('>');
                    continue block7;
                }
                case '&': {
                    if (amp) {
                        escaped.append("&amp;");
                        continue block7;
                    }
                    escaped.append('&');
                    continue block7;
                }
                case '\"': {
                    if (quot) {
                        escaped.append("&quot;");
                        continue block7;
                    }
                    escaped.append('\"');
                    continue block7;
                }
                case ' ': {
                    if (nbsp) {
                        escaped.append("&nbsp;");
                        continue block7;
                    }
                    escaped.append(' ');
                    continue block7;
                }
                default: {
                    escaped.append(str.charAt(i));
                }
            }
        }
        return escaped.toString();
    }
}

