/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.StringUtils;

public class NationTypeDetailPanel
extends ColopediaGameObjectTypePanel<NationType> {
    public NationTypeDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.NATION_TYPES.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        ArrayList<NationType> nations = new ArrayList<NationType>();
        nations.addAll(this.getSpecification().getVisibleEuropeanNationTypes());
        nations.addAll(this.getSpecification().getREFNationTypes());
        nations.addAll(this.getSpecification().getIndianNationTypes());
        ImageIcon icon = new ImageIcon(ImageUtils.createCenteredImage(this.getImageLibrary().getLibertyImage(), this.getListItemIconSize()));
        for (NationType type : nations) {
            parent.add(this.buildItem(type, icon));
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        NationType nationType = this.getSpecification().getNationType(id);
        if (nationType instanceof EuropeanNationType) {
            this.buildEuropeanNationTypeDetail((EuropeanNationType)nationType, panel);
        } else if (nationType instanceof IndianNationType) {
            this.buildIndianNationTypeDetail((IndianNationType)nationType, panel);
        }
    }

    private void buildEuropeanNationTypeDetail(EuropeanNationType nationType, JPanel panel) {
        List<JComponent> modifiers;
        List<JLabel> abilities;
        Font boldFont = FontLibrary.getScaledFont("simple-bold-smaller");
        panel.setLayout(new MigLayout("wrap 2, gapx 20"));
        JLabel label = Utility.localizedHeaderLabel(nationType, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)label, "span, align center, wrap 40");
        label = Utility.localizedLabel("colopedia.nationType.units");
        label.setFont(boldFont);
        panel.add((Component)label, "wrap");
        List<AbstractUnit> startingUnits = nationType.getStartingUnits();
        AbstractUnit startingUnit = CollectionUtils.first(startingUnits);
        if (startingUnit != null) {
            if (startingUnits.size() > 1) {
                panel.add((Component)this.getUnitButton(startingUnit), "span, split " + startingUnits.size());
                for (int index = 1; index < startingUnits.size(); ++index) {
                    startingUnit = startingUnits.get(index);
                    panel.add(this.getUnitButton(startingUnit));
                }
            } else {
                panel.add(this.getUnitButton(startingUnit));
            }
        }
        if (!(abilities = CollectionUtils.transform(nationType.getAbilities(), CollectionUtils.alwaysTrue(), a -> this.getAbilityComponent((Ability)a), CollectionUtils.toListNoNulls())).isEmpty()) {
            label = Utility.localizedLabel("abilities");
            label.setFont(boldFont);
            panel.add((Component)label, "newline 20, span");
            for (JLabel a2 : abilities) {
                panel.add(a2);
            }
        }
        if (!(modifiers = CollectionUtils.transform(nationType.getModifiers(), CollectionUtils.alwaysTrue(), m -> this.getModifierComponent((Modifier)m), CollectionUtils.toListNoNulls())).isEmpty()) {
            label = Utility.localizedLabel("modifiers");
            label.setFont(boldFont);
            panel.add((Component)label, "newline 20, span");
            for (JComponent m2 : modifiers) {
                panel.add(m2);
            }
        }
    }

    private void buildIndianNationTypeDetail(IndianNationType nationType, JPanel panel) {
        List<RandomChoice<UnitType>> skills = nationType.getSkills();
        panel.setLayout(new MigLayout("wrap 2, gapx 20", "", ""));
        JLabel name = Utility.localizedHeaderLabel(nationType, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(Utility.localizedLabel("colopedia.nationType.aggression"));
        panel.add(Utility.localizedLabel("colopedia.nationType." + nationType.getAggression().getKey()));
        panel.add(Utility.localizedLabel("colopedia.nationType.settlementNumber"));
        panel.add(Utility.localizedLabel("colopedia.nationType." + nationType.getNumberOfSettlements().getKey()));
        panel.add(Utility.localizedLabel("colopedia.nationType.typeOfSettlements"));
        panel.add(new JLabel(Messages.getName(nationType.getCapitalType()), new ImageIcon(this.getImageLibrary().getScaledSettlementTypeImage(nationType.getCapitalType())), 0));
        List<String> regionNames = CollectionUtils.toList(CollectionUtils.map(nationType.getRegions(), n -> Messages.getName(n)));
        panel.add(Utility.localizedLabel("colopedia.nationType.regions"));
        panel.add(new JLabel(StringUtils.join(", ", regionNames)));
        panel.add((Component)Utility.localizedLabel("colopedia.nationType.skills"), "top, newline 20");
        GridLayout gridLayout = new GridLayout(0, 2);
        gridLayout.setHgap(10);
        JPanel unitPanel = new JPanel(gridLayout);
        unitPanel.setOpaque(false);
        for (RandomChoice<UnitType> choice : skills) {
            unitPanel.add(this.getUnitButton(choice.getObject()));
        }
        panel.add(unitPanel);
    }
}

