/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.sort.StringValueProvider;

public final class StringValueRegistry
implements StringValueProvider {
    private static final Logger LOG = Logger.getLogger(StringValueRegistry.class.getName());
    private Map<Class<?>, StringValue> perClass;
    private HashMap<Integer, StringValue> perColumn;
    private HashMap<Integer, Class<?>> classPerColumn;

    @Override
    public StringValue getStringValue(int row, int column2) {
        StringValue sv = this.getPerColumnMap().get(column2);
        if (sv == null) {
            sv = this.getStringValueByClass(this.getClass(row, column2));
        }
        if (sv == null) {
            sv = this.getStringValueByClass(Object.class);
        }
        return sv != null ? sv : StringValues.TO_STRING;
    }

    public void setStringValue(StringValue sv, int column2) {
        this.getPerColumnMap().put(column2, sv);
    }

    public void clearColumnStringValues() {
        this.getPerColumnMap().clear();
    }

    public void setStringValue(StringValue sv, Class<?> clazz) {
        this.getPerClassMap().put(clazz, sv);
    }

    public StringValue getStringValue(Class<?> clazz) {
        return this.getPerClassMap().get(clazz);
    }

    public void setColumnClass(Class<?> clazz, int column2) {
        this.getColumnClassMap().put(column2, clazz);
    }

    public void setColumnClasses(Map<Integer, Class<?>> classPerColumn) {
        this.classPerColumn = classPerColumn != null ? new HashMap(classPerColumn) : null;
    }

    private StringValue getStringValueByClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        StringValue sv = this.getPerClassMap().get(clazz);
        if (sv != null) {
            return sv;
        }
        return this.getStringValueByClass(clazz.getSuperclass());
    }

    private Class<?> getClass(int row, int column2) {
        Class<?> clazz = this.getColumnClassMap().get(column2);
        return clazz != null ? clazz : Object.class;
    }

    private Map<Integer, Class<?>> getColumnClassMap() {
        if (this.classPerColumn == null) {
            this.classPerColumn = new HashMap();
        }
        return this.classPerColumn;
    }

    private Map<Class<?>, StringValue> getPerClassMap() {
        if (this.perClass == null) {
            this.perClass = new HashMap();
        }
        return this.perClass;
    }

    private Map<Integer, StringValue> getPerColumnMap() {
        if (this.perColumn == null) {
            this.perColumn = new HashMap();
        }
        return this.perColumn;
    }
}

