/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.CoroutineDumperKt;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.application.impl.TestOnlyThreading;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.UrlReference;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.testFramework.BenchmarkTestInfo;
import com.intellij.testFramework.BenchmarkTestInfoLoader;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.OpenProjectTaskBuilder;
import com.intellij.testFramework.OpenProjectTaskBuilderKt;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.OS;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.InvocationEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import kotlin.Unit;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;

public final class PlatformTestUtil {
    private static final Logger LOG = Logger.getInstance(PlatformTestUtil.class);
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    private static final List<Runnable> ourProjectCleanups = new CopyOnWriteArrayList<Runnable>();
    private static final long MAX_WAIT_TIME = TimeUnit.MINUTES.toMillis(2L);

    @NotNull
    public static String getTestName(@NotNull String name, boolean lowercaseFirstLetter) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(0);
        }
        return (name = StringUtil.trimStart((String)name, (String)"test")).isEmpty() ? "" : PlatformTestUtil.lowercaseFirstLetter(name, lowercaseFirstLetter);
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String name, boolean lowercaseFirstLetter) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(1);
        }
        if (lowercaseFirstLetter && !PlatformTestUtil.isAllUppercaseName((String)name)) {
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        String string = name;
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isAllUppercaseName(@NotNull String name) {
        if (name == null) {
            PlatformTestUtil.$$$reportNull$$$0(3);
        }
        int uppercaseChars = 0;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            if (Character.isLowerCase(name.charAt(i2))) {
                return false;
            }
            if (!Character.isUpperCase(name.charAt(i2))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    public static <T> void maskExtensions(@NotNull ProjectExtensionPointName<T> pointName, @NotNull Project project, @NotNull List<? extends T> newExtensions, @NotNull Disposable parentDisposable) {
        if (pointName == null) {
            PlatformTestUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PlatformTestUtil.$$$reportNull$$$0(5);
        }
        if (newExtensions == null) {
            PlatformTestUtil.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(7);
        }
        ((ExtensionPointImpl)pointName.getPoint((AreaInstance)project)).maskAll(newExtensions, parentDisposable, true);
    }

    @Nullable
    public static String toString(@Nullable Object node, @Nullable Queryable.PrintInfo printInfo) {
        if (node instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node).toTestString(printInfo);
            }
            return ((AbstractTreeNode)node).getTestPresentation();
        }
        return String.valueOf(node);
    }

    @NotNull
    public static String print(@NotNull JTree tree, boolean withSelection) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(8);
        }
        String string = PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, null);
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull JTree tree, @NotNull TreePath path, @Nullable Queryable.PrintInfo printInfo, boolean withSelection) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(10);
        }
        if (path == null) {
            PlatformTestUtil.$$$reportNull$$$0(11);
        }
        String string = PlatformTestUtil.print(tree, path, withSelection, printInfo, null);
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull JTree tree, boolean withSelection, @Nullable Predicate<? super String> nodePrintCondition) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(13);
        }
        String string = PlatformTestUtil.print(tree, new TreePath(tree.getModel().getRoot()), withSelection, null, nodePrintCondition);
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static String print(JTree tree, TreePath path, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        ArrayList strings = new ArrayList();
        PlatformTestUtil.printImpl(tree, path, strings, 0, withSelection, printInfo, nodePrintCondition);
        return String.join((CharSequence)"\n", strings);
    }

    private static void printImpl(JTree tree, TreePath path, Collection<? super String> strings, int level, boolean withSelection, @Nullable Queryable.PrintInfo printInfo, @Nullable Predicate<? super String> nodePrintCondition) {
        Object pathComponent = path.getLastPathComponent();
        Object userObject = TreeUtil.getUserObject((Object)pathComponent);
        String nodeText = PlatformTestUtil.toString(userObject, printInfo);
        if (nodePrintCondition != null && !nodePrintCondition.test(nodeText)) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        buff.repeat(32, level);
        boolean expanded = tree.isExpanded(path);
        int childCount = tree.getModel().getChildCount(pathComponent);
        if (childCount > 0) {
            buff.append(expanded ? (char)'-' : '+');
        }
        boolean selected = tree.getSelectionModel().isPathSelected(path);
        if (withSelection && selected) {
            buff.append('[');
        }
        buff.append(nodeText);
        if (withSelection && selected) {
            buff.append(']');
        }
        strings.add(buff.toString());
        if (expanded) {
            for (int i2 = 0; i2 < childCount; ++i2) {
                TreePath childPath = path.pathByAddingChild(tree.getModel().getChild(pathComponent, i2));
                PlatformTestUtil.printImpl(tree, childPath, strings, level + 1, withSelection, printInfo, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(@NotNull JTree tree, @NotNull String expected) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(15);
        }
        if (expected == null) {
            PlatformTestUtil.$$$reportNull$$$0(16);
        }
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqual(@NotNull JTree tree, @NotNull String expected, boolean checkSelected) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(17);
        }
        if (expected == null) {
            PlatformTestUtil.$$$reportNull$$$0(18);
        }
        PlatformTestUtil.assertTreeEqual(tree, expected, checkSelected, false);
    }

    public static void assertTreeEqual(@NotNull JTree tree, @NotNull String expected, boolean checkSelected, boolean ignoreOrder) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(19);
        }
        if (expected == null) {
            PlatformTestUtil.$$$reportNull$$$0(20);
        }
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        if (ignoreOrder) {
            List actualLines = ContainerUtil.sorted((Collection)ContainerUtil.map((Object[])StringUtil.splitByLines((String)treeStringPresentation), String::trim));
            List expectedLines = ContainerUtil.sorted((Collection)ContainerUtil.map((Object[])StringUtil.splitByLines((String)expected), String::trim));
            Assert.assertEquals((String)("Expected:\n" + expected + "\nActual:\n" + treeStringPresentation), (Object)expectedLines, (Object)actualLines);
        } else {
            UsefulTestCase.assertSameLines(expected.trim(), treeStringPresentation.trim());
        }
    }

    public static void expand(@NotNull JTree tree, int ... rows) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(21);
        }
        if (rows == null) {
            PlatformTestUtil.$$$reportNull$$$0(22);
        }
        for (int row : rows) {
            tree.expandRow(row);
            PlatformTestUtil.waitWhileBusy(tree);
        }
    }

    public static void expandAll(@NotNull JTree tree) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(23);
        }
        PlatformTestUtil.expandAll(tree, path -> !(TreeUtil.getLastUserObject((TreePath)path) instanceof ExternalLibrariesNode));
    }

    public static void expandAll(@NotNull JTree tree, @NotNull @NotNull Predicate<@NotNull TreePath> predicate) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(24);
        }
        if (predicate == null) {
            PlatformTestUtil.$$$reportNull$$$0(25);
        }
        PlatformTestUtil.waitForPromise(TreeUtil.promiseExpand((JTree)tree, (int)Integer.MAX_VALUE, predicate));
    }

    private static long getMillisSince(long startTimeMillis) {
        return System.currentTimeMillis() - startTimeMillis;
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis) {
        PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis, MAX_WAIT_TIME);
    }

    private static void assertMaxWaitTimeSince(long startTimeMillis, long timeoutMillis) {
        long took = PlatformTestUtil.getMillisSince(startTimeMillis);
        if (took > timeoutMillis) {
            throw new AssertionError((Object)("The waiting takes too long. Expected to take no more than: " + timeoutMillis + " ms but took: " + took + " ms\nThread dump: " + ThreadDumper.dumpThreadsToString() + "\nCoroutine dump: " + CoroutineDumperKt.dumpCoroutines(null, (boolean)true, (boolean)true) + "\n"));
        }
    }

    private static void assertDispatchThreadWithoutWriteAccess() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            PlatformTestUtil.assertEventQueueDispatchThread();
        } else {
            assert (!application.isWriteAccessAllowed()) : "do not wait under write action to avoid possible deadlock";
            ThreadingAssertions.assertEventDispatchThread();
        }
    }

    private static void assertEventQueueDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be called from EDT but got: " + String.valueOf(Thread.currentThread()));
        }
    }

    private static boolean isBusy(JTree tree, TreeModel model) {
        UIUtil.dispatchAllInvocationEvents();
        if (ClientProperty.isTrue((Component)tree, (Object)TreeUtil.TREE_IS_BUSY)) {
            return true;
        }
        if (model instanceof AsyncTreeModel) {
            AsyncTreeModel async = (AsyncTreeModel)model;
            if (async.isProcessing()) {
                return true;
            }
            UIUtil.dispatchAllInvocationEvents();
            return async.isProcessing();
        }
        return false;
    }

    public static void waitWhileBusy(@NotNull JTree tree) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(26);
        }
        PlatformTestUtil.waitWhileBusy(() -> PlatformTestUtil.isBusy(tree, tree.getModel()));
    }

    public static void waitWhileBusy(@NotNull Supplier<Boolean> busyCondition) {
        if (busyCondition == null) {
            PlatformTestUtil.$$$reportNull$$$0(27);
        }
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long startTimeMillis = System.currentTimeMillis();
        while (busyCondition.get().booleanValue()) {
            PlatformTestUtil.assertMaxWaitTimeSince(startTimeMillis);
            TimeoutUtil.sleep((long)5L);
            TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> {
                UIUtil.dispatchAllInvocationEvents();
                return Unit.INSTANCE;
            });
        }
    }

    public static void waitForCallback(@NotNull ActionCallback callback) {
        if (callback == null) {
            PlatformTestUtil.$$$reportNull$$$0(28);
        }
        CompletableFuture future = new CompletableFuture();
        callback.doWhenDone(() -> future.complete(null)).doWhenRejected(__ -> future.complete(null));
        PlatformTestUtil.waitForFuture(future);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(29);
        }
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME, false);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise, long timeoutMillis) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(30);
        }
        return PlatformTestUtil.waitForPromise(promise, timeoutMillis, false);
    }

    @Nullable
    public static <T> T assertPromiseSucceeds(@NotNull Promise<T> promise) {
        if (promise == null) {
            PlatformTestUtil.$$$reportNull$$$0(31);
        }
        return PlatformTestUtil.waitForPromise(promise, MAX_WAIT_TIME, true);
    }

    @Nullable
    private static <T> T waitForPromise(Promise<T> promise, long timeoutMillis, boolean assertSucceeded) {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (promise.getState() == Promise.State.PENDING) {
                TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> {
                    UIUtil.dispatchAllInvocationEvents();
                    return Unit.INSTANCE;
                });
            }
            try {
                return (T)promise.blockingGet(20, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                if (assertSucceeded) {
                    throw new AssertionError((Object)e);
                }
                return null;
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeoutMillis);
        }
    }

    public static <T> T waitForFuture(@NotNull Future<T> future) {
        if (future == null) {
            PlatformTestUtil.$$$reportNull$$$0(32);
        }
        return PlatformTestUtil.waitForFuture(future, MAX_WAIT_TIME);
    }

    public static <T> T waitForFuture(@NotNull Future<T> future, long timeoutMillis) {
        if (future == null) {
            PlatformTestUtil.$$$reportNull$$$0(33);
        }
        if (!EDT.isCurrentThreadEdt()) {
            try {
                return future.get(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        long start = System.currentTimeMillis();
        while (true) {
            if (!future.isDone()) {
                PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
            }
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            PlatformTestUtil.assertMaxWaitTimeSince(start, timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAlarm(int delay2) {
        Application app = ApplicationManager.getApplication();
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        Disposable tempDisposable = Disposer.newDisposable();
        AtomicBoolean runnableInvoked = new AtomicBoolean();
        AtomicBoolean pooledRunnableInvoked = new AtomicBoolean();
        AtomicBoolean alarmInvoked1 = new AtomicBoolean();
        AtomicBoolean alarmInvoked2 = new AtomicBoolean();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, tempDisposable);
        Alarm pooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, tempDisposable);
        ModalityState initialModality = ModalityState.current();
        alarm.addRequest(() -> {
            alarmInvoked1.set(true);
            app.invokeLater(() -> {
                runnableInvoked.set(true);
                alarm.addRequest(() -> alarmInvoked2.set(true), delay2);
            });
        }, delay2);
        pooledAlarm.addRequest(() -> pooledRunnableInvoked.set(true), delay2);
        PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
        long start = System.currentTimeMillis();
        try {
            boolean sleptAlready = false;
            while (!alarmInvoked2.get()) {
                AtomicBoolean laterInvoked = new AtomicBoolean();
                app.invokeLater(() -> laterInvoked.set(true));
                PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
                PlatformTestUtil.waitForAllDocumentsCommitted(10L, TimeUnit.SECONDS);
                Assert.assertTrue((boolean)laterInvoked.get());
                TimeoutUtil.sleep((long)(sleptAlready ? 10L : (long)delay2));
                sleptAlready = true;
                if (PlatformTestUtil.getMillisSince(start) <= MAX_WAIT_TIME) continue;
                String queue = ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).dumpQueue();
                throw new AssertionError((Object)("Couldn't await alarm; alarm passed=" + alarmInvoked1.get() + "; modality1=" + String.valueOf(initialModality) + "; modality2=" + String.valueOf(ModalityState.current()) + "; non-modal=" + (initialModality == ModalityState.nonModal()) + "; invokeLater passed=" + runnableInvoked.get() + "; pooled alarm passed=" + pooledRunnableInvoked.get() + "; app.disposed=" + app.isDisposed() + "; alarm.disposed=" + alarm.isDisposed() + "; alarm.requests=" + alarm.getActiveRequestCount() + "\n delayQueue=" + StringUtil.trimLog((String)queue, (int)1000) + "\n invocatorEdtQueue=" + String.valueOf(LaterInvocator.getLaterInvocatorEdtQueue())));
            }
        }
        finally {
            Disposer.dispose((Disposable)tempDisposable);
        }
        PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() {
        PlatformTestUtil.assertDispatchThreadWithoutWriteAccess();
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        ThreadContext.resetThreadContext(() -> {
            TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> {
                AWTEvent event;
                AtomicBoolean canary = new AtomicBoolean(false);
                ApplicationManager.getApplication().invokeLater(() -> canary.set(true), ModalityState.any());
                while ((event = eventQueue.peekEvent()) != null || !canary.get()) {
                    event = eventQueue.getNextEvent();
                    if (!(event instanceof InvocationEvent)) continue;
                    eventQueue.dispatchEvent(event);
                }
                return Unit.INSTANCE;
            });
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static void waitForSingleAlarm(@NotNull SingleAlarm alarm, long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        Job job2;
        if (alarm == null) {
            PlatformTestUtil.$$$reportNull$$$0(34);
        }
        if (timeUnit == null) {
            PlatformTestUtil.$$$reportNull$$$0(35);
        }
        if ((job2 = alarm.getCurrentJob()) == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        while (job2.isActive()) {
            void timeUnit2;
            if (PlatformTestUtil.getMillisSince(currentTime) > timeUnit2.toMillis(timeout)) {
                throw new TimeoutException("Could not wait for " + String.valueOf(alarm) + "to finish");
            }
            PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
        }
        return;
    }

    public static void dispatchAllEventsInIdeEventQueue() {
        EdtTestUtilKt.dispatchAllEventsInIdeEventQueue();
    }

    public static AWTEvent dispatchNextEventIfAny() {
        return EdtTestUtilKt.dispatchNextEventIfAny();
    }

    @NotNull
    public static StringBuilder print(@NotNull AbstractTreeStructure structure, @NotNull Object node, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, @Nullable Queryable.PrintInfo printInfo) {
        if (structure == null) {
            PlatformTestUtil.$$$reportNull$$$0(36);
        }
        if (node == null) {
            PlatformTestUtil.$$$reportNull$$$0(37);
        }
        StringBuilder stringBuilder = PlatformTestUtil.print(structure, node, currentLevel, comparator, maxRowCount, paddingChar, (Object o) -> PlatformTestUtil.toString(o, printInfo));
        if (stringBuilder == null) {
            PlatformTestUtil.$$$reportNull$$$0(38);
        }
        return stringBuilder;
    }

    @NotNull
    public static String print(@NotNull AbstractTreeStructure structure, @NotNull Object node, @NotNull Function<Object, String> nodePresenter) {
        if (structure == null) {
            PlatformTestUtil.$$$reportNull$$$0(39);
        }
        if (node == null) {
            PlatformTestUtil.$$$reportNull$$$0(40);
        }
        if (nodePresenter == null) {
            PlatformTestUtil.$$$reportNull$$$0(41);
        }
        String string = PlatformTestUtil.print(structure, node, 0, Comparator.comparing(nodePresenter), -1, ' ', nodePresenter).toString();
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static StringBuilder print(AbstractTreeStructure structure, Object node, int currentLevel, @Nullable Comparator<?> comparator, int maxRowCount, char paddingChar, Function<Object, String> nodePresenter) {
        StringBuilder buffer = new StringBuilder();
        PlatformTestUtil.doPrint(buffer, currentLevel, node, structure, comparator, maxRowCount, 0, paddingChar, nodePresenter);
        return buffer;
    }

    private static int doPrint(StringBuilder buffer, int currentLevel, Object node, AbstractTreeStructure structure, @Nullable Comparator<?> comparator, int maxRowCount, int currentLine, char paddingChar, Function<Object, String> nodePresenter) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        buffer.repeat(paddingChar, currentLevel);
        buffer.append(nodePresenter.apply(node)).append("\n");
        ++currentLine;
        Object[] children = structure.getChildElements(node);
        if (comparator != null) {
            ArrayList<Object> list = new ArrayList<Object>(List.of(children));
            Comparator<?> c = comparator;
            list.sort(c);
            children = ArrayUtil.toObjectArray(list);
        }
        for (Object child : children) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator, maxRowCount, currentLine, paddingChar, nodePresenter);
        }
        return currentLine;
    }

    @NotNull
    public static String print(Object @NotNull [] objects) {
        if (objects == null) {
            PlatformTestUtil.$$$reportNull$$$0(43);
        }
        return PlatformTestUtil.print(List.of(objects));
    }

    @NotNull
    public static String print(@NotNull Collection<?> c) {
        if (c == null) {
            PlatformTestUtil.$$$reportNull$$$0(44);
        }
        String string = c.stream().map(each -> PlatformTestUtil.toString(each, null)).collect(Collectors.joining("\n"));
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull ListModel<?> model) {
        if (model == null) {
            PlatformTestUtil.$$$reportNull$$$0(46);
        }
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            result.append(PlatformTestUtil.toString(model.getElementAt(i2), null));
            result.append("\n");
        }
        String string = result.toString();
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public static String print(@NotNull JTree tree) {
        if (tree == null) {
            PlatformTestUtil.$$$reportNull$$$0(48);
        }
        return PlatformTestUtil.print(tree, false);
    }

    public static void invokeNamedAction(@NotNull String actionId) {
        if (actionId == null) {
            PlatformTestUtil.$$$reportNull$$$0(49);
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        DataContext context2 = DataManager.getInstance().getDataContext();
        AnActionEvent event = AnActionEvent.createEvent((AnAction)action, (DataContext)context2, null, (String)"", (ActionUiKind)ActionUiKind.NONE, null);
        PerformWithDocumentsCommitted.commitDocumentsIfNeeded((AnAction)action, (AnActionEvent)event);
        ActionUtil.updateAction((AnAction)action, (AnActionEvent)event);
        Assert.assertTrue((boolean)event.getPresentation().isEnabled());
        ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(@NotNull String message, long expectedMillis, long l) {
        void actualMillis;
        if (message == null) {
            PlatformTestUtil.$$$reportNull$$$0(50);
        }
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expectedMillis * Timings.CPU_TIMING / 200L);
        Object logMessage = message;
        if (actualMillis > expectedOnMyMachine) {
            int percentage = (int)(100.0 * (double)(actualMillis - expectedOnMyMachine) / (double)expectedOnMyMachine);
            logMessage = (String)logMessage + ". Operation took " + percentage + "% longer than expected";
        }
        logMessage = (String)logMessage + ". Expected on my machine: " + expectedOnMyMachine + ". Actual: " + (long)actualMillis + ". Expected on Standard machine: " + expectedMillis + "; Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + ".";
        double acceptableChangeFactor = 1.1;
        if (actualMillis < expectedOnMyMachine) {
            System.out.println((String)logMessage);
            TeamCityLogger.info((String)logMessage);
        } else if ((double)actualMillis < (double)expectedOnMyMachine * acceptableChangeFactor) {
            TeamCityLogger.warning((String)logMessage, null);
        } else {
            throw new AssertionFailedError((String)logMessage);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static BenchmarkTestInfo newBenchmark(@NotNull String launchName, @NotNull ThrowableRunnable<?> test) {
        if (launchName == null) {
            PlatformTestUtil.$$$reportNull$$$0(51);
        }
        if (test == null) {
            PlatformTestUtil.$$$reportNull$$$0(52);
        }
        return PlatformTestUtil.newBenchmarkWithVariableInputSize(launchName, 1, () -> {
            test.run();
            return 1;
        });
    }

    @Contract(pure=true)
    @NotNull
    public static BenchmarkTestInfo newBenchmarkWithVariableInputSize(@NotNull String launchName, int expectedInputSize, @NotNull ThrowableComputable<Integer, ?> test) {
        if (launchName == null) {
            PlatformTestUtil.$$$reportNull$$$0(53);
        }
        if (test == null) {
            PlatformTestUtil.$$$reportNull$$$0(54);
        }
        BenchmarkTestInfo benchmarkTestInfo = BenchmarkTestInfoLoader.Companion.getInstance().initialize(test, expectedInputSize, launchName);
        if (benchmarkTestInfo == null) {
            PlatformTestUtil.$$$reportNull$$$0(55);
        }
        return benchmarkTestInfo;
    }

    public static void assertPathsEqual(@Nullable String expected, @Nullable String actual) {
        if (expected != null) {
            expected = FileUtilRt.toSystemIndependentName((String)expected);
        }
        if (actual != null) {
            actual = FileUtilRt.toSystemIndependentName((String)actual);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @NotNull
    public static String getJavaExe() {
        String string = SystemProperties.getJavaHome() + (OS.CURRENT == OS.Windows ? "\\bin\\java.exe" : "/bin/java");
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    public static URL getRtJarURL() {
        URL uRL;
        String home = SystemProperties.getJavaHome();
        try {
            uRL = new URI("jrt:" + home).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            PlatformTestUtil.$$$reportNull$$$0(57);
        }
        return uRL;
    }

    public static void forceCloseProjectWithoutSaving(@NotNull Project project) {
        if (project == null) {
            PlatformTestUtil.$$$reportNull$$$0(58);
        }
        if (!project.isDisposed()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ProjectManagerEx.getInstanceEx().forceCloseProject(project));
        }
    }

    public static void saveProject(@NotNull Project project) {
        if (project == null) {
            PlatformTestUtil.$$$reportNull$$$0(59);
        }
        OpenProjectTaskBuilderKt.saveProject(project, false);
    }

    public static void saveProject(@NotNull Project project, boolean isForceSavingAllSettings) {
        if (project == null) {
            PlatformTestUtil.$$$reportNull$$$0(60);
        }
        OpenProjectTaskBuilderKt.saveProject(project, isForceSavingAllSettings);
    }

    public static void waitForAllBackgroundActivityToCalmDown() {
        CpuUsageData data;
        for (int i2 = 0; i2 < 50 && (data = CpuUsageData.measureCpuUsage(() -> TimeoutUtil.sleep((long)100L))).hasAnyActivityBesides(Thread.currentThread()); ++i2) {
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(@NotNull String message, long expectedMillis, @NotNull Runnable runnable) {
        void actionToMeasure;
        if (message == null) {
            PlatformTestUtil.$$$reportNull$$$0(61);
        }
        if (runnable == null) {
            PlatformTestUtil.$$$reportNull$$$0(62);
        }
        PlatformTestUtil.assertTiming(message, expectedMillis, 4, (Runnable)actionToMeasure);
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(@NotNull String message, long expectedMillis, int attempts, @NotNull Runnable runnable) {
        if (message == null) {
            PlatformTestUtil.$$$reportNull$$$0(63);
        }
        if (runnable == null) {
            PlatformTestUtil.$$$reportNull$$$0(64);
        }
        while (true) {
            void actionToMeasure;
            --attempts;
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            long duration = TimeoutUtil.measureExecutionTime(((Runnable)actionToMeasure)::run);
            try {
                PlatformTestUtil.assertTiming(message, expectedMillis, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                String s = e.getMessage() + "\n  " + attempts + " " + StringUtil.pluralize((String)"attempt", (int)attempts) + " remain";
                TeamCityLogger.warning(s, null);
                System.err.println(s);
                continue;
            }
            break;
        }
    }

    @NotNull
    private static Map<String, VirtualFile> buildNameToFileMap(VirtualFile[] files, @Nullable VirtualFileFilter filter, @Nullable Function<VirtualFile, String> fileNameMapper) {
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        for (VirtualFile file : files) {
            if (filter != null && !filter.accept(file)) continue;
            String fileName = fileNameMapper != null ? fileNameMapper.apply(file) : file.getName();
            map.put(fileName, file);
        }
        HashMap<String, VirtualFile> hashMap = map;
        if (hashMap == null) {
            PlatformTestUtil.$$$reportNull$$$0(65);
        }
        return hashMap;
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual) throws IOException {
        if (dirExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(66);
        }
        if (dirActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(67);
        }
        PlatformTestUtil.assertDirectoriesEqual(dirExpected, dirActual, null);
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual, @Nullable VirtualFileFilter fileFilter) throws IOException {
        if (dirExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(68);
        }
        if (dirActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(69);
        }
        PlatformTestUtil.assertDirectoriesEqual(dirExpected, dirActual, fileFilter, null);
    }

    public static void assertDirectoriesEqual(@NotNull VirtualFile dirExpected, @NotNull VirtualFile dirActual, @Nullable VirtualFileFilter fileFilter, @Nullable Function<VirtualFile, String> fileNameMapper) throws IOException {
        if (dirExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(70);
        }
        if (dirActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(71);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] childrenAfter = dirExpected.getChildren();
        PlatformTestUtil.shallowCompare(dirExpected, childrenAfter);
        VirtualFile[] childrenBefore = dirActual.getChildren();
        PlatformTestUtil.shallowCompare(dirActual, childrenBefore);
        Map<String, VirtualFile> mapAfter = PlatformTestUtil.buildNameToFileMap(childrenAfter, fileFilter, fileNameMapper);
        Map<String, VirtualFile> mapBefore = PlatformTestUtil.buildNameToFileMap(childrenBefore, fileFilter, fileNameMapper);
        Set<String> keySetAfter = mapAfter.keySet();
        Set<String> keySetBefore = mapBefore.keySet();
        Assert.assertEquals((String)dirExpected.getPath(), keySetAfter, keySetBefore);
        for (String name : keySetAfter) {
            VirtualFile fileAfter = mapAfter.get(name);
            VirtualFile fileBefore = mapBefore.get(name);
            if (fileAfter.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(fileAfter, fileBefore, fileFilter, fileNameMapper);
                continue;
            }
            if (FileTypeRegistry.getInstance().findFileTypeByName(fileAfter.getName()) == ArchiveFileType.INSTANCE) {
                PlatformTestUtil.assertJarFilesEqual(fileAfter, fileBefore);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(fileAfter, fileBefore);
        }
    }

    private static void shallowCompare(VirtualFile dir, VirtualFile[] vfs) {
        if (dir.isInLocalFileSystem() && dir.getFileSystem() != TempFileSystem.getInstance()) {
            List<String> vfsPaths = Stream.of(vfs).map(VirtualFile::getPath).sorted().toList();
            List<String> ioPaths = NioFiles.list((Path)dir.toNioPath()).stream().map(Path::toString).map(FileUtilRt::toSystemIndependentName).sorted().toList();
            Assert.assertEquals(vfsPaths, ioPaths);
        }
    }

    public static void assertFilesEqual(@NotNull VirtualFile fileExpected, @NotNull VirtualFile fileActual) throws IOException {
        if (fileExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(72);
        }
        if (fileActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(73);
        }
        String actual = PlatformTestUtil.fileText(fileActual);
        String expected = PlatformTestUtil.fileText(fileExpected);
        if (expected == null || actual == null) {
            Assert.assertArrayEquals((String)fileExpected.getPath(), (byte[])fileExpected.contentsToByteArray(), (byte[])fileActual.contentsToByteArray());
        } else if (!StringUtil.equals((CharSequence)expected, (CharSequence)actual)) {
            throw new FileComparisonFailedError("Text mismatch in the file " + fileExpected.getName(), expected, actual, (String)fileActual.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH));
        }
    }

    private static String fileText(@NotNull VirtualFile file) throws IOException {
        Document doc;
        if (file == null) {
            PlatformTestUtil.$$$reportNull$$$0(74);
        }
        if ((doc = FileDocumentManager.getInstance().getDocument(file)) != null) {
            return doc.getText();
        }
        if (!file.getFileType().isBinary() || FileTypeRegistry.getInstance().isFileOfType(file, FileTypes.UNKNOWN)) {
            return LoadTextUtil.getTextByBinaryPresentation((byte[])file.contentsToByteArray(false), (VirtualFile)file).toString();
        }
        return null;
    }

    public static void assertJarFilesEqual(@NotNull VirtualFile fileExpected, @NotNull VirtualFile fileActual) throws IOException {
        if (fileExpected == null) {
            PlatformTestUtil.$$$reportNull$$$0(75);
        }
        if (fileActual == null) {
            PlatformTestUtil.$$$reportNull$$$0(76);
        }
        PlatformTestUtil.assertJarFilesEqual(fileExpected.toNioPath(), fileActual.toNioPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertJarFilesEqual(Path file1, Path file2) throws IOException {
        Path tempDir2 = Files.createTempDirectory("assert_jar_tmp_", new FileAttribute[0]);
        try {
            Path tempDirectory1 = Files.createDirectory(tempDir2.resolve("tmp1"), new FileAttribute[0]);
            Path tempDirectory2 = Files.createDirectory(tempDir2.resolve("tmp2"), new FileAttribute[0]);
            new Decompressor.Zip(file1).extract(tempDirectory1);
            new Decompressor.Zip(file2).extract(tempDirectory2);
            VirtualFile dirAfter = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(tempDirectory1);
            Assert.assertNotNull((String)tempDirectory1.toString(), (Object)dirAfter);
            VirtualFile dirBefore = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(tempDirectory2);
            Assert.assertNotNull((String)tempDirectory2.toString(), (Object)dirBefore);
            ApplicationManager.getApplication().runWriteAction(() -> {
                dirAfter.refresh(false, true);
                dirBefore.refresh(false, true);
            });
            PlatformTestUtil.assertDirectoriesEqual(dirAfter, dirBefore);
        }
        finally {
            NioFiles.deleteRecursively((Path)tempDir2);
        }
    }

    @NotNull
    public static @SystemDependent String getCommunityPath() {
        Path homePath = Path.of(IdeaTestExecutionPolicy.getHomePathWithPolicy(), new String[0]);
        if (Files.isDirectory(homePath.resolve("community/.idea"), new LinkOption[0])) {
            homePath = homePath.resolve("community");
        }
        String string = homePath.toString();
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NotNull
    public static @SystemIndependent String getPlatformTestDataPath() {
        String string = PlatformTestUtil.getCommunityPath().replace('\\', '/') + "/platform/platform-tests/testData/";
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(78);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static Comparator<AbstractTreeNode<?>> createComparator(Queryable.PrintInfo printInfo) {
        Comparator comparator = (o1, o2) -> {
            String displayText1 = o1.toTestString(printInfo);
            String displayText2 = o2.toTestString(printInfo);
            return Comparing.compare((Comparable)((Object)displayText1), (Comparable)((Object)displayText2));
        };
        if (comparator == null) {
            PlatformTestUtil.$$$reportNull$$$0(79);
        }
        return comparator;
    }

    @NotNull
    public static String loadFileText(@NotNull String fileName) throws IOException {
        if (fileName == null) {
            PlatformTestUtil.$$$reportNull$$$0(80);
        }
        String string = StringUtil.convertLineSeparators((String)Files.readString(Path.of(fileName, new String[0])));
        if (string == null) {
            PlatformTestUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    public static void withEncoding(@NotNull String encoding, @NotNull ThrowableRunnable<?> r) {
        if (encoding == null) {
            PlatformTestUtil.$$$reportNull$$$0(82);
        }
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(83);
        }
        PlatformTestUtil.withEncoding(Charset.forName(encoding), r);
    }

    public static void withEncoding(@NotNull Charset encoding, @NotNull ThrowableRunnable<?> r) {
        if (encoding == null) {
            PlatformTestUtil.$$$reportNull$$$0(84);
        }
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(85);
        }
        try {
            Charset oldCharset = Charset.defaultCharset();
            try {
                PlatformTestUtil.patchSystemFileEncoding(encoding.name());
                r.run();
            }
            finally {
                PlatformTestUtil.patchSystemFileEncoding(oldCharset.name());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void patchSystemFileEncoding(String encoding) {
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", encoding);
    }

    public static void withStdErrSuppressed(@NotNull Runnable r) {
        if (r == null) {
            PlatformTestUtil.$$$reportNull$$$0(86);
        }
        PrintStream std = System.err;
        System.setErr(new PrintStream(OutputStream.nullOutputStream()));
        try {
            r.run();
        }
        finally {
            System.setErr(std);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine command) {
        if (command == null) {
            PlatformTestUtil.$$$reportNull$$$0(87);
        }
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command.withRedirectErrorStream(true));
            Assert.assertEquals((String)output.getStdout(), (long)0L, (long)output.getExitCode());
        }
        catch (com.intellij.execution.ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static List<WebReference> collectWebReferences(@NotNull PsiElement element) {
        if (element == null) {
            PlatformTestUtil.$$$reportNull$$$0(88);
        }
        final ArrayList<WebReference> refs = new ArrayList<WebReference>();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiReference ref : element.getReferences()) {
                    if (!(ref instanceof WebReference)) continue;
                    refs.add((WebReference)ref);
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/PlatformTestUtil$1", "visitElement"));
            }
        });
        ArrayList<WebReference> arrayList = refs;
        if (arrayList == null) {
            PlatformTestUtil.$$$reportNull$$$0(89);
        }
        return arrayList;
    }

    @NotNull
    public static List<UrlReference> collectUrlReferences(@NotNull PsiElement element) {
        if (element == null) {
            PlatformTestUtil.$$$reportNull$$$0(90);
        }
        final SmartList result = new SmartList();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                result.addAll(PsiSymbolReferenceService.getService().getReferences(element, UrlReference.class));
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/PlatformTestUtil$2", "visitElement"));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            PlatformTestUtil.$$$reportNull$$$0(91);
        }
        return smartList;
    }

    @NotNull
    public static <T extends PsiReference> T getReferenceOfTypeWithAssertion(@Nullable PsiReference reference, @NotNull Class<T> refType) {
        if (refType == null) {
            PlatformTestUtil.$$$reportNull$$$0(92);
        }
        if (refType.isInstance(reference)) {
            PsiReference t;
            PsiReference psiReference = t = reference;
            if (psiReference == null) {
                PlatformTestUtil.$$$reportNull$$$0(93);
            }
            return (T)psiReference;
        }
        if (reference instanceof PsiMultiReference) {
            PsiReference[] psiReferences;
            for (PsiReference psiReference : psiReferences = ((PsiMultiReference)reference).getReferences()) {
                PsiReference t;
                if (!refType.isInstance(psiReference)) continue;
                PsiReference psiReference2 = t = psiReference;
                if (psiReference2 == null) {
                    PlatformTestUtil.$$$reportNull$$$0(94);
                }
                return (T)psiReference2;
            }
        }
        throw new AssertionError((Object)("given reference should be " + String.valueOf(refType) + " but " + String.valueOf(reference != null ? reference.getClass() : null) + " was given"));
    }

    public static void registerProjectCleanup(@NotNull Runnable cleanup) {
        if (cleanup == null) {
            PlatformTestUtil.$$$reportNull$$$0(95);
        }
        ourProjectCleanups.add(cleanup);
    }

    public static void cleanupAllProjects() {
        for (Runnable each : ourProjectCleanups) {
            each.run();
        }
        ourProjectCleanups.clear();
    }

    public static <T> void assertComparisonContractNotViolated(@NotNull List<? extends T> values, @NotNull Comparator<? super T> comparator, @NotNull BiPredicate<? super T, ? super T> equality) {
        if (values == null) {
            PlatformTestUtil.$$$reportNull$$$0(96);
        }
        if (comparator == null) {
            PlatformTestUtil.$$$reportNull$$$0(97);
        }
        if (equality == null) {
            PlatformTestUtil.$$$reportNull$$$0(98);
        }
        for (int i1 = 0; i1 < values.size(); ++i1) {
            for (int i2 = i1; i2 < values.size(); ++i2) {
                T value1 = values.get(i1);
                T value2 = values.get(i2);
                int result12 = comparator.compare(value1, value2);
                int result21 = comparator.compare(value2, value1);
                if (equality.test(value1, value2)) {
                    if (result12 != 0) {
                        Assert.fail((String)String.format("Equal, but not 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 != 0) {
                        Assert.fail((String)String.format("Equal, but not 0: '%s' - '%s'", value2, value1));
                    }
                } else {
                    if (result12 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value1, value2));
                    }
                    if (result21 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", value2, value1));
                    }
                    if (Integer.signum(result12) == Integer.signum(result21)) {
                        Assert.fail((String)String.format("Not symmetrical: '%s' - '%s'", value1, value2));
                    }
                }
                for (int i3 = i2; i3 < values.size(); ++i3) {
                    int result31;
                    T value3 = values.get(i3);
                    int result23 = comparator.compare(value2, value3);
                    if (PlatformTestUtil.isTransitive(result12, result23, result31 = comparator.compare(value3, value1))) continue;
                    Assert.fail((String)String.format("Not transitive: '%s' - '%s' - '%s'", value1, value2, value3));
                }
            }
        }
    }

    private static boolean isTransitive(int result12, int result23, int result31) {
        if (result12 == 0 && result23 == 0 && result31 == 0) {
            return true;
        }
        if (result12 > 0 && result23 > 0 && result31 > 0) {
            return false;
        }
        if (result12 < 0 && result23 < 0 && result31 < 0) {
            return false;
        }
        if (result12 == 0 && Integer.signum(result23) * Integer.signum(result31) >= 0) {
            return false;
        }
        if (result23 == 0 && Integer.signum(result12) * Integer.signum(result31) >= 0) {
            return false;
        }
        return result31 != 0 || Integer.signum(result23) * Integer.signum(result12) < 0;
    }

    public static void setLongMeaninglessFileIncludeTemplateTemporarilyFor(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            PlatformTestUtil.$$$reportNull$$$0(99);
        }
        if (parentDisposable == null) {
            PlatformTestUtil.$$$reportNull$$$0(100);
        }
        ((FileTemplateManagerImpl)FileTemplateManager.getInstance((Project)project)).setDefaultFileIncludeTemplateTextTemporarilyForTest("File Header", "/**\n * Created by ${USER} on ${DATE}.\n */\n", parentDisposable);
    }

    @NotNull
    public static VirtualFile getOrCreateProjectBaseDir(@NotNull Project project) {
        if (project == null) {
            PlatformTestUtil.$$$reportNull$$$0(101);
        }
        VirtualFile virtualFile = HeavyTestHelper.getOrCreateProjectBaseDir(project);
        if (virtualFile == null) {
            PlatformTestUtil.$$$reportNull$$$0(102);
        }
        return virtualFile;
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(@NotNull PsiElement element, @NotNull RunConfigurationProducer<?> producer) {
        DataContext dataContext;
        ConfigurationContext cc;
        ConfigurationFromContext configuration;
        if (element == null) {
            PlatformTestUtil.$$$reportNull$$$0(103);
        }
        if (producer == null) {
            PlatformTestUtil.$$$reportNull$$$0(104);
        }
        return (configuration = producer.createConfigurationFromContext(cc = ConfigurationContext.getFromContext((DataContext)(dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)element.getProject()).add(PlatformCoreDataKeys.MODULE, (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)element)).add(Location.DATA_KEY, (Object)PsiLocation.fromPsiElement((PsiElement)element)).build()), (String)"unknown"))) != null ? configuration.getConfiguration() : null;
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(105);
        }
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, "Run");
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, long timeoutInSeconds) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(106);
        }
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, "Run", timeoutInSeconds);
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, @NotNull String executorId) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(107);
        }
        if (executorId == null) {
            PlatformTestUtil.$$$reportNull$$$0(108);
        }
        return PlatformTestUtil.executeConfigurationAndWait(runConfiguration, executorId, 60L);
    }

    @NotNull
    public static ExecutionEnvironment executeConfigurationAndWait(@NotNull RunConfiguration runConfiguration, @NotNull String executorId, long timeoutInSeconds) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(109);
        }
        if (executorId == null) {
            PlatformTestUtil.$$$reportNull$$$0(110);
        }
        Pair<ExecutionEnvironment, RunContentDescriptor> result = PlatformTestUtil.executeConfiguration(runConfiguration, executorId, null);
        ProcessHandler processHandler = ((RunContentDescriptor)result.second).getProcessHandler();
        Assert.assertNotNull((String)"Process handler must not be null!", (Object)processHandler);
        PlatformTestUtil.waitWithEventsDispatching(() -> "Process failed to finish in " + timeoutInSeconds + " seconds: " + String.valueOf(processHandler), () -> ((ProcessHandler)processHandler).isProcessTerminated(), Math.toIntExact(timeoutInSeconds), () -> {
            if (!processHandler.isProcessTerminated()) {
                LOG.debug("Destroying process: " + String.valueOf(processHandler));
                processHandler.destroyProcess();
            }
        });
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)result.first;
        if (executionEnvironment == null) {
            PlatformTestUtil.$$$reportNull$$$0(111);
        }
        return executionEnvironment;
    }

    @NotNull
    public static @NotNull Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> executeConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull String executorId, @Nullable Consumer<? super RunContentDescriptor> contentDescriptorProcessor) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(112);
        }
        if (executorId == null) {
            PlatformTestUtil.$$$reportNull$$$0(113);
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        Assert.assertNotNull((String)("Unable to find executor: " + executorId), (Object)executor);
        return PlatformTestUtil.executeConfiguration(runConfiguration, executor, contentDescriptorProcessor);
    }

    @NotNull
    public static @NotNull Pair<@NotNull ExecutionEnvironment, RunContentDescriptor> executeConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull Executor executor, final @Nullable Consumer<? super RunContentDescriptor> descriptorProcessor) throws InterruptedException {
        if (runConfiguration == null) {
            PlatformTestUtil.$$$reportNull$$$0(114);
        }
        if (executor == null) {
            PlatformTestUtil.$$$reportNull$$$0(115);
        }
        Project project = runConfiguration.getProject();
        ConfigurationFactory factory = runConfiguration.getFactory();
        if (factory == null) {
            Assert.fail((String)("No factory found for: " + String.valueOf(runConfiguration)));
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project).createConfiguration(runConfiguration, factory);
        ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConfiguration);
        if (runner == null) {
            Assert.fail((String)("No runner found for: " + executor.getId() + " and " + String.valueOf(runConfiguration)));
        }
        final Ref refRunContentDescriptor = new Ref();
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment(executor, runner, runnerAndConfigurationSettings, project);
        final boolean[] failure = new boolean[]{false};
        ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)executionEnvironment, (boolean)false, (boolean)false, (ProgramRunner.Callback)new ProgramRunner.Callback(){

            public void processNotStarted(@Nullable Throwable error) {
                failure[0] = true;
            }

            public void processStarted(RunContentDescriptor descriptor) {
                final ProcessHandler processHandler = descriptor.getProcessHandler();
                LOG.debug("Process started: ", new Object[]{processHandler});
                if (descriptorProcessor != null) {
                    descriptorProcessor.accept(descriptor);
                }
                Assert.assertNotNull((Object)processHandler);
                processHandler.addProcessListener(new ProcessListener(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LOG.debug("Process notified: ", new Object[]{processHandler});
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        LOG.debug("Process terminated: exitCode: ", new Object[]{event.getExitCode(), "; text: ", event.getText(), "; process: ", processHandler});
                    }

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        LOG.debug(String.valueOf(outputType) + ": " + event.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "startNotified";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                refRunContentDescriptor.set((Object)descriptor);
            }
        });
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        PlatformTestUtil.waitWithEventsDispatching("Process failed to start in 60 seconds", () -> !refRunContentDescriptor.isNull() || failure[0], 60);
        Assert.assertFalse((String)("Process could not start for configuration: " + String.valueOf(runConfiguration)), (boolean)failure[0]);
        Pair pair = Pair.create((Object)executionEnvironment, (Object)((RunContentDescriptor)refRunContentDescriptor.get()));
        if (pair == null) {
            PlatformTestUtil.$$$reportNull$$$0(116);
        }
        return pair;
    }

    @RequiresEdt
    @Nullable
    public static <T> T callOnBgtSynchronously(@NotNull Callable<T> action, int timeoutSeconds) {
        if (action == null) {
            PlatformTestUtil.$$$reportNull$$$0(117);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Future future = ApplicationManager.getApplication().executeOnPooledThread(action);
        PlatformTestUtil.waitWithEventsDispatching("Could not finish the call in " + timeoutSeconds + " seconds", future::isDone, timeoutSeconds);
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitWithEventsDispatching(@NotNull String errorMessage, @NotNull BooleanSupplier condition, int timeoutInSeconds) {
        if (errorMessage == null) {
            PlatformTestUtil.$$$reportNull$$$0(118);
        }
        if (condition == null) {
            PlatformTestUtil.$$$reportNull$$$0(119);
        }
        PlatformTestUtil.waitWithEventsDispatching(() -> errorMessage, condition, timeoutInSeconds);
    }

    public static void waitWithEventsDispatching(@NotNull Supplier<String> errorMessageSupplier, @NotNull BooleanSupplier condition, int timeoutInSeconds) {
        if (errorMessageSupplier == null) {
            PlatformTestUtil.$$$reportNull$$$0(120);
        }
        if (condition == null) {
            PlatformTestUtil.$$$reportNull$$$0(121);
        }
        PlatformTestUtil.waitWithEventsDispatching(errorMessageSupplier, condition, timeoutInSeconds, null);
    }

    public static void waitWithEventsDispatching(@NotNull Supplier<String> errorMessageSupplier, @NotNull BooleanSupplier condition, int timeoutInSeconds, @Nullable Runnable callback) {
        if (errorMessageSupplier == null) {
            PlatformTestUtil.$$$reportNull$$$0(122);
        }
        if (condition == null) {
            PlatformTestUtil.$$$reportNull$$$0(123);
        }
        long start = System.currentTimeMillis();
        try {
            while (true) {
                if (System.currentTimeMillis() - start > (long)timeoutInSeconds * 1000L) {
                    if (callback != null) {
                        callback.run();
                    }
                    Assert.fail((String)errorMessageSupplier.get());
                }
                if (condition.getAsBoolean()) {
                    if (callback != null) {
                        callback.run();
                    }
                    break;
                }
                PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static PsiElement findElementBySignature(@NotNull String signature, @NotNull String fileRelativePath, @NotNull Project project) {
        if (signature == null) {
            PlatformTestUtil.$$$reportNull$$$0(124);
        }
        if (fileRelativePath == null) {
            PlatformTestUtil.$$$reportNull$$$0(125);
        }
        if (project == null) {
            PlatformTestUtil.$$$reportNull$$$0(126);
        }
        Path filePath = Path.of(Objects.requireNonNull(project.getBasePath(), () -> project.toString()), fileRelativePath);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(filePath);
        if (virtualFile == null || !virtualFile.exists()) {
            throw new IllegalArgumentException(String.format("File '%s' doesn't exist", filePath));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        int offset = psiFile.getText().indexOf(signature);
        return psiFile.findElementAt(offset);
    }

    public static void useAppConfigDir(@NotNull ThrowableRunnable<? extends Exception> task2) throws Exception {
        Path configCopy;
        Path configDir;
        if (task2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(127);
        }
        if (Files.exists(configDir = PathManager.getConfigDir(), new LinkOption[0])) {
            configCopy = Files.move(configDir, Paths.get(String.valueOf(configDir) + "_bak", new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        } else {
            NioFiles.deleteRecursively((Path)configDir);
            configCopy = null;
        }
        try {
            task2.run();
        }
        catch (Throwable throwable) {
            NioFiles.deleteRecursively((Path)configDir);
            if (configCopy != null) {
                Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
            }
            throw throwable;
        }
        NioFiles.deleteRecursively((Path)configDir);
        if (configCopy != null) {
            Files.move(configCopy, configDir, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    @NotNull
    public static Project loadAndOpenProject(@NotNull Path path, @NotNull Disposable parent) {
        if (path == null) {
            PlatformTestUtil.$$$reportNull$$$0(128);
        }
        if (parent == null) {
            PlatformTestUtil.$$$reportNull$$$0(129);
        }
        Project project = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().openProject(path, new OpenProjectTaskBuilder().build()));
        Disposer.register((Disposable)parent, () -> PlatformTestUtil.forceCloseProjectWithoutSaving(project));
        IndexingTestUtil.waitUntilIndexesAreReady(project);
        Project project2 = project;
        if (project2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(130);
        }
        return project2;
    }

    public static boolean isUnderCommunityClassPath() {
        return FileTypeManager.getInstance().getStdFileType("JSPX") == FileTypes.PLAIN_TEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void withSystemProperty(@NotNull String key, @Nullable String value2, @NotNull ThrowableRunnable<E> task2) throws E {
        if (key == null) {
            PlatformTestUtil.$$$reportNull$$$0(131);
        }
        if (task2 == null) {
            PlatformTestUtil.$$$reportNull$$$0(132);
        }
        String original = value2 != null ? System.setProperty(key, value2) : System.clearProperty(key);
        try {
            task2.run();
        }
        finally {
            SystemProperties.setProperty((String)key, (String)original);
        }
    }

    public static void assumeEnoughParallelism() throws AssumptionViolatedException {
        int N = Math.min(Runtime.getRuntime().availableProcessors(), Math.min(ForkJoinPool.getCommonPoolParallelism(), ForkJoinPool.commonPool().getParallelism()));
        if (N < 4) {
            throw new AssumptionViolatedException("not enough parallelism, couldn't test parallel performance: available CPU cores=" + Runtime.getRuntime().availableProcessors() + "; FJP configured parallelism=" + ForkJoinPool.getCommonPoolParallelism() + "; FJP actual common pool parallelism=" + ForkJoinPool.commonPool().getParallelism());
        }
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static void waitForAllDocumentsCommitted(long timeout, @NotNull TimeUnit timeUnit) {
        void timeUnit2;
        if (timeUnit == null) {
            PlatformTestUtil.$$$reportNull$$$0(133);
        }
        DocumentCommitThread documentCommitThread = DocumentCommitThread.getInstance();
        TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> PlatformTestUtil.lambda$waitForAllDocumentsCommitted$27(documentCommitThread, timeout, (TimeUnit)timeUnit2));
        PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
    }

    private static /* synthetic */ Unit lambda$waitForAllDocumentsCommitted$27(DocumentCommitThread documentCommitThread, long timeout, TimeUnit timeUnit) {
        documentCommitThread.waitForAllCommits(timeout, timeUnit);
        return Unit.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 12, 14, 38, 42, 45, 47, 55, 56, 57, 65, 77, 78, 79, 81, 89, 91, 93, 94, 102, 111, 116, 130 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 14: 
            case 38: 
            case 42: 
            case 45: 
            case 47: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 102: 
            case 111: 
            case 116: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 5: 
            case 58: 
            case 59: 
            case 60: 
            case 99: 
            case 101: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExtensions";
                break;
            }
            case 7: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 11: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busyCondition";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 35: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePresenter";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 50: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchName";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToMeasure";
                break;
            }
            case 66: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirExpected";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirActual";
                break;
            }
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExpected";
                break;
            }
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileActual";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 83: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 88: 
            case 90: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanup";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 108: 
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 119: 
            case 121: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageSupplier";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRelativePath";
                break;
            }
            case 127: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "lowercaseFirstLetter";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 38: 
            case 42: 
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "print";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "newBenchmarkWithVariableInputSize";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaExe";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getRtJarURL";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNameToFileMap";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityPath";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformTestDataPath";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebReferences";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUrlReferences";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceOfTypeWithAssertion";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectBaseDir";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "executeConfigurationAndWait";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "executeConfiguration";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndOpenProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lowercaseFirstLetter";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 14: 
            case 38: 
            case 42: 
            case 45: 
            case 47: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 102: 
            case 111: 
            case 116: 
            case 130: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAllUppercaseName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "maskExtensions";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "assertTreeEqual";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "waitWhileBusy";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "waitForCallback";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assertPromiseSucceeds";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "waitForFuture";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "waitForSingleAlarm";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "invokeNamedAction";
                break;
            }
            case 50: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "assertTiming";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "newBenchmark";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "newBenchmarkWithVariableInputSize";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "forceCloseProjectWithoutSaving";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "saveProject";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "assertDirectoriesEqual";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "assertFilesEqual";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "fileText";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "assertJarFilesEqual";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "withEncoding";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "withStdErrSuppressed";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "assertSuccessful";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "collectWebReferences";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "collectUrlReferences";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceOfTypeWithAssertion";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectCleanup";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "assertComparisonContractNotViolated";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "setLongMeaninglessFileIncludeTemplateTemporarilyFor";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProjectBaseDir";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfiguration";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "executeConfigurationAndWait";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "callOnBgtSynchronously";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "waitWithEventsDispatching";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "findElementBySignature";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "useAppConfigDir";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "loadAndOpenProject";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "withSystemProperty";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllDocumentsCommitted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 12, 14, 38, 42, 45, 47, 55, 56, 57, 65, 77, 78, 79, 81, 89, 91, 93, 94, 102, 111, 116, 130 -> new IllegalStateException(string);
        };
    }
}

