/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.ThisExp;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.lists.Consumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import java.util.ArrayList;
import kawa.lang.BindDecls;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxForms;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;
import kawa.standard.object;

public class Lambda
extends Syntax {
    public Object optionalKeyword;
    public Object restKeyword;
    public Object keyKeyword;
    static BindDecls defaultBindParser = new LambdaBindDecls();
    public BindDecls bindParser = defaultBindParser;
    public static final Keyword nameKeyword;
    public Expression defaultDefault = QuoteExp.falseExp;

    public void setKeywords(Object optional, Object rest, Object key) {
        this.optionalKeyword = optional;
        this.restKeyword = rest;
        this.keyKeyword = key;
    }

    @Override
    public Expression rewrite(Object obj, Translator tr) {
        if (!(obj instanceof Pair)) {
            return tr.syntaxError("missing formals in lambda");
        }
        int old_errors = tr.getMessages().getErrorCount();
        LambdaExp lexp = new LambdaExp();
        Pair pair = (Pair)obj;
        this.rewrite(lexp, pair.getCar(), pair.getCdr(), tr, null);
        if (tr.getMessages().getErrorCount() > old_errors) {
            return new ErrorExp("bad lambda expression");
        }
        return lexp;
    }

    public void rewrite(LambdaExp lexp, Object formals, Object body, Translator tr, TemplateScope templateScopeRest) {
        lexp.setCallConvention(tr);
        this.rewriteFormals(lexp, formals, tr, templateScopeRest);
        if (body instanceof PairWithPosition) {
            lexp.setFile(((PairWithPosition)body).getFileName());
        }
        body = this.rewriteAttrs(lexp, body, tr);
        this.rewriteBody(lexp, body, tr);
    }

    public void rewriteFormals(LambdaExp lexp, Object formals, Translator tr, TemplateScope templateScopeRest) {
        SyntaxForm sf;
        tr.pushScope(lexp);
        if (lexp.getSymbol() == null) {
            String filename = lexp.getFileName();
            int line = lexp.getLineNumber();
            if (filename != null && line > 0) {
                lexp.setSourceLocation(filename, line);
            }
        }
        Object bindings = formals;
        int opt_args = -1;
        int rest_args = -1;
        int key_args = -1;
        bindings = formals;
        opt_args = -1;
        key_args = -1;
        Object defaultArgs = null;
        ArrayList<Keyword> keywords2 = null;
        Object mode = null;
        Object next = null;
        while (true) {
            Object pccar;
            if (bindings instanceof SyntaxForm) {
                sf = (SyntaxForm)bindings;
                bindings = sf.getDatum();
                templateScopeRest = sf.getScope();
            }
            if (!(bindings instanceof Pair)) break;
            TemplateScope templateScope = templateScopeRest;
            Pair pair = (Pair)bindings;
            Object pair_car = pair.getCar();
            next = pair.getCdr();
            if (pair_car instanceof SyntaxForm) {
                SyntaxForm sf2 = (SyntaxForm)pair_car;
                pair_car = sf2.getDatum();
                templateScope = sf2.getScope();
            }
            if (pair_car == this.optionalKeyword) {
                if (opt_args >= 0) {
                    tr.syntaxError("multiple " + String.valueOf(this.optionalKeyword) + " keywords in parameter list");
                } else if (rest_args >= 0 || key_args >= 0) {
                    tr.syntaxError(this.optionalKeyword.toString() + " after " + String.valueOf(this.restKeyword) + " or " + String.valueOf(this.keyKeyword));
                }
                opt_args = 0;
            } else if (pair_car instanceof Pair && ((pccar = ((Pair)pair_car).getCar()) == LispLanguage.splice_sym || pccar == LispLanguage.splice_colon_sym)) {
                if (rest_args >= 0) {
                    tr.syntaxError("multiple " + String.valueOf(this.restKeyword) + " keywords in parameter list");
                }
                mode = null;
                rest_args = 0;
            } else if (pair_car == this.restKeyword) {
                if (rest_args >= 0) {
                    tr.syntaxError("multiple " + String.valueOf(this.restKeyword) + " keywords in parameter list");
                }
                rest_args = 0;
            } else if (pair_car == this.keyKeyword) {
                if (key_args >= 0) {
                    tr.syntaxError("multiple " + String.valueOf(this.keyKeyword) + " keywords in parameter list");
                }
                key_args = 0;
            } else if (mode == this.keyKeyword) {
                ++key_args;
            } else if (mode == this.restKeyword) {
                if (pair_car != Special.ifk) {
                    ++rest_args;
                }
            } else if (opt_args >= 0) {
                ++opt_args;
            } else if (pair_car != Special.ifk) {
                ++lexp.min_args;
            }
            if (pair_car == this.optionalKeyword || pair_car == this.restKeyword || pair_car == this.keyKeyword) {
                mode = pair_car;
            } else {
                Object[] r;
                Object savePos = tr.pushPositionOf(pair);
                Object name = null;
                Object defaultValue = this.defaultDefault;
                Pair suppliedPair = null;
                Object typeSpecPair = null;
                if (tr.matches(pair_car, "::")) {
                    tr.syntaxError("'::' must follow parameter name");
                    break;
                }
                pair_car = tr.namespaceResolve(pair_car);
                Declaration decl = null;
                if (pair_car instanceof Symbol || pair_car == Special.ifk || this.bindParser.literalPattern(pair_car, tr) != null || pair_car instanceof Pair && (mode == null || (pccar = ((Pair)pair_car).getCar()) == LispLanguage.splice_sym || pccar == LispLanguage.splice_colon_sym) && (Translator.listLength(pair_car) != 3 || !tr.matches(((Pair)((Pair)pair_car).getCdr()).getCar(), "::"))) {
                    r = this.parsePatternCar(pair, templateScope, lexp, tr);
                    next = r[0];
                    decl = (Declaration)r[1];
                    if (decl == null) {
                        decl = new Declaration("<error>");
                    }
                    if (decl.getFlag(0x40000000000L)) {
                        if (rest_args > 0) {
                            tr.syntaxError("multiple rest arguments in parameter list");
                        }
                        rest_args = 1;
                    }
                    name = decl == null ? null : decl.getSymbol();
                } else if (pair_car instanceof Pair) {
                    Pair p;
                    r = this.parsePatternCar((Pair)pair_car, templateScope, lexp, tr);
                    Object xrest = r[0];
                    if (xrest instanceof Pair && mode != null) {
                        p = (Pair)xrest;
                        defaultValue = p.getCar();
                        xrest = p.getCdr();
                    }
                    if (xrest instanceof Pair && mode != null) {
                        p = (Pair)xrest;
                        if (p.getCar() instanceof Symbol) {
                            suppliedPair = p;
                        } else {
                            tr.syntaxError("expected a supplied-parameter name");
                        }
                        xrest = p.getCdr();
                    }
                    if (xrest != LList.Empty) {
                        Object savePos1 = tr.pushPositionOf(r[0]);
                        tr.syntaxError("junk at end of specifier for parameter");
                        tr.popPositionOf(savePos1);
                    }
                    if ((decl = (Declaration)r[1]) == null) {
                        decl = new Declaration("<error>");
                    }
                    name = decl == null ? null : decl.getSymbol();
                    next = pair.getCdr();
                }
                if (decl == null) {
                    if (name == null) {
                        tr.syntaxError("parameter is neither name nor (name :: type) nor (name default): " + String.valueOf(pair));
                        break;
                    }
                    decl = new Declaration(name);
                }
                decl.setFlag(0x80000000000L);
                if (mode == this.optionalKeyword || mode == this.keyKeyword) {
                    decl.setInitValue(new LangExp(defaultValue));
                    if (mode == this.keyKeyword) {
                        if (keywords2 == null) {
                            keywords2 = new ArrayList<Keyword>();
                        }
                        keywords2.add(Keyword.make(name instanceof Symbol ? ((Symbol)name).getName() : name.toString()));
                    }
                }
                Translator.setLine(decl, bindings);
                if (typeSpecPair != null) {
                    decl.setType(new LangExp((Object)typeSpecPair), null);
                    decl.setFlag(8192L);
                }
                if (mode == this.restKeyword && pair_car != Special.ifk) {
                    decl.setFlag(0x40000000000L);
                    if (!decl.getFlag(8192L)) {
                        decl.setType(LangObjType.listType);
                        if (key_args < 0) {
                            decl.setFlag(0x200000000000L);
                            lexp.setFlag(32768);
                        }
                    }
                }
                decl.setFlag(262144L);
                if (suppliedPair != null) {
                    Declaration suppliedDecl = this.addParam((Symbol)suppliedPair.getCar(), templateScope, lexp, tr);
                    decl.setFlag(0x100000000000L);
                    suppliedDecl.setFlag(0x100000000000L);
                    suppliedDecl.setType(Type.booleanType);
                    Translator.setLine(suppliedDecl, (Object)suppliedPair);
                }
                tr.popPositionOf(savePos);
            }
            bindings = next;
        }
        if (bindings instanceof SyntaxForm) {
            sf = (SyntaxForm)bindings;
            bindings = sf.getDatum();
            templateScopeRest = sf.getScope();
        }
        if (bindings instanceof Symbol) {
            if (opt_args >= 0 || key_args >= 0 || rest_args >= 0) {
                tr.syntaxError("dotted rest-arg after " + String.valueOf(this.optionalKeyword) + ", " + String.valueOf(this.restKeyword) + ", or " + String.valueOf(this.keyKeyword));
            } else {
                rest_args = 1;
                Declaration decl = this.addParam((Symbol)bindings, templateScopeRest, lexp, tr);
                decl.setType(LangObjType.listType);
                decl.setFlag(0xC0000040000L);
                decl.setFlag(0x200000000000L);
                lexp.setFlag(32768);
            }
        } else if (bindings != LList.Empty) {
            tr.syntaxError("misformed formals in lambda");
        }
        if (rest_args > 1) {
            tr.syntaxError("multiple " + String.valueOf(this.restKeyword) + " parameters");
            rest_args = 1;
        }
        if (opt_args < 0) {
            opt_args = 0;
        }
        if (rest_args < 0) {
            rest_args = 0;
        }
        if (key_args < 0) {
            key_args = 0;
        }
        lexp.max_args = rest_args > 0 ? -1 : lexp.min_args + opt_args;
        lexp.opt_args = opt_args;
        if (keywords2 != null) {
            lexp.keywords = keywords2.toArray(new Keyword[keywords2.size()]);
        }
    }

    protected Declaration addParam(Symbol name, TemplateScope templateScope, LambdaExp lexp, Translator tr) {
        return this.bindParser.define(name, templateScope, lexp, tr);
    }

    public Object rewriteAttrs(LambdaExp lexp, Object body, Translator tr) {
        String allocationFlagName = null;
        long accessFlag = 0L;
        int allocationFlag = 0;
        SyntaxForm syntax0 = null;
        while (true) {
            Object attrValue;
            Expression attrExpr;
            if (body instanceof SyntaxForm) {
                syntax0 = (SyntaxForm)body;
                body = syntax0.getDatum();
                continue;
            }
            if (!(body instanceof Pair)) break;
            Pair pair1 = (Pair)body;
            Object attrName = Translator.stripSyntax(pair1.getCar());
            if (tr.matches(attrName, "::")) {
                attrName = null;
            } else {
                if (attrName instanceof Pair && Lambda.isAnnotationSymbol(((Pair)attrName).getCar())) {
                    if (lexp.nameDecl == null) {
                        tr.error('e', "annotation for anonymous function");
                    } else {
                        lexp.nameDecl.addAnnotation(new LangExp(pair1));
                    }
                    body = pair1.getCdr();
                    continue;
                }
                if (!(attrName instanceof Keyword)) break;
            }
            SyntaxForm syntax1 = syntax0;
            Object pair1_cdr = pair1.getCdr();
            while (pair1_cdr instanceof SyntaxForm) {
                syntax1 = (SyntaxForm)pair1_cdr;
                pair1_cdr = syntax1.getDatum();
            }
            if (!(pair1_cdr instanceof Pair)) break;
            Pair pair2 = (Pair)pair1_cdr;
            if (attrName == null) {
                if (lexp.isClassMethod() && "*init*".equals(lexp.getName())) {
                    tr.error('e', "explicit return type for '*init*' method");
                } else {
                    lexp.body = new LangExp(new Object[]{pair2, syntax1});
                }
            } else if (attrName == object.accessKeyword) {
                accessFlag = object.addAccessFlags(pair2.getCar(), accessFlag, 223589957632L, "method", tr);
            } else if (attrName == object.allocationKeyword) {
                attrExpr = tr.rewrite_car(pair2, syntax1);
                if (!(attrExpr instanceof QuoteExp) || !((attrValue = ((QuoteExp)attrExpr).getValue()) instanceof SimpleSymbol) && !(attrValue instanceof CharSequence)) {
                    tr.error('e', "allocation: value not a constant symbol or string");
                } else if (lexp.nameDecl == null) {
                    tr.error('e', "allocation: not allowed for anonymous function");
                } else {
                    String value = attrValue.toString();
                    if ("class".equals(value) || "static".equals(value)) {
                        allocationFlag = 2048;
                    } else if ("instance".equals(value)) {
                        allocationFlag = 4096;
                    } else {
                        tr.error('e', "unknown allocation specifier");
                    }
                    if (allocationFlagName != null && value != null) {
                        tr.error('e', "duplicate allocation specifiers - " + allocationFlagName + " and " + value);
                    }
                    allocationFlagName = value;
                }
            } else if (attrName == object.throwsKeyword) {
                attrValue = pair2.getCar();
                int count = Translator.listLength(attrValue);
                if (count < 0) {
                    tr.error('e', "throws: not followed by a list");
                } else {
                    Expression[] exps = new Expression[count];
                    SyntaxForm syntax2 = syntax1;
                    for (int i = 0; i < count; ++i) {
                        while (attrValue instanceof SyntaxForm) {
                            syntax2 = (SyntaxForm)attrValue;
                            attrValue = syntax2.getDatum();
                        }
                        Pair pair3 = (Pair)attrValue;
                        exps[i] = tr.rewrite_car(pair3, syntax2);
                        Translator.setLine(exps[i], (Object)pair3);
                        attrValue = pair3.getCdr();
                    }
                    lexp.setExceptions(exps);
                }
            } else if (attrName == nameKeyword) {
                attrExpr = tr.rewrite_car(pair2, syntax1);
                if (attrExpr instanceof QuoteExp) {
                    lexp.setName(((QuoteExp)attrExpr).getValue().toString());
                }
            } else {
                attrExpr = tr.rewrite_car(pair2, syntax1);
                attrName = ((Keyword)attrName).asSymbol();
                lexp.setProperty(attrName, attrExpr);
            }
            body = pair2.getCdr();
        }
        if ((accessFlag |= (long)allocationFlag) != 0L) {
            lexp.nameDecl.setFlag(accessFlag);
        }
        if (syntax0 != null) {
            body = SyntaxForms.fromDatumIfNeeded(body, syntax0);
        }
        return body;
    }

    public Object skipAttrs(LambdaExp lexp, Object body, Translator tr) {
        Pair pair;
        while (body instanceof Pair && (pair = (Pair)body).getCdr() instanceof Pair) {
            Object attrName = pair.getCar();
            if (tr.matches(attrName, "::")) {
                attrName = null;
            } else if (!(attrName instanceof Keyword)) break;
            body = ((Pair)pair.getCdr()).getCdr();
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteBody(LambdaExp lexp, Object body, Translator tr) {
        int numRenamedAlias = 0;
        if (tr.curMethodLambda == null && lexp.nameDecl != null && tr.getModule().getFlag(0x200000)) {
            tr.curMethodLambda = lexp;
        }
        if (lexp.nameDecl != null) {
            Lambda.rewriteAnnotations(lexp.nameDecl, tr);
        }
        Declaration prev = null;
        int key_args = lexp.keywords == null ? 0 : lexp.keywords.length;
        int opt_args = lexp.opt_args;
        int arg_i = 0;
        tr.lexical.pop(lexp);
        for (Declaration cur = lexp.firstDecl(); cur != null; cur = cur.nextDecl()) {
            Pair typeSpecPair;
            Type t;
            Expression texp;
            if (cur.isAlias()) {
                Declaration param = Translator.getOriginalRef(cur).getBinding();
                lexp.replaceFollowing(prev, param);
                param.context = lexp;
                tr.pushRenamedAlias(cur);
                ++numRenamedAlias;
                cur = param;
            }
            if ((texp = cur.getTypeExpRaw()) instanceof LangExp && (t = tr.exp2Type(typeSpecPair = (Pair)((LangExp)texp).getLangValue(), cur, null)) != null) {
                cur.setType(t);
            }
            prev = cur;
            if (cur.getFlag(0x80000000000L)) {
                Type rstType;
                Expression initValue = cur.getInitValue();
                if (initValue != null) {
                    cur.setInitValue(tr.rewrite(initValue));
                }
                if (cur.getFlag(0x40000000000L) && cur.getFlag(8192L) && ((rstType = cur.getType()) == LangObjType.argListType || rstType == LangObjType.argVectorType)) {
                    cur.setFlag(0x200000000000L);
                    lexp.setFlag(32768);
                }
                ++arg_i;
            }
            tr.lexical.push(cur);
        }
        if (lexp.isClassMethod() && !lexp.nameDecl.getFlag(2048L)) {
            lexp.add(null, new Declaration(ThisExp.THIS_NAME));
        }
        LambdaExp saveLambda = tr.curLambda;
        tr.curLambda = lexp;
        Type rtype = lexp.returnType;
        Object[] tform = lexp.body instanceof LangExp ? (Object[])((LangExp)lexp.body).getLangValue() : null;
        lexp.body = this.auxillaryRewrite(body, tr);
        tr.curLambda = saveLambda;
        try {
            Object val;
            Expression[] exps;
            int len;
            if (tform != null) {
                Expression texp = tr.rewrite_car((Pair)tform[0], (SyntaxForm)tform[1]);
                lexp.setCoercedReturnValue(texp, tr.getLanguage());
            } else if (lexp.body instanceof BeginExp && body instanceof Pair && ((Pair)body).getCar() instanceof Symbol && (len = (exps = ((BeginExp)lexp.body).getExpressions()).length) > 1 && (exps[0] instanceof ReferenceExp || (val = exps[0].valueIfConstant()) instanceof Type || val instanceof Class)) {
                tr.error('w', "deprecated return-type specifier - use '::TYPE'");
                Expression rexp = exps[0];
                if (--len == 1) {
                    lexp.body = exps[1];
                } else {
                    Expression[] new_body = new Expression[len];
                    System.arraycopy(exps, 1, new_body, 0, len);
                    lexp.body = BeginExp.canonicalize(new_body);
                }
                lexp.setCoercedReturnValue(rexp, tr.getLanguage());
            } else {
                lexp.setCoercedReturnType(rtype);
            }
        }
        finally {
            tr.pop(lexp);
            lexp.countDecls();
            tr.popRenamedAlias(numRenamedAlias);
            lexp.countDecls();
        }
        if (tr.curMethodLambda == lexp) {
            tr.curMethodLambda = null;
        }
    }

    public Expression auxillaryRewrite(Object body, Translator tr) {
        return tr.rewrite_body(body);
    }

    @Override
    public void print(Consumer out) {
        out.write("#<builtin lambda>");
    }

    public static boolean isAnnotationSymbol(Object key) {
        String name;
        Pair keyp;
        if (key instanceof Pair && (keyp = (Pair)key).getCar() == LispLanguage.splice_sym) {
            return true;
        }
        return key instanceof SimpleSymbol && (name = ((SimpleSymbol)key).getName()).length() > 1 && name.charAt(0) == '@';
    }

    public static void rewriteAnnotations(Declaration decl, Translator tr) {
        int n = decl.numAnnotations();
        for (int i = 0; i < n; ++i) {
            Expression ann = decl.getAnnotation(i);
            if (!(ann instanceof LangExp)) continue;
            ann = tr.rewrite_car((Pair)((LangExp)ann).getLangValue(), false);
            decl.setAnnotation(i, ann);
        }
    }

    public Object[] parsePatternCar(Pair patList, TemplateScope templateScope, LambdaExp lexp, Translator comp) {
        return this.bindParser.parsePatternCar(patList, null, templateScope, 0, lexp, comp);
    }

    static {
        Lambda.defaultBindParser.allowShadowing = true;
        Lambda.defaultBindParser.makeConstant = false;
        nameKeyword = Keyword.make("name");
    }

    static class LambdaBindDecls
    extends BindDecls {
        LambdaBindDecls() {
        }

        @Override
        public Declaration define(Symbol name, TemplateScope templateScope, ScopeExp lexp, Translator tr) {
            Declaration old;
            Declaration decl0;
            Declaration decl = decl0 = new Declaration(name);
            if (templateScope != null) {
                decl = tr.makeRenamedAlias(decl, templateScope);
            }
            lexp.addDeclaration(decl);
            if (templateScope != null) {
                decl.context = templateScope;
            }
            if ((old = tr.lexical.lookup((Object)name, -1)) != null && old.context == decl.context) {
                ScopeExp.duplicateDeclarationError(old, decl, tr);
            }
            tr.push(decl);
            return decl0;
        }
    }
}

