/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.cache.CaffeineStatsCounter;
import java.util.Objects;
import org.keycloak.Config;
import org.keycloak.cache.LocalCache;
import org.keycloak.cache.LocalCacheConfiguration;
import org.keycloak.cache.LocalCacheProvider;
import org.keycloak.cache.LocalCacheProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultLocalCacheProviderFactory
implements LocalCacheProvider,
LocalCacheProviderFactory {
    public LocalCacheProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "default";
    }

    public <K, V> LocalCache<K, V> create(LocalCacheConfiguration<K, V> configuration) {
        CaffeineStatsCounter metrics = new CaffeineStatsCounter((MeterRegistry)Metrics.globalRegistry, configuration.name());
        Caffeine builder = Caffeine.newBuilder().recordStats(() -> metrics);
        if (configuration.maxSize() > 0) {
            builder.maximumSize((long)configuration.maxSize());
        }
        if (configuration.hasExpiration()) {
            builder.expireAfterAccess(configuration.expiration());
        }
        if (configuration.hasLoader()) {
            LoadingCache cache = builder.build(k -> configuration.loader().apply(k));
            metrics.registerSizeMetric((Cache)cache);
            return new LoadingCaffeineWrapper(cache);
        }
        Cache cache = builder.build();
        metrics.registerSizeMetric(cache);
        return new CaffeineWrapper(cache);
    }

    public void close() {
    }

    private static class LoadingCaffeineWrapper<K, V>
    extends CaffeineWrapper<K, V> {
        final LoadingCache<K, V> cache;

        LoadingCaffeineWrapper(LoadingCache<K, V> cache) {
            super(cache);
            this.cache = cache;
        }

        @Override
        public V get(K key) {
            Objects.requireNonNull(key);
            return (V)this.cache.get(key);
        }
    }

    private static class CaffeineWrapper<K, V>
    implements LocalCache<K, V> {
        final Cache<K, V> cache;

        CaffeineWrapper(Cache<K, V> cache) {
            this.cache = cache;
        }

        public V get(K key) {
            Objects.requireNonNull(key);
            return (V)this.cache.getIfPresent(key);
        }

        public void put(K key, V value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.cache.put(key, value);
        }

        public void invalidate(K key) {
            Objects.requireNonNull(key);
            this.cache.invalidate(key);
        }

        public void close() {
            this.cache.cleanUp();
        }
    }
}

