/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.logstash.health.Diagnosis;
import org.logstash.health.Impact;
import org.logstash.health.ProbeIndicator;
import org.logstash.health.Status;

public interface Probe<OBSERVATION extends ProbeIndicator.Observation> {
    public Analysis analyze(OBSERVATION var1);

    public static final class Analysis {
        public final Status status;
        public final Diagnosis diagnosis;
        public final Impact impact;

        Analysis(Builder builder) {
            this.status = builder.status;
            this.diagnosis = builder.diagnosis;
            this.impact = builder.impact;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final Status status;
            private final Diagnosis diagnosis;
            private final Impact impact;

            public Builder() {
                this(Status.GREEN, null, null);
            }

            public Builder(Status status, Diagnosis diagnosis, Impact impact) {
                this.status = status;
                this.diagnosis = diagnosis;
                this.impact = impact;
            }

            public Builder withStatus(Status status) {
                if (Objects.equals((Object)this.status, (Object)status)) {
                    return this;
                }
                return new Builder(status, this.diagnosis, this.impact);
            }

            public Builder withDiagnosis(Diagnosis diagnosis) {
                if (Objects.equals(this.diagnosis, diagnosis)) {
                    return this;
                }
                return new Builder(this.status, diagnosis, this.impact);
            }

            public Builder withDiagnosis(UnaryOperator<Diagnosis.Builder> diagnosisConfigurator) {
                return this.withDiagnosis(Diagnosis.builder().transform(diagnosisConfigurator).build());
            }

            public synchronized Builder withImpact(Impact impact) {
                if (Objects.equals(this.impact, impact)) {
                    return this;
                }
                return new Builder(this.status, this.diagnosis, impact);
            }

            public Builder withImpact(UnaryOperator<Impact.Builder> impactConfigurator) {
                return this.withImpact(Impact.builder().transform(impactConfigurator).build());
            }

            public synchronized Analysis build() {
                return new Analysis(this);
            }
        }
    }
}

