/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.exceptions;

import com.igormaznitsa.jbbp.exceptions.JBBPCompilationException;

public class JBBPTokenizerException
extends JBBPCompilationException {
    private static final long serialVersionUID = -1132154077305893246L;
    private final int position;
    private final String errorPart;

    public JBBPTokenizerException(String message, String script, int pos) {
        super(message);
        this.errorPart = script == null ? "" : JBBPTokenizerException.extractErrorPartText(script, pos);
        this.position = pos;
    }

    private static String extractErrorPartText(String script, int errorPosition) {
        if (errorPosition >= script.length() || errorPosition < 0) {
            return "";
        }
        int maxLengthWing = 16;
        StringBuilder buffer = new StringBuilder();
        buffer.append(script.charAt(errorPosition));
        int errorPositionAtBuffer = 0;
        int leftPosition = errorPosition - 1;
        int rightPosition = errorPosition + 1;
        int leftNonSpaceCounter = 0;
        int rightNonSpaceCounter = 0;
        for (int i = 0; i < 16; ++i) {
            char chr;
            if (leftPosition >= 0) {
                chr = script.charAt(leftPosition);
                if (Character.isISOControl(chr) || i > 2 && leftNonSpaceCounter > 0 && Character.isSpaceChar(chr)) {
                    leftPosition = -1;
                } else {
                    buffer.insert(0, chr);
                    leftNonSpaceCounter += Character.isSpaceChar(chr) ? 1 : 0;
                    ++errorPositionAtBuffer;
                    --leftPosition;
                }
            }
            if (rightPosition < 0 || rightPosition >= script.length()) continue;
            chr = script.charAt(rightPosition);
            if (Character.isISOControl(chr) || i > 2 && rightNonSpaceCounter > 0 && Character.isSpaceChar(chr)) {
                rightPosition = -1;
                continue;
            }
            buffer.append(chr);
            rightNonSpaceCounter += Character.isSpaceChar(chr) ? 1 : 0;
            ++rightPosition;
        }
        String errorMarkerLeft = " ->";
        String errorMarkerRight = "<- ";
        buffer.insert(errorPositionAtBuffer + 1, "<- ");
        buffer.insert(errorPositionAtBuffer, " ->");
        if (Character.isISOControl(buffer.charAt(errorPositionAtBuffer += " ->".length()))) {
            Object hex = Integer.toHexString(buffer.charAt(errorPositionAtBuffer));
            hex = "\\u" + "0000".substring(((String)hex).length()) + (String)hex;
            buffer.delete(errorPositionAtBuffer, errorPositionAtBuffer + 1);
            buffer.insert(errorPositionAtBuffer, (String)hex);
        }
        return buffer.toString().trim();
    }

    public String getErrorPart() {
        return this.errorPart;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return this.getLocalizedMessage() + " (pos=" + this.position + ", errorPart=\"" + this.errorPart + "\")";
    }
}

