/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.provider.utils.EelProcessExecutionResultInfo;
import com.intellij.platform.eel.provider.utils.EelProcessUtilsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.SdkUiUtilKt;
import com.jetbrains.python.errorProcessing.Exe;
import com.jetbrains.python.errorProcessing.ExecErrorImpl;
import com.jetbrains.python.errorProcessing.ExecErrorReason;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.impl.PySdkBundle;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public abstract class PyPackageManagementService
extends PackageManagementServiceEx {
    @NotNull
    private static final Pattern PATTERN_ERROR_LINE = Pattern.compile(".*error:.*", 2);
    @NonNls
    protected static final String TEXT_PREFIX = PyPackageManagementService.buildHtmlStylePrefix();
    @NonNls
    private static final String TEXT_SUFFIX = "</body></html>";
    @NotNull
    private final Project myProject;
    @NotNull
    protected final Sdk mySdk;
    protected final ExecutorService myExecutorService;
    @NonNls
    private static final String HTML_PREFIX = "<a href=\"";
    @NonNls
    private static final String HTML_SUFFIX = "</a>";

    @NotNull
    private static String buildHtmlStylePrefix() {
        int fontSize = JBUIScale.scale((int)12);
        int m1 = JBUIScale.scale((int)2);
        int m2 = JBUIScale.scale((int)5);
        String string = String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PyPackageManagementService(@NotNull Project project, @NotNull Sdk sdk2) {
        if (project == null) {
            PyPackageManagementService.$$$reportNull$$$0(1);
        }
        if (sdk2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySdk = sdk2;
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PyPackageManagementService Pool", (int)4);
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk2 = this.mySdk;
        if (sdk2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(3);
        }
        return sdk2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PyPackageManagementService.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Nullable
    public List<String> getAllRepositories() {
        ArrayList<String> result2 = new ArrayList<String>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            result2.add("https://pypi.org/simple/");
        }
        result2.addAll(PyPackageManagementService.getAdditionalRepositories());
        return result2;
    }

    public void addRepository(String repositoryUrl) {
        PyPackageService.getInstance().addRepository(repositoryUrl);
    }

    public void removeRepository(String repositoryUrl) {
        PyPackageService.getInstance().removeRepository(repositoryUrl);
    }

    @NotNull
    public List<RepoPackage> getAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.loadPackages();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.getAdditionalRepositories(), false);
        List list = this.getAllPackagesCached();
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<RepoPackage> reloadAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.updatePyPICache();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.getAdditionalRepositories(), true);
        List list = this.getAllPackagesCached();
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<String> getAdditionalRepositories() {
        List<String> list = PyPackageService.getInstance().additionalRepositories;
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean canInstallToUser() {
        return !SdkUiUtilKt.isVirtualEnv(this.mySdk);
    }

    @NotNull
    public String getInstallToUserText() {
        Object userSiteText = PyBundle.message("button.install.to.user.site.packages.directory", new Object[0]);
        if (!PythonSdkUtil.isRemote((Sdk)this.mySdk)) {
            userSiteText = (String)userSiteText + " (" + PythonSdkUtil.getUserSite() + ")";
        }
        String string = userSiteText;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isInstallToUserSelected() {
        return PyPackageService.getInstance().useUserSite(this.mySdk.getHomePath());
    }

    public void installToUserChanged(boolean newValue) {
        PyPackageService.getInstance().addSdkToUserSite(this.mySdk.getHomePath(), newValue);
    }

    @Nullable
    public static PackageManagementService.ErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk2) {
        return PyPackageManagementService.toErrorDescription(exceptions, sdk2, null);
    }

    @Nullable
    public static PyPackageInstallationErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk2, @Nullable String packageName) {
        if (exceptions != null && !exceptions.isEmpty() && !PyPackageManagementService.isCancelled(exceptions)) {
            return PyPackageManagementService.createDescription(exceptions.get(0), sdk2, packageName);
        }
        return null;
    }

    public void uninstallPackages(List<? extends InstalledPackage> installedPackages2, final @NotNull PackageManagementService.Listener listener2) {
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(9);
        }
        final String packageName = installedPackages2.size() == 1 ? installedPackages2.get(0).getName() : null;
        PyPackageManagerUI ui = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(packageName);
            }

            @Override
            public void finished(List<ExecutionException> exceptions) {
                listener2.operationFinished(packageName, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ArrayList<PyPackage> pyPackages = new ArrayList<PyPackage>();
        for (InstalledPackage installedPackage : installedPackages2) {
            if (!(installedPackage instanceof PyPackage)) continue;
            pyPackages.add((PyPackage)installedPackage);
        }
        ui.uninstall(pyPackages);
    }

    public void fetchPackageVersions(String packageName, CatchingConsumer<? super List<String>, ? super Exception> consumer) {
        PyPIPackageUtil.INSTANCE.usePackageReleases(packageName, consumer);
    }

    public void fetchPackageDetails(@NotNull String packageName, final CatchingConsumer<? super @Nls String, ? super Exception> consumer) {
        if (packageName == null) {
            PyPackageManagementService.$$$reportNull$$$0(10);
        }
        PyPIPackageUtil.INSTANCE.fillPackageDetails(packageName, new CatchingConsumer<PyPIPackageUtil.PackageDetails.Info, Exception>(this){

            public void consume(PyPIPackageUtil.PackageDetails.Info details) {
                consumer.consume((Object)PyPackageManagementService.formatPackageInfo(details));
            }

            public void consume(Exception e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    private static String formatPackageInfo(@NotNull PyPIPackageUtil.PackageDetails.Info info) {
        String homePage;
        String authorEmail;
        String author;
        String version2;
        if (info == null) {
            PyPackageManagementService.$$$reportNull$$$0(11);
        }
        StringBuilder stringBuilder = new StringBuilder(TEXT_PREFIX);
        String description = info.getSummary();
        if (StringUtil.isNotEmpty((String)description)) {
            stringBuilder.append(description).append("<br/>");
        }
        if (StringUtil.isNotEmpty((String)(version2 = info.getVersion()))) {
            stringBuilder.append("<h4>Version</h4>");
            stringBuilder.append(version2);
        }
        if (StringUtil.isNotEmpty((String)(author = info.getAuthor()))) {
            stringBuilder.append("<h4>Author</h4>");
            stringBuilder.append(author).append("<br/><br/>");
        }
        if (StringUtil.isNotEmpty((String)(authorEmail = info.getAuthorEmail()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref("mailto:" + authorEmail));
        }
        if (StringUtil.isNotEmpty((String)(homePage = info.getHomePage()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref(homePage));
        }
        stringBuilder.append(TEXT_SUFFIX);
        return stringBuilder.toString();
    }

    @NotNull
    private static String composeHref(String vendorUrl) {
        String string = HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean isCancelled(@NotNull List<ExecutionException> exceptions) {
        if (exceptions == null) {
            PyPackageManagementService.$$$reportNull$$$0(13);
        }
        for (ExecutionException e : exceptions) {
            if (!(e instanceof RunCanceledByUserException)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static PyPackageInstallationErrorDescription createDescription(@NotNull ExecutionException e, @Nullable Sdk sdk2, @Nullable String packageName) {
        ExecErrorImpl execError;
        PyExecutionException pyExecEx;
        PyError pyError;
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(14);
        }
        if (e instanceof PyExecutionException && (pyError = (pyExecEx = (PyExecutionException)e).getPyError()) instanceof ExecErrorImpl && (pyError = (execError = (ExecErrorImpl)pyError).getErrorReason()) instanceof ExecErrorReason.UnexpectedProcessTermination) {
            ExecErrorReason.UnexpectedProcessTermination execFailed = (ExecErrorReason.UnexpectedProcessTermination)pyError;
            String stdout = EelProcessUtilsKt.getStdoutString((EelProcessExecutionResultInfo)execFailed);
            String stderr = EelProcessUtilsKt.getStderrString((EelProcessExecutionResultInfo)execFailed);
            String stdoutCause = PyPackageManagementService.findErrorCause(stdout);
            String stderrCause = PyPackageManagementService.findErrorCause(stderr);
            String cause = stdoutCause != null ? stdoutCause : stderrCause;
            String message = cause != null ? cause : pyExecEx.getMessage();
            String command = execError.getAsCommand();
            return new PyPackageInstallationErrorDescription(message, command, (String)(stdout.isEmpty() ? stderr : stdout + "\n" + stderr), PyPackageManagementService.findErrorSolution(pyExecEx, cause, sdk2), packageName, sdk2);
        }
        return new PyPackageInstallationErrorDescription(e.getMessage(), null, null, null, packageName, sdk2);
    }

    @NlsContexts.DetailedDescription
    @Nullable
    private static String findErrorSolution(@NotNull PyExecutionException executionException, @Nullable String cause, @Nullable Sdk sdk2) {
        PyError pyError;
        if (executionException == null) {
            PyPackageManagementService.$$$reportNull$$$0(15);
        }
        if ((pyError = executionException.getPyError()) instanceof ExecErrorImpl) {
            Exe.OnEel exeOnEel;
            Exe fileName;
            ExecErrorImpl e = (ExecErrorImpl)pyError;
            if (cause != null && StringUtil.containsIgnoreCase((String)cause, (String)"SyntaxError")) {
                LanguageLevel languageLevel = PySdkUtil.getLanguageLevelForSdk((Sdk)sdk2);
                return PySdkBundle.message((String)"python.sdk.use.python.version.supported.by.this.package", (Object[])new Object[]{languageLevel});
            }
            ExecErrorReason execErrorReason = e.getErrorReason();
            if (execErrorReason instanceof ExecErrorReason.UnexpectedProcessTermination) {
                ExecErrorReason.UnexpectedProcessTermination unexpectedProcessTermination = (ExecErrorReason.UnexpectedProcessTermination)execErrorReason;
                if (SystemInfo.isLinux && (PyPackageManagementService.containsInOutput(unexpectedProcessTermination, "pyconfig.h") || PyPackageManagementService.containsInOutput(unexpectedProcessTermination, "Python.h"))) {
                    return PySdkBundle.message((String)"python.sdk.check.python.development.packages.installed", (Object[])new Object[0]);
                }
            }
            if ((fileName = e.getExe()) instanceof Exe.OnEel && (exeOnEel = (Exe.OnEel)fileName).getEelPath().getFileName().startsWith("pip") && sdk2 != null) {
                return PySdkBundle.message((String)"python.sdk.try.to.run.command.from.system.terminal", (Object[])new Object[]{sdk2.getHomePath()});
            }
        }
        return null;
    }

    private static boolean containsInOutput(@NotNull ExecErrorReason.UnexpectedProcessTermination e, @NotNull String text) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(16);
        }
        if (text == null) {
            PyPackageManagementService.$$$reportNull$$$0(17);
        }
        return StringUtil.containsIgnoreCase((String)EelProcessUtilsKt.getStdoutString((EelProcessExecutionResultInfo)e), (String)text) || StringUtil.containsIgnoreCase((String)EelProcessUtilsKt.getStderrString((EelProcessExecutionResultInfo)e), (String)text);
    }

    @Nullable
    private static String findErrorCause(@NotNull String output2) {
        Matcher m;
        if (output2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(18);
        }
        if ((m = PATTERN_ERROR_LINE.matcher(output2)).find()) {
            String result2 = m.group();
            return result2 != null ? result2.trim() : null;
        }
        return null;
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version2, @NotNull PackageManagementService.Listener listener2) {
        if (installedPackage == null) {
            PyPackageManagementService.$$$reportNull$$$0(19);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(20);
        }
        this.installPackage(new RepoPackage(installedPackage.getName(), null), version2, true, null, listener2, false);
    }

    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<? super String, ? super Exception> consumer) {
        if (pkg == null) {
            PyPackageManagementService.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            PyPackageManagementService.$$$reportNull$$$0(22);
        }
        this.myExecutorService.execute(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            try {
                PyPIPackageUtil.INSTANCE.loadPackages();
                String version2 = PyPIPackageUtil.INSTANCE.fetchLatestPackageVersion(this.myProject, pkg.getName());
                consumer.consume((Object)StringUtil.notNullize((String)version2));
            }
            catch (IOException e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PyPackageManagementService.$$$reportNull$$$0(23);
        }
        if (version2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(24);
        }
        return PyPackageVersionComparator.getSTR_COMPARATOR().compare(version1, version2);
    }

    @Nullable
    public String getID() {
        return "Python";
    }

    public boolean canManageRepositories() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionException";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlStylePrefix";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAllPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRepositories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallToUserText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "composeHref";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPackages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDetails";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatPackageInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCancelled";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findErrorSolution";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "containsInOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findErrorCause";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updatePackage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestVersion";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }

    public static class PyPackageInstallationErrorDescription
    extends PackageManagementService.ErrorDescription {
        @Nullable
        private final String myPackageName;
        @Nullable
        private final String myPythonVersion;
        @Nullable
        private final String myInterpreterPath;
        @Nullable
        private final Sdk mySdk;

        public PyPackageInstallationErrorDescription(@NlsContexts.DetailedDescription @NotNull String message, @Nullable String command, @Nullable String output2, @NlsContexts.DetailedDescription @Nullable String solution, @Nullable String packageName, @Nullable Sdk sdk2) {
            if (message == null) {
                PyPackageInstallationErrorDescription.$$$reportNull$$$0(0);
            }
            super(message, command, output2, solution);
            this.myPackageName = packageName;
            this.mySdk = sdk2;
            this.myPythonVersion = sdk2 != null ? sdk2.getVersionString() : null;
            this.myInterpreterPath = sdk2 != null ? sdk2.getHomePath() : null;
        }

        @Nullable
        public static PyPackageInstallationErrorDescription createFromMessage(@NlsContexts.DetailedDescription @Nullable String message) {
            return message != null ? new PyPackageInstallationErrorDescription(message, null, null, null, null, null) : null;
        }

        @Nullable
        @NlsSafe
        public String getPackageName() {
            return this.myPackageName;
        }

        @Nullable
        @NlsSafe
        public String getPythonVersion() {
            return this.myPythonVersion;
        }

        @Nullable
        @NlsSafe
        public String getInterpreterPath() {
            return this.myInterpreterPath;
        }

        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/packaging/ui/PyPackageManagementService$PyPackageInstallationErrorDescription", "<init>"));
        }
    }
}

