/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.RemoteServerObject;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.network.RemotePostData;
import com.jetbrains.cef.remote.thrift_codegen.PostData;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.util.Map;
import org.cef.misc.CefLog;
import org.cef.network.CefPostData;
import org.cef.network.CefRequest;

public class RemoteRequestImpl
extends RemoteServerObject {
    public RemoteRequestImpl(RpcContext rpcContext, RObject request) {
        super(rpcContext, request);
    }

    @Override
    protected void disposeOnServerImpl() {
        this.myRpc.invokeLater(s -> s.Request_Dispose(this.myId));
    }

    @Override
    public void flush() {
        this.myRpc.exec(s -> s.Request_Update(this.thriftIdWithCache()));
    }

    public long getIdentifier() {
        return this.getLongVal("Identifier");
    }

    public boolean isReadOnly() {
        return this.getBoolVal("IsReadOnly");
    }

    public String getURL() {
        return (String)this.myCache.get("URL");
    }

    public void setURL(String url) {
        this.setStrVal("URL", url);
    }

    public String getMethod() {
        return (String)this.myCache.get("Method");
    }

    public void setMethod(String method) {
        this.setStrVal("Method", method);
    }

    public void setReferrer(String url, CefRequest.ReferrerPolicy policy) {
        this.setStrVal("ReferrerURL", url);
        this.setStrVal("ReferrerPolicy", policy == null ? null : policy.name());
    }

    public String getReferrerURL() {
        return (String)this.myCache.get("ReferrerURL");
    }

    public CefRequest.ReferrerPolicy getReferrerPolicy() {
        String sval = (String)this.myCache.get("ReferrerPolicy");
        if (sval != null && !sval.isEmpty()) {
            try {
                return CefRequest.ReferrerPolicy.valueOf(sval);
            }
            catch (Throwable e) {
                CefLog.Error("getReferrerPolicy: sval=%s, exception: %s", sval, e.getMessage());
            }
        }
        return null;
    }

    public CefPostData getPostData() {
        PostData pd = this.myRpc.execObj(s -> s.Request_GetPostData(this.thriftId()));
        return pd == null || pd.isNull ? null : new RemotePostData(pd);
    }

    public void setPostData(CefPostData postData) {
        this.myRpc.exec(s -> s.Request_SetPostData(this.thriftId(), RemotePostData.toThriftWithMap(postData)));
    }

    public void set(String url, String method, CefPostData postData, Map<String, String> headerMap) {
        this.myRpc.exec(s -> s.Request_Set(this.thriftId(), url, method, RemotePostData.toThriftWithMap(postData), headerMap));
    }

    public String getHeaderByName(String name) {
        return this.myRpc.execObj(s -> s.Request_GetHeaderByName(this.thriftId(), name));
    }

    public void setHeaderByName(String name, String value, boolean overwrite) {
        this.myRpc.exec(s -> s.Request_SetHeaderByName(this.thriftId(), name, value, overwrite));
    }

    public void getHeaderMap(Map<String, String> headerMap) {
        if (headerMap == null) {
            return;
        }
        Map result = this.myRpc.execObj(s -> s.Request_GetHeaderMap(this.thriftId()));
        if (result != null) {
            headerMap.putAll(result);
        }
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.myRpc.exec(s -> s.Request_SetHeaderMap(this.thriftId(), headerMap));
    }

    public int getFlags() {
        return (int)this.getLongVal("Flags");
    }

    public void setFlags(int flags) {
        this.setLongVal("Flags", flags);
    }

    public String getFirstPartyForCookies() {
        return (String)this.myCache.get("FirstPartyForCookies");
    }

    public void setFirstPartyForCookies(String url) {
        this.setStrVal("FirstPartyForCookies", url);
    }

    public CefRequest.ResourceType getResourceType() {
        String sval = (String)this.myCache.get("ResourceType");
        if (sval != null && !sval.isEmpty()) {
            try {
                return CefRequest.ResourceType.valueOf(sval);
            }
            catch (Throwable e) {
                CefLog.Error("getResourceType: sval=%s, exception: %s", sval, e.getMessage());
            }
        }
        return null;
    }

    public CefRequest.TransitionType getTransitionType() {
        int TT_SOURCE_MASK = 255;
        int rawVal = (int)this.getLongVal("TransitionType");
        int source = rawVal & 0xFF;
        CefRequest.TransitionType result = null;
        switch (source) {
            case 0: {
                result = CefRequest.TransitionType.TT_LINK;
                break;
            }
            case 1: {
                result = CefRequest.TransitionType.TT_EXPLICIT;
                break;
            }
            case 3: {
                result = CefRequest.TransitionType.TT_AUTO_SUBFRAME;
                break;
            }
            case 4: {
                result = CefRequest.TransitionType.TT_MANUAL_SUBFRAME;
                break;
            }
            case 7: {
                result = CefRequest.TransitionType.TT_FORM_SUBMIT;
                break;
            }
            case 8: {
                result = CefRequest.TransitionType.TT_RELOAD;
                break;
            }
            default: {
                CefLog.Debug("getTransitionType: can't find TransitionType enum: nval=%d, source=%d", rawVal, source);
            }
        }
        if (result != null) {
            int TT_QUALIFIER_MASK = -256;
            int qualifiers = rawVal & 0xFFFFFF00;
            result.addQualifiers(qualifiers);
        }
        return result;
    }

    public String toString() {
        return this.myCache.toString();
    }
}

