/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.fileio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.time.Duration;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.fileio.FileIONode;
import org.graalvm.visualvm.jfr.views.fileio.FileIORenderers;
import org.graalvm.visualvm.jfr.views.fileio.JFRSnapshotFileIOViewProvider;
import org.graalvm.visualvm.lib.ui.components.HTMLLabel;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

final class FileIOViewSupport {
    FileIOViewSupport() {
    }

    static final class DataViewSupport
    extends JPanel {
        private DataModel tableModel;
        private ProfilerTreeTable table;

        DataViewSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Data", null, 10, (JComponent)this, null);
        }

        void setData(FileIONode root, boolean twoAggregations) {
            this.tableModel.setRoot((TreeNode)((Object)root));
            this.table.setShowsRootHandles(twoAggregations);
        }

        private void initComponents() {
            this.tableModel = new DataModel();
            this.table = new ProfilerTreeTable((ProfilerTreeTableModel)this.tableModel, true, true, new int[]{0});
            this.table.setRootVisible(false);
            this.table.setShowsRootHandles(true);
            this.table.setMainColumn(0);
            this.table.setFitWidthColumn(0);
            this.table.setSortColumn(1);
            this.table.setDefaultSortOrder(SortOrder.DESCENDING);
            this.table.setDefaultSortOrder(0, SortOrder.ASCENDING);
            FileIORenderers.NameRenderer nameRenderer = new FileIORenderers.NameRenderer();
            this.table.setTreeCellRenderer((ProfilerRenderer)nameRenderer);
            FileIORenderers.TotalTimeRenderer totalTimeRenderer = new FileIORenderers.TotalTimeRenderer();
            this.table.setColumnRenderer(1, (ProfilerRenderer)totalTimeRenderer);
            this.table.setDefaultColumnWidth(1, totalTimeRenderer.getPreferredWidth());
            this.table.setColumnVisibility(1, FileIORenderers.TotalTimeRenderer.isInitiallyVisible());
            FileIORenderers.ReadTimeRenderer readTimeRenderer = new FileIORenderers.ReadTimeRenderer();
            this.table.setColumnRenderer(2, (ProfilerRenderer)readTimeRenderer);
            this.table.setDefaultColumnWidth(2, readTimeRenderer.getPreferredWidth());
            this.table.setColumnVisibility(2, FileIORenderers.ReadTimeRenderer.isInitiallyVisible());
            FileIORenderers.MaxReadTimeRenderer maxReadTimeRenderer = new FileIORenderers.MaxReadTimeRenderer();
            this.table.setColumnRenderer(3, (ProfilerRenderer)maxReadTimeRenderer);
            this.table.setDefaultColumnWidth(3, maxReadTimeRenderer.getPreferredWidth());
            this.table.setColumnVisibility(3, FileIORenderers.MaxReadTimeRenderer.isInitiallyVisible());
            FileIORenderers.WriteTimeRenderer writeTimeRenderer = new FileIORenderers.WriteTimeRenderer();
            this.table.setColumnRenderer(4, (ProfilerRenderer)writeTimeRenderer);
            this.table.setDefaultColumnWidth(4, writeTimeRenderer.getPreferredWidth());
            this.table.setColumnVisibility(4, FileIORenderers.WriteTimeRenderer.isInitiallyVisible());
            FileIORenderers.MaxWriteTimeRenderer maxWriteTimeRenderer = new FileIORenderers.MaxWriteTimeRenderer();
            this.table.setColumnRenderer(5, (ProfilerRenderer)maxWriteTimeRenderer);
            this.table.setDefaultColumnWidth(5, maxWriteTimeRenderer.getPreferredWidth());
            this.table.setColumnVisibility(5, FileIORenderers.MaxWriteTimeRenderer.isInitiallyVisible());
            FileIORenderers.TotalCountRenderer totalCountRenderer = new FileIORenderers.TotalCountRenderer();
            this.table.setColumnRenderer(6, (ProfilerRenderer)totalCountRenderer);
            this.table.setDefaultColumnWidth(6, totalCountRenderer.getPreferredWidth());
            this.table.setColumnVisibility(6, FileIORenderers.TotalCountRenderer.isInitiallyVisible());
            FileIORenderers.ReadCountRenderer readCountRenderer = new FileIORenderers.ReadCountRenderer();
            this.table.setColumnRenderer(7, (ProfilerRenderer)readCountRenderer);
            this.table.setDefaultColumnWidth(7, readCountRenderer.getPreferredWidth());
            this.table.setColumnVisibility(7, FileIORenderers.ReadCountRenderer.isInitiallyVisible());
            FileIORenderers.WriteCountRenderer writeCountRenderer = new FileIORenderers.WriteCountRenderer();
            this.table.setColumnRenderer(8, (ProfilerRenderer)writeCountRenderer);
            this.table.setDefaultColumnWidth(8, writeCountRenderer.getPreferredWidth());
            this.table.setColumnVisibility(8, FileIORenderers.WriteCountRenderer.isInitiallyVisible());
            FileIORenderers.ReadBytesRenderer readBytesRenderer = new FileIORenderers.ReadBytesRenderer();
            this.table.setColumnRenderer(9, (ProfilerRenderer)readBytesRenderer);
            this.table.setDefaultColumnWidth(9, readBytesRenderer.getPreferredWidth());
            this.table.setColumnVisibility(9, FileIORenderers.ReadBytesRenderer.isInitiallyVisible());
            FileIORenderers.WriteBytesRenderer writeBytesRenderer = new FileIORenderers.WriteBytesRenderer();
            this.table.setColumnRenderer(10, (ProfilerRenderer)writeBytesRenderer);
            this.table.setDefaultColumnWidth(10, writeBytesRenderer.getPreferredWidth());
            this.table.setColumnVisibility(10, FileIORenderers.WriteBytesRenderer.isInitiallyVisible());
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer((ProfilerTable)this.table, false, null), "Center");
        }

        private static class DataModel
        extends ProfilerTreeTableModel.Abstract {
            DataModel() {
                super((TreeNode)((Object)new FileIONode.Root()));
            }

            public int getColumnCount() {
                return 11;
            }

            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return JTree.class;
                    }
                    case 1: {
                        return Duration.class;
                    }
                    case 2: {
                        return Duration.class;
                    }
                    case 3: {
                        return Duration.class;
                    }
                    case 4: {
                        return Duration.class;
                    }
                    case 5: {
                        return Duration.class;
                    }
                    case 6: {
                        return Long.class;
                    }
                    case 7: {
                        return Long.class;
                    }
                    case 8: {
                        return Long.class;
                    }
                    case 9: {
                        return Long.class;
                    }
                    case 10: {
                        return Long.class;
                    }
                }
                return null;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return FileIORenderers.NameRenderer.getDisplayName();
                    }
                    case 1: {
                        return FileIORenderers.TotalTimeRenderer.getDisplayName();
                    }
                    case 2: {
                        return FileIORenderers.ReadTimeRenderer.getDisplayName();
                    }
                    case 3: {
                        return FileIORenderers.MaxReadTimeRenderer.getDisplayName();
                    }
                    case 4: {
                        return FileIORenderers.WriteTimeRenderer.getDisplayName();
                    }
                    case 5: {
                        return FileIORenderers.MaxWriteTimeRenderer.getDisplayName();
                    }
                    case 6: {
                        return FileIORenderers.TotalCountRenderer.getDisplayName();
                    }
                    case 7: {
                        return FileIORenderers.ReadCountRenderer.getDisplayName();
                    }
                    case 8: {
                        return FileIORenderers.WriteCountRenderer.getDisplayName();
                    }
                    case 9: {
                        return FileIORenderers.ReadBytesRenderer.getDisplayName();
                    }
                    case 10: {
                        return FileIORenderers.WriteBytesRenderer.getDisplayName();
                    }
                }
                return null;
            }

            public Object getValueAt(TreeNode node, int column) {
                if (node == null) {
                    return null;
                }
                FileIONode fnode = (FileIONode)((Object)node);
                switch (column) {
                    case 0: {
                        return fnode;
                    }
                    case 1: {
                        return this.toDuration(fnode.durationR, fnode.durationW);
                    }
                    case 2: {
                        return fnode.durationR;
                    }
                    case 3: {
                        return fnode.durationRMax;
                    }
                    case 4: {
                        return fnode.durationW;
                    }
                    case 5: {
                        return fnode.durationWMax;
                    }
                    case 6: {
                        return this.toLong(fnode.countR + fnode.countW);
                    }
                    case 7: {
                        return this.toLong(fnode.countR);
                    }
                    case 8: {
                        return this.toLong(fnode.countW);
                    }
                    case 9: {
                        return this.toLong(fnode.bytesR);
                    }
                    case 10: {
                        return this.toLong(fnode.bytesW);
                    }
                }
                return null;
            }

            public void setValueAt(Object o, TreeNode node, int column) {
            }

            public boolean isCellEditable(TreeNode node, int column) {
                return false;
            }

            private Long toLong(long value) {
                return value == 0L ? null : Long.valueOf(value);
            }

            private Duration toDuration(Duration duration1, Duration duration2) {
                if (duration1 == null && duration2 == null) {
                    return null;
                }
                if (duration2 == null) {
                    return duration1;
                }
                if (duration1 == null) {
                    return duration2;
                }
                return duration1.plus(duration2);
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel {
        private Aggregation lastPrimary;
        private Aggregation lastSecondary;
        private int prefHeight = -1;
        private JLabel firstLabel;
        private JLabel secondLabel;
        private JComboBox<Aggregation> firstCombo;
        private JComboBox<Aggregation> secondCombo;
        private JButton updateButton;
        private HTMLLabel statusValueLabel;

        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView("File IO", null, (JComponent)this);
        }

        abstract void firstShown();

        abstract void changeAggregation(Aggregation var1, Aggregation var2);

        void showProgress() {
            this.updateButton.setEnabled(false);
            this.updateButton.setVisible(false);
            this.statusValueLabel.setVisible(true);
        }

        void hideProgress() {
            this.statusValueLabel.setVisible(false);
            this.updateButton.setVisible(true);
        }

        private void handleAggregationChanged(boolean updateSecondary) {
            if (updateSecondary) {
                if (Aggregation.FILE.equals(this.firstCombo.getSelectedItem())) {
                    if (Aggregation.FILE.equals((Object)this.secondCombo.getItemAt(1))) {
                        int sel = this.secondCombo.getSelectedIndex();
                        DefaultComboBoxModel model = (DefaultComboBoxModel)this.secondCombo.getModel();
                        model.removeElementAt(1);
                        model.addElement(Aggregation.THREAD);
                        this.secondCombo.setSelectedIndex(sel);
                    }
                } else if (Aggregation.THREAD.equals(this.firstCombo.getSelectedItem()) && Aggregation.THREAD.equals((Object)this.secondCombo.getItemAt(1))) {
                    int sel = this.secondCombo.getSelectedIndex();
                    DefaultComboBoxModel model = (DefaultComboBoxModel)this.secondCombo.getModel();
                    model.removeElementAt(1);
                    model.addElement(Aggregation.FILE);
                    this.secondCombo.setSelectedIndex(sel);
                }
            }
            this.updateButton.setEnabled(this.lastPrimary != this.firstCombo.getSelectedItem() || this.lastSecondary != this.secondCombo.getSelectedItem());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            if (this.prefHeight == -1) {
                this.prefHeight = pref.height;
            } else {
                pref.height = this.prefHeight;
            }
            return pref;
        }

        private void initComponents(JFRModel model) {
            this.setOpaque(false);
            if (model == null) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else if (!model.containsEvent(JFRSnapshotFileIOViewProvider.EventChecker.class)) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.noData("File IO", JFRSnapshotFileIOViewProvider.EventChecker.checkedTypes()), "Center");
            } else {
                this.setLayout(new GridBagLayout());
                this.setBorder(BorderFactory.createEmptyBorder(11, 5, 20, 5));
                this.firstLabel = new JLabel();
                this.firstLabel.setText("Aggregation:");
                this.firstLabel.setOpaque(false);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.firstLabel, constraints);
                this.firstCombo = new JComboBox<Aggregation>(new Aggregation[]{Aggregation.FILE, Aggregation.THREAD});
                this.firstCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleAggregationChanged(true);
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 1;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add(this.firstCombo, constraints);
                this.secondLabel = new JLabel();
                this.secondLabel.setText("secondary:");
                this.secondLabel.setOpaque(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 2;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 12, 0, 0);
                this.add((Component)this.secondLabel, constraints);
                this.secondCombo = new JComboBox<Aggregation>(new Aggregation[]{Aggregation.NONE, Aggregation.THREAD});
                this.secondCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleAggregationChanged(false);
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 3;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add(this.secondCombo, constraints);
                this.lastPrimary = (Aggregation)((Object)this.firstCombo.getSelectedItem());
                this.lastSecondary = (Aggregation)((Object)this.secondCombo.getSelectedItem());
                JSeparator updateSeparator = new JSeparator(1);
                updateSeparator.setOpaque(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 4;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 16, 0, 0);
                this.add((Component)updateSeparator, constraints);
                this.updateButton = new JButton("Update Data");
                this.updateButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        updateButton.setEnabled(false);
                        lastPrimary = (Aggregation)((Object)firstCombo.getSelectedItem());
                        lastSecondary = (Aggregation)((Object)secondCombo.getSelectedItem());
                        this.changeAggregation((Aggregation)((Object)firstCombo.getSelectedItem()), (Aggregation)((Object)secondCombo.getSelectedItem()));
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 5;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 12, 0, 0);
                this.add((Component)this.updateButton, constraints);
                this.statusValueLabel = new HTMLLabel("<nobr><b>Progress:</b> reading data...</nobr>");
                constraints = new GridBagConstraints();
                constraints.gridx = 6;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 20, 0, 0);
                this.add((Component)this.statusValueLabel, constraints);
                this.statusValueLabel.setVisible(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 7;
                constraints.gridy = 2;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.gridwidth = 0;
                constraints.fill = 1;
                constraints.anchor = 18;
                constraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)Spacer.create(), constraints);
                Dimension cpuD = this.firstCombo.getPreferredSize();
                Dimension memoryD = this.secondCombo.getPreferredSize();
                Dimension maxD = new Dimension(Math.max(cpuD.width, memoryD.width), Math.max(cpuD.height, memoryD.height));
                this.firstCombo.setPreferredSize(maxD);
                this.firstCombo.setMinimumSize(maxD);
                this.secondCombo.setPreferredSize(maxD);
                this.secondCombo.setMinimumSize(maxD);
                Dimension sepD = updateSeparator.getPreferredSize();
                sepD.height = maxD.height - 2;
                sepD.width = 5;
                updateSeparator.setPreferredSize(sepD);
                updateSeparator.setMinimumSize(sepD);
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(this::firstShown);
                        }
                    }
                });
            }
        }
    }

    static enum Aggregation {
        NONE{

            public String toString() {
                return "None";
            }
        }
        ,
        FILE{

            public String toString() {
                return "File";
            }
        }
        ,
        THREAD{

            public String toString() {
                return "Thread";
            }
        };

    }
}

