/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.viewer.internal;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.SourcesViewer;
import org.graalvm.visualvm.gotosource.viewer.internal.Bundle;
import org.graalvm.visualvm.gotosource.viewer.internal.InternalSourceAppearance;
import org.graalvm.visualvm.gotosource.viewer.internal.InternalSourceViewerTopComponent;

public final class InternalSourcesViewer
extends SourcesViewer {
    private static final String ID = "InternalSourcesViewer";
    private InternalSourceAppearance appearance;

    public InternalSourcesViewer() {
        super(ID, Bundle.InternalSourcesViewer_Name(), Bundle.InternalSourcesViewer_Description());
    }

    @Override
    public boolean open(SourceHandle handle) {
        final String uri = handle.getSourceUri();
        final String text = handle.getText();
        final int offset = handle.getOffset();
        final int endOffset = handle.getEndOffset();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InternalSourceViewerTopComponent.showSource(uri, text, offset == -1 ? 0 : offset, offset == -1 ? 0 : endOffset, InternalSourcesViewer.this.getAppearance());
            }
        });
        return true;
    }

    @Override
    public void loadSettings() {
        if (this.appearance != null) {
            this.appearance.loadSettings();
        }
    }

    @Override
    public void saveSettings() {
        if (this.appearance != null) {
            this.appearance.saveSettings();
        }
    }

    @Override
    public boolean settingsDirty() {
        return this.appearance != null && this.appearance.currentSettingsDirty();
    }

    @Override
    public JComponent getSettingsComponent() {
        return this.getAppearance().getSettingsComponent();
    }

    private InternalSourceAppearance getAppearance() {
        if (this.appearance == null) {
            this.appearance = new InternalSourceAppearance();
        }
        return this.appearance;
    }
}

