/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.xml.util.Name;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.Datatype;

public class PatternDumper {
    private boolean startTagOpen = false;
    private final ArrayList tagStack = new ArrayList();
    private final PrintWriter writer;
    private int level = 0;
    private boolean suppressIndent = false;
    private final List patternList = new ArrayList();
    private final Map patternTable = new HashMap();
    private final PatternVisitor patternVisitor = new DumpPatternVisitor();
    private final PatternVisitor groupPatternVisitor = new GroupDumpPatternVisitor();
    private final PatternVisitor choicePatternVisitor = new ChoiceDumpPatternVisitor();
    private final PatternVisitor interleavePatternVisitor = new InterleaveDumpPatternVisitor();
    private final NameClassVisitor nameClassVisitor = new DumpNameClassVisitor();
    private final NameClassVisitor choiceNameClassVisitor = new ChoiceDumpNameClassVisitor();

    public static void dump(PrintWriter printWriter, Pattern pattern) {
        new PatternDumper(printWriter).dump(pattern);
    }

    public static void dump(OutputStream outputStream, Pattern pattern) {
        new PatternDumper(new PrintWriter(outputStream)).dump(pattern);
    }

    private PatternDumper(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    private void dump(Pattern pattern) {
        this.write("<?xml version=\"1.0\"?>");
        this.startElement("grammar");
        this.attribute("xmlns", "http://relaxng.org/ns/structure/1.0");
        this.startElement("start");
        pattern.accept(this.groupPatternVisitor);
        this.endElement();
        for (int i = 0; i < this.patternList.size(); ++i) {
            this.startElement("define");
            Pattern pattern2 = (Pattern)this.patternList.get(i);
            this.attribute("name", this.getName(pattern2));
            pattern2.accept(this.groupPatternVisitor);
            this.endElement();
        }
        this.endElement();
        this.writer.println();
        this.writer.flush();
    }

    private String getName(Pattern pattern) {
        String string = (String)this.patternTable.get(pattern);
        if (string == null) {
            string = "p" + this.patternList.size();
            this.patternList.add(pattern);
            this.patternTable.put(pattern, string);
        }
        return string;
    }

    private void startElement(String string) {
        this.closeStartTag();
        this.indent(this.level);
        this.write('<');
        this.write(string);
        this.push(string);
        this.startTagOpen = true;
        ++this.level;
    }

    private void closeStartTag() {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write('>');
        }
    }

    private void attribute(String string, String string2) {
        this.write(' ');
        this.write(string);
        this.write('=');
        this.write('\"');
        this.chars(string2, true);
        this.write('\"');
    }

    private void data(String string) {
        if (string.length() > 0) {
            this.closeStartTag();
            this.chars(string, false);
            this.suppressIndent = true;
        }
    }

    private void chars(String string, boolean bl) {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        continue block6;
                    }
                }
                default: {
                    this.write(c);
                }
            }
        }
    }

    private void endElement() {
        --this.level;
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write("/>");
            this.pop();
        } else {
            if (!this.suppressIndent) {
                this.indent(this.level);
            }
            this.write("</");
            this.write(this.pop());
            this.write(">");
        }
        this.suppressIndent = false;
    }

    private void indent(int n) {
        this.writer.println();
        for (int i = 0; i < n; ++i) {
            this.write("  ");
        }
    }

    private void write(String string) {
        this.writer.print(string);
    }

    private void write(char c) {
        this.writer.print(c);
    }

    private void push(String string) {
        this.tagStack.add(string);
    }

    private String pop() {
        return (String)this.tagStack.remove(this.tagStack.size() - 1);
    }

    class DumpPatternVisitor
    implements PatternVisitor {
        DumpPatternVisitor() {
        }

        @Override
        public void visitEmpty() {
            PatternDumper.this.startElement("empty");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNotAllowed() {
            PatternDumper.this.startElement("notAllowed");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitError() {
            PatternDumper.this.startElement("error");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitGroup(Pattern pattern, Pattern pattern2) {
            PatternDumper.this.startElement("group");
            pattern.accept(PatternDumper.this.groupPatternVisitor);
            pattern2.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            PatternDumper.this.startElement("interleave");
            pattern.accept(PatternDumper.this.interleavePatternVisitor);
            pattern2.accept(PatternDumper.this.interleavePatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitChoice(Pattern pattern, Pattern pattern2) {
            PatternDumper.this.startElement("choice");
            pattern.accept(PatternDumper.this.choicePatternVisitor);
            pattern2.accept(PatternDumper.this.choicePatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitOneOrMore(Pattern pattern) {
            PatternDumper.this.startElement("oneOrMore");
            pattern.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitElement(NameClass nameClass, Pattern pattern) {
            PatternDumper.this.startElement("element");
            nameClass.accept(PatternDumper.this.nameClassVisitor);
            PatternDumper.this.startElement("ref");
            PatternDumper.this.attribute("name", PatternDumper.this.getName(pattern));
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        @Override
        public void visitAttribute(NameClass nameClass, Pattern pattern) {
            PatternDumper.this.startElement("attribute");
            nameClass.accept(PatternDumper.this.nameClassVisitor);
            pattern.accept(PatternDumper.this.patternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitData(Datatype datatype) {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitDataExcept(Datatype datatype, Pattern pattern) {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitValue(Datatype datatype, Object object) {
            PatternDumper.this.startElement("value");
            PatternDumper.this.data(object.toString());
            PatternDumper.this.endElement();
        }

        @Override
        public void visitText() {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitList(Pattern pattern) {
            PatternDumper.this.startElement("list");
            pattern.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }
    }

    class GroupDumpPatternVisitor
    extends DumpPatternVisitor {
        GroupDumpPatternVisitor() {
        }

        @Override
        public void visitGroup(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class ChoiceDumpPatternVisitor
    extends DumpPatternVisitor {
        ChoiceDumpPatternVisitor() {
        }

        @Override
        public void visitChoice(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class InterleaveDumpPatternVisitor
    extends DumpPatternVisitor {
        InterleaveDumpPatternVisitor() {
        }

        @Override
        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class DumpNameClassVisitor
    implements NameClassVisitor {
        DumpNameClassVisitor() {
        }

        @Override
        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            PatternDumper.this.startElement("choice");
            nameClass.accept(PatternDumper.this.choiceNameClassVisitor);
            nameClass2.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNsName(String string) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.attribute("ns", string);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNsNameExcept(String string, NameClass nameClass) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.attribute("ns", string);
            PatternDumper.this.startElement("except");
            nameClass.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        @Override
        public void visitAnyName() {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitAnyNameExcept(NameClass nameClass) {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.startElement("except");
            nameClass.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        @Override
        public void visitName(Name name) {
            PatternDumper.this.startElement("name");
            PatternDumper.this.attribute("ns", name.getNamespaceUri());
            PatternDumper.this.data(name.getLocalName());
            PatternDumper.this.endElement();
        }

        @Override
        public void visitError() {
            PatternDumper.this.startElement("error");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNull() {
            this.visitAnyName();
        }
    }

    class ChoiceDumpNameClassVisitor
    extends DumpNameClassVisitor {
        ChoiceDumpNameClassVisitor() {
        }

        @Override
        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }
    }
}

