/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.UserModel;

public class OrganizationBean {
    private final String name;
    private final String alias;
    private final Set<String> domains;
    private final boolean isMember;
    private final Map<String, List<String>> attributes;

    public OrganizationBean(OrganizationModel organization, UserModel user) {
        this.name = organization.getName();
        this.alias = organization.getAlias();
        this.domains = organization.getDomains().map(OrganizationDomainModel::getName).collect(Collectors.toSet());
        this.isMember = user != null && organization.isMember(user);
        this.attributes = Collections.unmodifiableMap(organization.getAttributes());
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Set<String> getDomains() {
        return this.domains;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public boolean isMember() {
        return this.isMember;
    }
}

