/*
 * tifftclDecls.h --
 *
 * Declarations of functions in the platform independent public TIFFTCL API.
 *
 */

#ifndef _TIFFTCLDECLS
#define _TIFFTCLDECLS

/*
 * WARNING: The contents of this file is automatically generated by the
 * genStubs.tcl script. Any modifications to the function declarations
 * below should be made in the tifftcl.decls script.
 */

#include <tcl.h>
#include <stdarg.h>

#ifdef TIFFTCLAPI
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#else
#   define TIFFTCLAPI extern
#   undef USE_TIFFTCL_STUBS
#   define USE_TIFFTCL_STUBS 1
#endif

EXTERN int Tifftcl_Init(Tcl_Interp *interp);
EXTERN int Tifftcl_SafeInit(Tcl_Interp *interp);
/*
 * The macro INLINE might be defined both in tcl.h and libtiff/port.h,
 * so better prevent a conflict here.
 */
#undef INLINE

#include "../compat/libtiff/libtiff/tiffio.h"
#include "../compat/libtiff/libtiff/tiffiop.h"
#include "../compat/libtiff/libtiff/tif_predict.h"

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
TIFFTCLAPI const char *	 TIFFGetVersion(void);
/* 1 */
TIFFTCLAPI const TIFFCodec * TIFFFindCODEC(uint16_t a);
/* 2 */
TIFFTCLAPI TIFFCodec *	TIFFRegisterCODEC(uint16_t a, const char *b,
				TIFFInitMethod c);
/* 3 */
TIFFTCLAPI void		TIFFUnRegisterCODEC(TIFFCodec *a);
/* 4 */
TIFFTCLAPI tdata_t	_TIFFmalloc(tsize_t a);
/* 5 */
TIFFTCLAPI tdata_t	_TIFFrealloc(tdata_t a, tsize_t b);
/* 6 */
TIFFTCLAPI void		_TIFFmemset(tdata_t a, int b, tsize_t c);
/* 7 */
TIFFTCLAPI void		_TIFFmemcpy(void *d, const void *s, tmsize_t c);
/* 8 */
TIFFTCLAPI int		_TIFFmemcmp(const void *p1, const void *p2,
				tmsize_t c);
/* 9 */
TIFFTCLAPI void		_TIFFfree(tdata_t a);
/* 10 */
TIFFTCLAPI void		TIFFClose(TIFF *tiffptr);
/* 11 */
TIFFTCLAPI int		TIFFFlush(TIFF *tiffptr);
/* 12 */
TIFFTCLAPI int		TIFFFlushData(TIFF *tiffptr);
/* 13 */
TIFFTCLAPI int		TIFFGetField(TIFF *tiffptr, ttag_t a, ...);
/* 14 */
TIFFTCLAPI int		TIFFVGetField(TIFF *tiffptr, ttag_t a, va_list b);
/* 15 */
TIFFTCLAPI int		TIFFGetFieldDefaulted(TIFF *tiffptr, ttag_t a, ...);
/* 16 */
TIFFTCLAPI int		TIFFVGetFieldDefaulted(TIFF *tiffptr, ttag_t a,
				va_list b);
/* 17 */
TIFFTCLAPI int		TIFFReadDirectory(TIFF *tiffptr);
/* 18 */
TIFFTCLAPI tsize_t	TIFFScanlineSize(TIFF *tiffptr);
/* 19 */
TIFFTCLAPI tsize_t	TIFFRasterScanlineSize(TIFF *tiffptr);
/* 20 */
TIFFTCLAPI tsize_t	TIFFStripSize(TIFF *tiffptr);
/* 21 */
TIFFTCLAPI tsize_t	TIFFVStripSize(TIFF *tiffptr, uint32_t a);
/* 22 */
TIFFTCLAPI tsize_t	TIFFTileRowSize(TIFF *tiffptr);
/* 23 */
TIFFTCLAPI tsize_t	TIFFTileSize(TIFF *tiffptr);
/* 24 */
TIFFTCLAPI tsize_t	TIFFVTileSize(TIFF *tiffptr, uint32_t a);
/* 25 */
TIFFTCLAPI uint32_t	TIFFDefaultStripSize(TIFF *tiffptr, uint32_t a);
/* 26 */
TIFFTCLAPI void		TIFFDefaultTileSize(TIFF *tiffptr, uint32_t *a,
				uint32_t *b);
/* 27 */
TIFFTCLAPI int		TIFFFileno(TIFF *tiffptr);
/* 28 */
TIFFTCLAPI int		TIFFGetMode(TIFF *tiffptr);
/* 29 */
TIFFTCLAPI int		TIFFIsTiled(TIFF *tiffptr);
/* 30 */
TIFFTCLAPI int		TIFFIsByteSwapped(TIFF *tiffptr);
/* 31 */
TIFFTCLAPI int		TIFFIsUpSampled(TIFF *tiffptr);
/* 32 */
TIFFTCLAPI int		TIFFIsMSB2LSB(TIFF *tiffptr);
/* 33 */
TIFFTCLAPI uint32_t	TIFFCurrentRow(TIFF *tiffptr);
/* 34 */
TIFFTCLAPI tdir_t	TIFFCurrentDirectory(TIFF *tiffptr);
/* 35 */
TIFFTCLAPI tdir_t	TIFFNumberOfDirectories(TIFF *tiffptr);
/* 36 */
TIFFTCLAPI uint64_t	TIFFCurrentDirOffset(TIFF *tiffptr);
/* 37 */
TIFFTCLAPI tstrip_t	TIFFCurrentStrip(TIFF *tiffptr);
/* 38 */
TIFFTCLAPI ttile_t	TIFFCurrentTile(TIFF *tiffptr);
/* 39 */
TIFFTCLAPI int		TIFFReadBufferSetup(TIFF *tiffptr, tdata_t a,
				tsize_t b);
/* 40 */
TIFFTCLAPI int		TIFFWriteBufferSetup(TIFF *tiffptr, tdata_t a,
				tsize_t b);
/* 41 */
TIFFTCLAPI int		TIFFWriteCheck(TIFF *tiffptr, int a, const char *b);
/* 42 */
TIFFTCLAPI int		TIFFCreateDirectory(TIFF *tiffptr);
/* 43 */
TIFFTCLAPI int		TIFFLastDirectory(TIFF *tiffptr);
/* 44 */
TIFFTCLAPI int		TIFFSetDirectory(TIFF *tiffptr, tdir_t a);
/* 45 */
TIFFTCLAPI int		TIFFSetSubDirectory(TIFF *tiffptr, uint64_t a);
/* 46 */
TIFFTCLAPI int		TIFFUnlinkDirectory(TIFF *tiffptr, tdir_t a);
/* 47 */
TIFFTCLAPI int		TIFFSetField(TIFF *tiffptr, ttag_t a, ...);
/* 48 */
TIFFTCLAPI int		TIFFVSetField(TIFF *tiffptr, ttag_t a, va_list b);
/* 49 */
TIFFTCLAPI int		TIFFWriteDirectory(TIFF *tiffptr);
/* Slot 50 is reserved */
/* 51 */
TIFFTCLAPI void		TIFFPrintDirectory(TIFF *tiffptr, FILE *a, long b);
/* 52 */
TIFFTCLAPI int		TIFFReadScanline(TIFF *tiffptr, tdata_t a,
				uint32_t b, tsample_t c);
/* 53 */
TIFFTCLAPI int		TIFFWriteScanline(TIFF *tiffptr, tdata_t a,
				uint32_t b, tsample_t c);
/* 54 */
TIFFTCLAPI int		TIFFReadRGBAImage(TIFF *tiffptr, uint32_t a,
				uint32_t b, uint32_t *c, int d);
/* 55 */
TIFFTCLAPI int		TIFFReadRGBAStrip(TIFF *tiffptr, tstrip_t a,
				uint32_t *b);
/* 56 */
TIFFTCLAPI int		TIFFReadRGBATile(TIFF *tiffptr, uint32_t a,
				uint32_t b, uint32_t *c);
/* Slot 57 is reserved */
/* Slot 58 is reserved */
/* 59 */
TIFFTCLAPI int		TIFFRGBAImageGet(TIFFRGBAImage *d, uint32_t *c,
				uint32_t b, uint32_t a);
/* 60 */
TIFFTCLAPI void		TIFFRGBAImageEnd(TIFFRGBAImage *a);
/* 61 */
TIFFTCLAPI TIFF *	TIFFOpen(const char *b, const char *a);
/* 62 */
TIFFTCLAPI TIFF *	TIFFFdOpen(int a, const char *b, const char *c);
/* 63 */
TIFFTCLAPI TIFF *	TIFFClientOpen(const char *a, const char *b,
				thandle_t c, TIFFReadWriteProc d,
				TIFFReadWriteProc e, TIFFSeekProc f,
				TIFFCloseProc g, TIFFSizeProc h,
				TIFFMapFileProc i, TIFFUnmapFileProc j);
/* 64 */
TIFFTCLAPI const char *	 TIFFFileName(TIFF *tiffptr);
/* 65 */
TIFFTCLAPI void		TIFFError(const char *a, const char *b, ...);
/* 66 */
TIFFTCLAPI void		TIFFWarning(const char *a, const char *b, ...);
/* 67 */
TIFFTCLAPI TIFFErrorHandler TIFFSetErrorHandler(TIFFErrorHandler a);
/* 68 */
TIFFTCLAPI TIFFErrorHandler TIFFSetWarningHandler(TIFFErrorHandler a);
/* 69 */
TIFFTCLAPI TIFFExtendProc TIFFSetTagExtender(TIFFExtendProc a);
/* 70 */
TIFFTCLAPI ttile_t	TIFFComputeTile(TIFF *tiffptr, uint32_t a,
				uint32_t b, uint32_t c, tsample_t d);
/* 71 */
TIFFTCLAPI int		TIFFCheckTile(TIFF *tiffptr, uint32_t d, uint32_t c,
				uint32_t b, tsample_t a);
/* 72 */
TIFFTCLAPI ttile_t	TIFFNumberOfTiles(TIFF *tiffptr);
/* 73 */
TIFFTCLAPI tsize_t	TIFFReadTile(TIFF *tiffptr, tdata_t a, uint32_t b,
				uint32_t c, uint32_t d, tsample_t e);
/* 74 */
TIFFTCLAPI tsize_t	TIFFWriteTile(TIFF *tiffptr, tdata_t e, uint32_t d,
				uint32_t c, uint32_t b, tsample_t a);
/* 75 */
TIFFTCLAPI tstrip_t	TIFFComputeStrip(TIFF *tiffptr, uint32_t a,
				tsample_t b);
/* 76 */
TIFFTCLAPI tstrip_t	TIFFNumberOfStrips(TIFF *tiffptr);
/* 77 */
TIFFTCLAPI tsize_t	TIFFReadEncodedStrip(TIFF *tiffptr, tstrip_t a,
				tdata_t b, tsize_t c);
/* 78 */
TIFFTCLAPI tsize_t	TIFFReadRawStrip(TIFF *tiffptr, tstrip_t a,
				tdata_t b, tsize_t c);
/* 79 */
TIFFTCLAPI tsize_t	TIFFReadEncodedTile(TIFF *tiffptr, ttile_t a,
				tdata_t b, tsize_t c);
/* 80 */
TIFFTCLAPI tsize_t	TIFFReadRawTile(TIFF *tiffptr, ttile_t c, tdata_t b,
				tsize_t a);
/* 81 */
TIFFTCLAPI tsize_t	TIFFWriteEncodedStrip(TIFF *tiffptr, tstrip_t a,
				tdata_t b, tsize_t c);
/* 82 */
TIFFTCLAPI tsize_t	TIFFWriteRawStrip(TIFF *tiffptr, tstrip_t a,
				tdata_t b, tsize_t c);
/* 83 */
TIFFTCLAPI tsize_t	TIFFWriteEncodedTile(TIFF *tiffptr, ttile_t a,
				tdata_t b, tsize_t c);
/* 84 */
TIFFTCLAPI tsize_t	TIFFWriteRawTile(TIFF *tiffptr, ttile_t c, tdata_t b,
				tsize_t a);
/* 85 */
TIFFTCLAPI void		TIFFSetWriteOffset(TIFF *tiffptr, toff_t a);
/* 86 */
TIFFTCLAPI void		TIFFSwabShort(uint16_t *a);
/* 87 */
TIFFTCLAPI void		TIFFSwabLong(uint32_t *a);
/* 88 */
TIFFTCLAPI void		TIFFSwabDouble(double *a);
/* 89 */
TIFFTCLAPI void		TIFFSwabArrayOfShort(uint16_t *a, tmsize_t b);
/* 90 */
TIFFTCLAPI void		TIFFSwabArrayOfLong(uint32_t *b, tmsize_t a);
/* 91 */
TIFFTCLAPI void		TIFFSwabArrayOfDouble(double *a, tmsize_t b);
/* 92 */
TIFFTCLAPI void		TIFFReverseBits(unsigned char *a, tmsize_t b);
/* 93 */
TIFFTCLAPI const unsigned char * TIFFGetBitRevTable(int a);
/* 94 */
TIFFTCLAPI void		TIFFErrorExt(thandle_t h, const char *a,
				const char *b, ...);
/* 95 */
TIFFTCLAPI uint64_t	TIFFGetStrileByteCount(TIFF *tif, uint32_t strile);
/* 96 */
TIFFTCLAPI uint64_t	TIFFGetStrileOffset(TIFF *tif, uint32_t strile);
/* Slot 97 is reserved */
/* Slot 98 is reserved */
/* Slot 99 is reserved */
/* 100 */
TIFFTCLAPI int		TIFFPredictorInit(TIFF *tiffptr);
/* 101 */
TIFFTCLAPI int		TIFFPredictorCleanup(TIFF *tiffptr);
/* Slot 102 is reserved */
/* Slot 103 is reserved */
/* Slot 104 is reserved */
/* Slot 105 is reserved */
/* Slot 106 is reserved */
/* Slot 107 is reserved */
/* Slot 108 is reserved */
/* Slot 109 is reserved */
/* Slot 110 is reserved */
/* 111 */
TIFFTCLAPI int		TIFFMergeFieldInfo(TIFF *tiffptr,
				const TIFFFieldInfo *a, uint32_t b);
/* 112 */
TIFFTCLAPI void		_TIFFPrintFieldInfo(TIFF *tiffptr, FILE *a);
/* Slot 113 is reserved */
/* 114 */
TIFFTCLAPI const TIFFField * TIFFFieldWithTag(TIFF *tiffptr, uint32_t a);
/* 115 */
TIFFTCLAPI int		_TIFFMergeFields(TIFF *tiffptr, const TIFFField *a,
				uint32_t b);
/* Slot 116 is reserved */
/* Slot 117 is reserved */
/* Slot 118 is reserved */
/* Slot 119 is reserved */
/* Slot 120 is reserved */
/* Slot 121 is reserved */
/* Slot 122 is reserved */
/* Slot 123 is reserved */
/* Slot 124 is reserved */
/* Slot 125 is reserved */
/* Slot 126 is reserved */
/* 127 */
TIFFTCLAPI void		_TIFFNoPostDecode(TIFF *tiffptr, tidata_t a,
				tsize_t b);
/* Slot 128 is reserved */
/* Slot 129 is reserved */
/* Slot 130 is reserved */
/* Slot 131 is reserved */
/* Slot 132 is reserved */
/* 133 */
TIFFTCLAPI int		TIFFFlushData1(TIFF *tiffptr);
/* 134 */
TIFFTCLAPI void		TIFFFreeDirectory(TIFF *tiffptr);
/* 135 */
TIFFTCLAPI int		TIFFDefaultDirectory(TIFF *tiffptr);
/* 136 */
TIFFTCLAPI int		TIFFSetCompressionScheme(TIFF *tiffptr, int a);
/* 137 */
TIFFTCLAPI void		_TIFFSetDefaultCompressionState(TIFF *tiffptr);
/* 138 */
TIFFTCLAPI uint32_t	_TIFFDefaultStripSize(TIFF *tiffptr, uint32_t a);
/* Slot 139 is reserved */
/* 140 */
TIFFTCLAPI void		_TIFFsetByteArray(void **a, const void *b,
				uint32_t c);
/* Slot 141 is reserved */
/* Slot 142 is reserved */
/* Slot 143 is reserved */
/* Slot 144 is reserved */
/* Slot 145 is reserved */
/* Slot 146 is reserved */
/* Slot 147 is reserved */
/* 148 */
TIFFTCLAPI int		TIFFInitDumpMode(TIFF *tiffptr, int a);
/* 149 */
TIFFTCLAPI int		TIFFInitPackBits(TIFF *tiffptr, int a);
/* 150 */
TIFFTCLAPI int		TIFFInitCCITTRLE(TIFF *tiffptr, int a);
/* 151 */
TIFFTCLAPI int		TIFFInitCCITTRLEW(TIFF *tiffptr, int a);
/* 152 */
TIFFTCLAPI int		TIFFInitCCITTFax3(TIFF *tiffptr, int a);
/* 153 */
TIFFTCLAPI int		TIFFInitCCITTFax4(TIFF *tiffptr, int a);
/* 154 */
TIFFTCLAPI int		TIFFInitThunderScan(TIFF *tiffptr, int a);
/* 155 */
TIFFTCLAPI int		TIFFInitNeXT(TIFF *tiffptr, int a);
/* 156 */
TIFFTCLAPI int		TIFFInitLZW(TIFF *tiffptr, int a);
/* 157 */
TIFFTCLAPI int		TIFFInitOJPEG(TIFF *tiffptr, int a);
/* 158 */
TIFFTCLAPI int		TIFFInitJPEG(TIFF *tiffptr, int a);
/* 159 */
TIFFTCLAPI int		TIFFInitJBIG(TIFF *tiffptr, int a);
/* 160 */
TIFFTCLAPI int		TIFFInitZIP(TIFF *tiffptr, int a);
/* 161 */
TIFFTCLAPI int		TIFFInitPixarLog(TIFF *tiffptr, int a);
/* 162 */
TIFFTCLAPI int		TIFFInitSGILog(TIFF *tiffptr, int a);
/* 163 */
TIFFTCLAPI tmsize_t	_TIFFMultiplySSize(TIFF *tiffptr, tmsize_t a,
				tmsize_t b, const char *c);
/* 164 */
TIFFTCLAPI void		TIFFWarningExt(thandle_t h, const char *a,
				const char *b, ...);

typedef struct TifftclStubs {
    int magic;
    const struct TifftclStubHooks *hooks;

    const char * (*tIFFGetVersion) (void); /* 0 */
    const TIFFCodec * (*tIFFFindCODEC) (uint16_t a); /* 1 */
    TIFFCodec * (*tIFFRegisterCODEC) (uint16_t a, const char *b, TIFFInitMethod c); /* 2 */
    void (*tIFFUnRegisterCODEC) (TIFFCodec *a); /* 3 */
    tdata_t (*_TIFFmallocPtr) (tsize_t a); /* 4 */
    tdata_t (*_TIFFreallocPtr) (tdata_t a, tsize_t b); /* 5 */
    void (*_TIFFmemsetPtr) (tdata_t a, int b, tsize_t c); /* 6 */
    void (*_TIFFmemcpyPtr) (void *d, const void *s, tmsize_t c); /* 7 */
    int (*_TIFFmemcmpPtr) (const void *p1, const void *p2, tmsize_t c); /* 8 */
    void (*_TIFFfreePtr) (tdata_t a); /* 9 */
    void (*tIFFClose) (TIFF *tiffptr); /* 10 */
    int (*tIFFFlush) (TIFF *tiffptr); /* 11 */
    int (*tIFFFlushData) (TIFF *tiffptr); /* 12 */
    int (*tIFFGetField) (TIFF *tiffptr, ttag_t a, ...); /* 13 */
    int (*tIFFVGetField) (TIFF *tiffptr, ttag_t a, va_list b); /* 14 */
    int (*tIFFGetFieldDefaulted) (TIFF *tiffptr, ttag_t a, ...); /* 15 */
    int (*tIFFVGetFieldDefaulted) (TIFF *tiffptr, ttag_t a, va_list b); /* 16 */
    int (*tIFFReadDirectory) (TIFF *tiffptr); /* 17 */
    tsize_t (*tIFFScanlineSize) (TIFF *tiffptr); /* 18 */
    tsize_t (*tIFFRasterScanlineSize) (TIFF *tiffptr); /* 19 */
    tsize_t (*tIFFStripSize) (TIFF *tiffptr); /* 20 */
    tsize_t (*tIFFVStripSize) (TIFF *tiffptr, uint32_t a); /* 21 */
    tsize_t (*tIFFTileRowSize) (TIFF *tiffptr); /* 22 */
    tsize_t (*tIFFTileSize) (TIFF *tiffptr); /* 23 */
    tsize_t (*tIFFVTileSize) (TIFF *tiffptr, uint32_t a); /* 24 */
    uint32_t (*tIFFDefaultStripSize) (TIFF *tiffptr, uint32_t a); /* 25 */
    void (*tIFFDefaultTileSize) (TIFF *tiffptr, uint32_t *a, uint32_t *b); /* 26 */
    int (*tIFFFileno) (TIFF *tiffptr); /* 27 */
    int (*tIFFGetMode) (TIFF *tiffptr); /* 28 */
    int (*tIFFIsTiled) (TIFF *tiffptr); /* 29 */
    int (*tIFFIsByteSwapped) (TIFF *tiffptr); /* 30 */
    int (*tIFFIsUpSampled) (TIFF *tiffptr); /* 31 */
    int (*tIFFIsMSB2LSB) (TIFF *tiffptr); /* 32 */
    uint32_t (*tIFFCurrentRow) (TIFF *tiffptr); /* 33 */
    tdir_t (*tIFFCurrentDirectory) (TIFF *tiffptr); /* 34 */
    tdir_t (*tIFFNumberOfDirectories) (TIFF *tiffptr); /* 35 */
    uint64_t (*tIFFCurrentDirOffset) (TIFF *tiffptr); /* 36 */
    tstrip_t (*tIFFCurrentStrip) (TIFF *tiffptr); /* 37 */
    ttile_t (*tIFFCurrentTile) (TIFF *tiffptr); /* 38 */
    int (*tIFFReadBufferSetup) (TIFF *tiffptr, tdata_t a, tsize_t b); /* 39 */
    int (*tIFFWriteBufferSetup) (TIFF *tiffptr, tdata_t a, tsize_t b); /* 40 */
    int (*tIFFWriteCheck) (TIFF *tiffptr, int a, const char *b); /* 41 */
    int (*tIFFCreateDirectory) (TIFF *tiffptr); /* 42 */
    int (*tIFFLastDirectory) (TIFF *tiffptr); /* 43 */
    int (*tIFFSetDirectory) (TIFF *tiffptr, tdir_t a); /* 44 */
    int (*tIFFSetSubDirectory) (TIFF *tiffptr, uint64_t a); /* 45 */
    int (*tIFFUnlinkDirectory) (TIFF *tiffptr, tdir_t a); /* 46 */
    int (*tIFFSetField) (TIFF *tiffptr, ttag_t a, ...); /* 47 */
    int (*tIFFVSetField) (TIFF *tiffptr, ttag_t a, va_list b); /* 48 */
    int (*tIFFWriteDirectory) (TIFF *tiffptr); /* 49 */
    void (*reserved50)(void);
    void (*tIFFPrintDirectory) (TIFF *tiffptr, FILE *a, long b); /* 51 */
    int (*tIFFReadScanline) (TIFF *tiffptr, tdata_t a, uint32_t b, tsample_t c); /* 52 */
    int (*tIFFWriteScanline) (TIFF *tiffptr, tdata_t a, uint32_t b, tsample_t c); /* 53 */
    int (*tIFFReadRGBAImage) (TIFF *tiffptr, uint32_t a, uint32_t b, uint32_t *c, int d); /* 54 */
    int (*tIFFReadRGBAStrip) (TIFF *tiffptr, tstrip_t a, uint32_t *b); /* 55 */
    int (*tIFFReadRGBATile) (TIFF *tiffptr, uint32_t a, uint32_t b, uint32_t *c); /* 56 */
    void (*reserved57)(void);
    void (*reserved58)(void);
    int (*tIFFRGBAImageGet) (TIFFRGBAImage *d, uint32_t *c, uint32_t b, uint32_t a); /* 59 */
    void (*tIFFRGBAImageEnd) (TIFFRGBAImage *a); /* 60 */
    TIFF * (*tIFFOpen) (const char *b, const char *a); /* 61 */
    TIFF * (*tIFFFdOpen) (int a, const char *b, const char *c); /* 62 */
    TIFF * (*tIFFClientOpen) (const char *a, const char *b, thandle_t c, TIFFReadWriteProc d, TIFFReadWriteProc e, TIFFSeekProc f, TIFFCloseProc g, TIFFSizeProc h, TIFFMapFileProc i, TIFFUnmapFileProc j); /* 63 */
    const char * (*tIFFFileName) (TIFF *tiffptr); /* 64 */
    void (*tIFFError) (const char *a, const char *b, ...); /* 65 */
    void (*tIFFWarning) (const char *a, const char *b, ...); /* 66 */
    TIFFErrorHandler (*tIFFSetErrorHandler) (TIFFErrorHandler a); /* 67 */
    TIFFErrorHandler (*tIFFSetWarningHandler) (TIFFErrorHandler a); /* 68 */
    TIFFExtendProc (*tIFFSetTagExtender) (TIFFExtendProc a); /* 69 */
    ttile_t (*tIFFComputeTile) (TIFF *tiffptr, uint32_t a, uint32_t b, uint32_t c, tsample_t d); /* 70 */
    int (*tIFFCheckTile) (TIFF *tiffptr, uint32_t d, uint32_t c, uint32_t b, tsample_t a); /* 71 */
    ttile_t (*tIFFNumberOfTiles) (TIFF *tiffptr); /* 72 */
    tsize_t (*tIFFReadTile) (TIFF *tiffptr, tdata_t a, uint32_t b, uint32_t c, uint32_t d, tsample_t e); /* 73 */
    tsize_t (*tIFFWriteTile) (TIFF *tiffptr, tdata_t e, uint32_t d, uint32_t c, uint32_t b, tsample_t a); /* 74 */
    tstrip_t (*tIFFComputeStrip) (TIFF *tiffptr, uint32_t a, tsample_t b); /* 75 */
    tstrip_t (*tIFFNumberOfStrips) (TIFF *tiffptr); /* 76 */
    tsize_t (*tIFFReadEncodedStrip) (TIFF *tiffptr, tstrip_t a, tdata_t b, tsize_t c); /* 77 */
    tsize_t (*tIFFReadRawStrip) (TIFF *tiffptr, tstrip_t a, tdata_t b, tsize_t c); /* 78 */
    tsize_t (*tIFFReadEncodedTile) (TIFF *tiffptr, ttile_t a, tdata_t b, tsize_t c); /* 79 */
    tsize_t (*tIFFReadRawTile) (TIFF *tiffptr, ttile_t c, tdata_t b, tsize_t a); /* 80 */
    tsize_t (*tIFFWriteEncodedStrip) (TIFF *tiffptr, tstrip_t a, tdata_t b, tsize_t c); /* 81 */
    tsize_t (*tIFFWriteRawStrip) (TIFF *tiffptr, tstrip_t a, tdata_t b, tsize_t c); /* 82 */
    tsize_t (*tIFFWriteEncodedTile) (TIFF *tiffptr, ttile_t a, tdata_t b, tsize_t c); /* 83 */
    tsize_t (*tIFFWriteRawTile) (TIFF *tiffptr, ttile_t c, tdata_t b, tsize_t a); /* 84 */
    void (*tIFFSetWriteOffset) (TIFF *tiffptr, toff_t a); /* 85 */
    void (*tIFFSwabShort) (uint16_t *a); /* 86 */
    void (*tIFFSwabLong) (uint32_t *a); /* 87 */
    void (*tIFFSwabDouble) (double *a); /* 88 */
    void (*tIFFSwabArrayOfShort) (uint16_t *a, tmsize_t b); /* 89 */
    void (*tIFFSwabArrayOfLong) (uint32_t *b, tmsize_t a); /* 90 */
    void (*tIFFSwabArrayOfDouble) (double *a, tmsize_t b); /* 91 */
    void (*tIFFReverseBits) (unsigned char *a, tmsize_t b); /* 92 */
    const unsigned char * (*tIFFGetBitRevTable) (int a); /* 93 */
    void (*tIFFErrorExt) (thandle_t h, const char *a, const char *b, ...); /* 94 */
    uint64_t (*tIFFGetStrileByteCount) (TIFF *tif, uint32_t strile); /* 95 */
    uint64_t (*tIFFGetStrileOffset) (TIFF *tif, uint32_t strile); /* 96 */
    void (*reserved97)(void);
    void (*reserved98)(void);
    void (*reserved99)(void);
    int (*tIFFPredictorInit) (TIFF *tiffptr); /* 100 */
    int (*tIFFPredictorCleanup) (TIFF *tiffptr); /* 101 */
    void (*reserved102)(void);
    void (*reserved103)(void);
    void (*reserved104)(void);
    void (*reserved105)(void);
    void (*reserved106)(void);
    void (*reserved107)(void);
    void (*reserved108)(void);
    void (*reserved109)(void);
    void (*reserved110)(void);
    int (*tIFFMergeFieldInfo) (TIFF *tiffptr, const TIFFFieldInfo *a, uint32_t b); /* 111 */
    void (*_TIFFPrintFieldInfoPtr) (TIFF *tiffptr, FILE *a); /* 112 */
    void (*reserved113)(void);
    const TIFFField * (*tIFFFieldWithTag) (TIFF *tiffptr, uint32_t a); /* 114 */
    int (*_TIFFMergeFieldsPtr) (TIFF *tiffptr, const TIFFField *a, uint32_t b); /* 115 */
    void (*reserved116)(void);
    void (*reserved117)(void);
    void (*reserved118)(void);
    void (*reserved119)(void);
    void (*reserved120)(void);
    void (*reserved121)(void);
    void (*reserved122)(void);
    void (*reserved123)(void);
    void (*reserved124)(void);
    void (*reserved125)(void);
    void (*reserved126)(void);
    void (*_TIFFNoPostDecodePtr) (TIFF *tiffptr, tidata_t a, tsize_t b); /* 127 */
    void (*reserved128)(void);
    void (*reserved129)(void);
    void (*reserved130)(void);
    void (*reserved131)(void);
    void (*reserved132)(void);
    int (*tIFFFlushData1) (TIFF *tiffptr); /* 133 */
    void (*tIFFFreeDirectory) (TIFF *tiffptr); /* 134 */
    int (*tIFFDefaultDirectory) (TIFF *tiffptr); /* 135 */
    int (*tIFFSetCompressionScheme) (TIFF *tiffptr, int a); /* 136 */
    void (*_TIFFSetDefaultCompressionStatePtr) (TIFF *tiffptr); /* 137 */
    uint32_t (*_TIFFDefaultStripSizePtr) (TIFF *tiffptr, uint32_t a); /* 138 */
    void (*reserved139)(void);
    void (*_TIFFsetByteArrayPtr) (void **a, const void *b, uint32_t c); /* 140 */
    void (*reserved141)(void);
    void (*reserved142)(void);
    void (*reserved143)(void);
    void (*reserved144)(void);
    void (*reserved145)(void);
    void (*reserved146)(void);
    void (*reserved147)(void);
    int (*tIFFInitDumpMode) (TIFF *tiffptr, int a); /* 148 */
    int (*tIFFInitPackBits) (TIFF *tiffptr, int a); /* 149 */
    int (*tIFFInitCCITTRLE) (TIFF *tiffptr, int a); /* 150 */
    int (*tIFFInitCCITTRLEW) (TIFF *tiffptr, int a); /* 151 */
    int (*tIFFInitCCITTFax3) (TIFF *tiffptr, int a); /* 152 */
    int (*tIFFInitCCITTFax4) (TIFF *tiffptr, int a); /* 153 */
    int (*tIFFInitThunderScan) (TIFF *tiffptr, int a); /* 154 */
    int (*tIFFInitNeXT) (TIFF *tiffptr, int a); /* 155 */
    int (*tIFFInitLZW) (TIFF *tiffptr, int a); /* 156 */
    int (*tIFFInitOJPEG) (TIFF *tiffptr, int a); /* 157 */
    int (*tIFFInitJPEG) (TIFF *tiffptr, int a); /* 158 */
    int (*tIFFInitJBIG) (TIFF *tiffptr, int a); /* 159 */
    int (*tIFFInitZIP) (TIFF *tiffptr, int a); /* 160 */
    int (*tIFFInitPixarLog) (TIFF *tiffptr, int a); /* 161 */
    int (*tIFFInitSGILog) (TIFF *tiffptr, int a); /* 162 */
    tmsize_t (*_TIFFMultiplySSizePtr) (TIFF *tiffptr, tmsize_t a, tmsize_t b, const char *c); /* 163 */
    void (*tIFFWarningExt) (thandle_t h, const char *a, const char *b, ...); /* 164 */
} TifftclStubs;

#ifdef __cplusplus
extern "C" {
#endif
TIFFTCLAPI const TifftclStubs *tifftclStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TIFFTCL_STUBS)

/*
 * Inline function declarations:
 */

#define TIFFGetVersion \
	(tifftclStubsPtr->tIFFGetVersion) /* 0 */
#define TIFFFindCODEC \
	(tifftclStubsPtr->tIFFFindCODEC) /* 1 */
#define TIFFRegisterCODEC \
	(tifftclStubsPtr->tIFFRegisterCODEC) /* 2 */
#define TIFFUnRegisterCODEC \
	(tifftclStubsPtr->tIFFUnRegisterCODEC) /* 3 */
#define _TIFFmalloc \
	(tifftclStubsPtr->_TIFFmallocPtr) /* 4 */
#define _TIFFrealloc \
	(tifftclStubsPtr->_TIFFreallocPtr) /* 5 */
#define _TIFFmemset \
	(tifftclStubsPtr->_TIFFmemsetPtr) /* 6 */
#define _TIFFmemcpy \
	(tifftclStubsPtr->_TIFFmemcpyPtr) /* 7 */
#define _TIFFmemcmp \
	(tifftclStubsPtr->_TIFFmemcmpPtr) /* 8 */
#define _TIFFfree \
	(tifftclStubsPtr->_TIFFfreePtr) /* 9 */
#define TIFFClose \
	(tifftclStubsPtr->tIFFClose) /* 10 */
#define TIFFFlush \
	(tifftclStubsPtr->tIFFFlush) /* 11 */
#define TIFFFlushData \
	(tifftclStubsPtr->tIFFFlushData) /* 12 */
#define TIFFGetField \
	(tifftclStubsPtr->tIFFGetField) /* 13 */
#define TIFFVGetField \
	(tifftclStubsPtr->tIFFVGetField) /* 14 */
#define TIFFGetFieldDefaulted \
	(tifftclStubsPtr->tIFFGetFieldDefaulted) /* 15 */
#define TIFFVGetFieldDefaulted \
	(tifftclStubsPtr->tIFFVGetFieldDefaulted) /* 16 */
#define TIFFReadDirectory \
	(tifftclStubsPtr->tIFFReadDirectory) /* 17 */
#define TIFFScanlineSize \
	(tifftclStubsPtr->tIFFScanlineSize) /* 18 */
#define TIFFRasterScanlineSize \
	(tifftclStubsPtr->tIFFRasterScanlineSize) /* 19 */
#define TIFFStripSize \
	(tifftclStubsPtr->tIFFStripSize) /* 20 */
#define TIFFVStripSize \
	(tifftclStubsPtr->tIFFVStripSize) /* 21 */
#define TIFFTileRowSize \
	(tifftclStubsPtr->tIFFTileRowSize) /* 22 */
#define TIFFTileSize \
	(tifftclStubsPtr->tIFFTileSize) /* 23 */
#define TIFFVTileSize \
	(tifftclStubsPtr->tIFFVTileSize) /* 24 */
#define TIFFDefaultStripSize \
	(tifftclStubsPtr->tIFFDefaultStripSize) /* 25 */
#define TIFFDefaultTileSize \
	(tifftclStubsPtr->tIFFDefaultTileSize) /* 26 */
#define TIFFFileno \
	(tifftclStubsPtr->tIFFFileno) /* 27 */
#define TIFFGetMode \
	(tifftclStubsPtr->tIFFGetMode) /* 28 */
#define TIFFIsTiled \
	(tifftclStubsPtr->tIFFIsTiled) /* 29 */
#define TIFFIsByteSwapped \
	(tifftclStubsPtr->tIFFIsByteSwapped) /* 30 */
#define TIFFIsUpSampled \
	(tifftclStubsPtr->tIFFIsUpSampled) /* 31 */
#define TIFFIsMSB2LSB \
	(tifftclStubsPtr->tIFFIsMSB2LSB) /* 32 */
#define TIFFCurrentRow \
	(tifftclStubsPtr->tIFFCurrentRow) /* 33 */
#define TIFFCurrentDirectory \
	(tifftclStubsPtr->tIFFCurrentDirectory) /* 34 */
#define TIFFNumberOfDirectories \
	(tifftclStubsPtr->tIFFNumberOfDirectories) /* 35 */
#define TIFFCurrentDirOffset \
	(tifftclStubsPtr->tIFFCurrentDirOffset) /* 36 */
#define TIFFCurrentStrip \
	(tifftclStubsPtr->tIFFCurrentStrip) /* 37 */
#define TIFFCurrentTile \
	(tifftclStubsPtr->tIFFCurrentTile) /* 38 */
#define TIFFReadBufferSetup \
	(tifftclStubsPtr->tIFFReadBufferSetup) /* 39 */
#define TIFFWriteBufferSetup \
	(tifftclStubsPtr->tIFFWriteBufferSetup) /* 40 */
#define TIFFWriteCheck \
	(tifftclStubsPtr->tIFFWriteCheck) /* 41 */
#define TIFFCreateDirectory \
	(tifftclStubsPtr->tIFFCreateDirectory) /* 42 */
#define TIFFLastDirectory \
	(tifftclStubsPtr->tIFFLastDirectory) /* 43 */
#define TIFFSetDirectory \
	(tifftclStubsPtr->tIFFSetDirectory) /* 44 */
#define TIFFSetSubDirectory \
	(tifftclStubsPtr->tIFFSetSubDirectory) /* 45 */
#define TIFFUnlinkDirectory \
	(tifftclStubsPtr->tIFFUnlinkDirectory) /* 46 */
#define TIFFSetField \
	(tifftclStubsPtr->tIFFSetField) /* 47 */
#define TIFFVSetField \
	(tifftclStubsPtr->tIFFVSetField) /* 48 */
#define TIFFWriteDirectory \
	(tifftclStubsPtr->tIFFWriteDirectory) /* 49 */
/* Slot 50 is reserved */
#define TIFFPrintDirectory \
	(tifftclStubsPtr->tIFFPrintDirectory) /* 51 */
#define TIFFReadScanline \
	(tifftclStubsPtr->tIFFReadScanline) /* 52 */
#define TIFFWriteScanline \
	(tifftclStubsPtr->tIFFWriteScanline) /* 53 */
#define TIFFReadRGBAImage \
	(tifftclStubsPtr->tIFFReadRGBAImage) /* 54 */
#define TIFFReadRGBAStrip \
	(tifftclStubsPtr->tIFFReadRGBAStrip) /* 55 */
#define TIFFReadRGBATile \
	(tifftclStubsPtr->tIFFReadRGBATile) /* 56 */
/* Slot 57 is reserved */
/* Slot 58 is reserved */
#define TIFFRGBAImageGet \
	(tifftclStubsPtr->tIFFRGBAImageGet) /* 59 */
#define TIFFRGBAImageEnd \
	(tifftclStubsPtr->tIFFRGBAImageEnd) /* 60 */
#define TIFFOpen \
	(tifftclStubsPtr->tIFFOpen) /* 61 */
#define TIFFFdOpen \
	(tifftclStubsPtr->tIFFFdOpen) /* 62 */
#define TIFFClientOpen \
	(tifftclStubsPtr->tIFFClientOpen) /* 63 */
#define TIFFFileName \
	(tifftclStubsPtr->tIFFFileName) /* 64 */
#define TIFFError \
	(tifftclStubsPtr->tIFFError) /* 65 */
#define TIFFWarning \
	(tifftclStubsPtr->tIFFWarning) /* 66 */
#define TIFFSetErrorHandler \
	(tifftclStubsPtr->tIFFSetErrorHandler) /* 67 */
#define TIFFSetWarningHandler \
	(tifftclStubsPtr->tIFFSetWarningHandler) /* 68 */
#define TIFFSetTagExtender \
	(tifftclStubsPtr->tIFFSetTagExtender) /* 69 */
#define TIFFComputeTile \
	(tifftclStubsPtr->tIFFComputeTile) /* 70 */
#define TIFFCheckTile \
	(tifftclStubsPtr->tIFFCheckTile) /* 71 */
#define TIFFNumberOfTiles \
	(tifftclStubsPtr->tIFFNumberOfTiles) /* 72 */
#define TIFFReadTile \
	(tifftclStubsPtr->tIFFReadTile) /* 73 */
#define TIFFWriteTile \
	(tifftclStubsPtr->tIFFWriteTile) /* 74 */
#define TIFFComputeStrip \
	(tifftclStubsPtr->tIFFComputeStrip) /* 75 */
#define TIFFNumberOfStrips \
	(tifftclStubsPtr->tIFFNumberOfStrips) /* 76 */
#define TIFFReadEncodedStrip \
	(tifftclStubsPtr->tIFFReadEncodedStrip) /* 77 */
#define TIFFReadRawStrip \
	(tifftclStubsPtr->tIFFReadRawStrip) /* 78 */
#define TIFFReadEncodedTile \
	(tifftclStubsPtr->tIFFReadEncodedTile) /* 79 */
#define TIFFReadRawTile \
	(tifftclStubsPtr->tIFFReadRawTile) /* 80 */
#define TIFFWriteEncodedStrip \
	(tifftclStubsPtr->tIFFWriteEncodedStrip) /* 81 */
#define TIFFWriteRawStrip \
	(tifftclStubsPtr->tIFFWriteRawStrip) /* 82 */
#define TIFFWriteEncodedTile \
	(tifftclStubsPtr->tIFFWriteEncodedTile) /* 83 */
#define TIFFWriteRawTile \
	(tifftclStubsPtr->tIFFWriteRawTile) /* 84 */
#define TIFFSetWriteOffset \
	(tifftclStubsPtr->tIFFSetWriteOffset) /* 85 */
#define TIFFSwabShort \
	(tifftclStubsPtr->tIFFSwabShort) /* 86 */
#define TIFFSwabLong \
	(tifftclStubsPtr->tIFFSwabLong) /* 87 */
#define TIFFSwabDouble \
	(tifftclStubsPtr->tIFFSwabDouble) /* 88 */
#define TIFFSwabArrayOfShort \
	(tifftclStubsPtr->tIFFSwabArrayOfShort) /* 89 */
#define TIFFSwabArrayOfLong \
	(tifftclStubsPtr->tIFFSwabArrayOfLong) /* 90 */
#define TIFFSwabArrayOfDouble \
	(tifftclStubsPtr->tIFFSwabArrayOfDouble) /* 91 */
#define TIFFReverseBits \
	(tifftclStubsPtr->tIFFReverseBits) /* 92 */
#define TIFFGetBitRevTable \
	(tifftclStubsPtr->tIFFGetBitRevTable) /* 93 */
#define TIFFErrorExt \
	(tifftclStubsPtr->tIFFErrorExt) /* 94 */
#define TIFFGetStrileByteCount \
	(tifftclStubsPtr->tIFFGetStrileByteCount) /* 95 */
#define TIFFGetStrileOffset \
	(tifftclStubsPtr->tIFFGetStrileOffset) /* 96 */
/* Slot 97 is reserved */
/* Slot 98 is reserved */
/* Slot 99 is reserved */
#define TIFFPredictorInit \
	(tifftclStubsPtr->tIFFPredictorInit) /* 100 */
#define TIFFPredictorCleanup \
	(tifftclStubsPtr->tIFFPredictorCleanup) /* 101 */
/* Slot 102 is reserved */
/* Slot 103 is reserved */
/* Slot 104 is reserved */
/* Slot 105 is reserved */
/* Slot 106 is reserved */
/* Slot 107 is reserved */
/* Slot 108 is reserved */
/* Slot 109 is reserved */
/* Slot 110 is reserved */
#define TIFFMergeFieldInfo \
	(tifftclStubsPtr->tIFFMergeFieldInfo) /* 111 */
#define _TIFFPrintFieldInfo \
	(tifftclStubsPtr->_TIFFPrintFieldInfoPtr) /* 112 */
/* Slot 113 is reserved */
#define TIFFFieldWithTag \
	(tifftclStubsPtr->tIFFFieldWithTag) /* 114 */
#define _TIFFMergeFields \
	(tifftclStubsPtr->_TIFFMergeFieldsPtr) /* 115 */
/* Slot 116 is reserved */
/* Slot 117 is reserved */
/* Slot 118 is reserved */
/* Slot 119 is reserved */
/* Slot 120 is reserved */
/* Slot 121 is reserved */
/* Slot 122 is reserved */
/* Slot 123 is reserved */
/* Slot 124 is reserved */
/* Slot 125 is reserved */
/* Slot 126 is reserved */
#define _TIFFNoPostDecode \
	(tifftclStubsPtr->_TIFFNoPostDecodePtr) /* 127 */
/* Slot 128 is reserved */
/* Slot 129 is reserved */
/* Slot 130 is reserved */
/* Slot 131 is reserved */
/* Slot 132 is reserved */
#define TIFFFlushData1 \
	(tifftclStubsPtr->tIFFFlushData1) /* 133 */
#define TIFFFreeDirectory \
	(tifftclStubsPtr->tIFFFreeDirectory) /* 134 */
#define TIFFDefaultDirectory \
	(tifftclStubsPtr->tIFFDefaultDirectory) /* 135 */
#define TIFFSetCompressionScheme \
	(tifftclStubsPtr->tIFFSetCompressionScheme) /* 136 */
#define _TIFFSetDefaultCompressionState \
	(tifftclStubsPtr->_TIFFSetDefaultCompressionStatePtr) /* 137 */
#define _TIFFDefaultStripSize \
	(tifftclStubsPtr->_TIFFDefaultStripSizePtr) /* 138 */
/* Slot 139 is reserved */
#define _TIFFsetByteArray \
	(tifftclStubsPtr->_TIFFsetByteArrayPtr) /* 140 */
/* Slot 141 is reserved */
/* Slot 142 is reserved */
/* Slot 143 is reserved */
/* Slot 144 is reserved */
/* Slot 145 is reserved */
/* Slot 146 is reserved */
/* Slot 147 is reserved */
#define TIFFInitDumpMode \
	(tifftclStubsPtr->tIFFInitDumpMode) /* 148 */
#define TIFFInitPackBits \
	(tifftclStubsPtr->tIFFInitPackBits) /* 149 */
#define TIFFInitCCITTRLE \
	(tifftclStubsPtr->tIFFInitCCITTRLE) /* 150 */
#define TIFFInitCCITTRLEW \
	(tifftclStubsPtr->tIFFInitCCITTRLEW) /* 151 */
#define TIFFInitCCITTFax3 \
	(tifftclStubsPtr->tIFFInitCCITTFax3) /* 152 */
#define TIFFInitCCITTFax4 \
	(tifftclStubsPtr->tIFFInitCCITTFax4) /* 153 */
#define TIFFInitThunderScan \
	(tifftclStubsPtr->tIFFInitThunderScan) /* 154 */
#define TIFFInitNeXT \
	(tifftclStubsPtr->tIFFInitNeXT) /* 155 */
#define TIFFInitLZW \
	(tifftclStubsPtr->tIFFInitLZW) /* 156 */
#define TIFFInitOJPEG \
	(tifftclStubsPtr->tIFFInitOJPEG) /* 157 */
#define TIFFInitJPEG \
	(tifftclStubsPtr->tIFFInitJPEG) /* 158 */
#define TIFFInitJBIG \
	(tifftclStubsPtr->tIFFInitJBIG) /* 159 */
#define TIFFInitZIP \
	(tifftclStubsPtr->tIFFInitZIP) /* 160 */
#define TIFFInitPixarLog \
	(tifftclStubsPtr->tIFFInitPixarLog) /* 161 */
#define TIFFInitSGILog \
	(tifftclStubsPtr->tIFFInitSGILog) /* 162 */
#define _TIFFMultiplySSize \
	(tifftclStubsPtr->_TIFFMultiplySSizePtr) /* 163 */
#define TIFFWarningExt \
	(tifftclStubsPtr->tIFFWarningExt) /* 164 */

#endif /* defined(USE_TIFFTCL_STUBS) */

/* !END!: Do not edit above this line. */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TIFFTCLDECLS */

