/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.EntrySupport;
import org.openide.nodes.EntrySupportLazyState;
import org.openide.nodes.Node;

class EntrySupportLazy
extends EntrySupport {
    private static final int prefetchCount = Math.max(Integer.getInteger("org.openide.explorer.VisualizerNode.prefetchCount", 50), 0);
    static final Logger LOGGER = Logger.getLogger(EntrySupportLazy.class.getName());
    protected final AtomicReference<EntrySupportLazyState> internal = new AtomicReference<EntrySupportLazyState>(EntrySupportLazyState.UNINITIALIZED);
    protected final Object LOCK = new Object();
    private int snapshotCount;

    public EntrySupportLazy(Children children) {
        super(children);
    }

    private void setState(EntrySupportLazyState entrySupportLazyState, EntrySupportLazyState entrySupportLazyState2) {
        assert (Thread.holdsLock(this.LOCK));
        boolean bl = this.internal.compareAndSet(entrySupportLazyState, entrySupportLazyState2);
        assert (bl) : "Somebody changed internal state meanwhile!\nExpected: " + entrySupportLazyState + "\nCurrent : " + this.internal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInit() {
        Object object;
        EntrySupportLazyState entrySupportLazyState;
        boolean bl = false;
        Object object2 = this.LOCK;
        synchronized (object2) {
            entrySupportLazyState = this.internal.get();
            if (entrySupportLazyState.isInited()) {
                return true;
            }
            if (!entrySupportLazyState.isInitInProgress()) {
                bl = true;
                object = entrySupportLazyState.changeProgress(true).changeThread(Thread.currentThread());
                this.setState(entrySupportLazyState, (EntrySupportLazyState)object);
                entrySupportLazyState = object;
            }
        }
        boolean bl2 = LOGGER.isLoggable(Level.FINER);
        if (bl) {
            if (bl2) {
                LOGGER.finer("Initialize " + this + " on " + Thread.currentThread());
                LOGGER.finer("    callAddNotify()");
            }
            try {
                this.children.callAddNotify();
            }
            finally {
                object = this.LOCK;
                synchronized (object) {
                    class Notify
                    implements Runnable {
                        public Notify(EntrySupportLazyState entrySupportLazyState) {
                            EntrySupportLazyState entrySupportLazyState2 = EntrySupportLazy.this.internal.get();
                            EntrySupportLazy.this.setState(entrySupportLazyState2, entrySupportLazyState2.changeInited(true));
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = EntrySupportLazy.this.LOCK;
                            synchronized (object) {
                                EntrySupportLazyState entrySupportLazyState = EntrySupportLazy.this.internal.get();
                                if (!entrySupportLazyState.isInited()) {
                                    throw new IllegalStateException();
                                }
                                EntrySupportLazy.this.setState(entrySupportLazyState, entrySupportLazyState.changeThread(null));
                                EntrySupportLazy.this.LOCK.notifyAll();
                            }
                        }
                    }
                    Notify notify = new Notify(entrySupportLazyState);
                    if (Children.MUTEX.isReadAccess()) {
                        Children.MUTEX.postWriteRequest((Runnable)notify);
                    } else {
                        notify.run();
                    }
                }
            }
        }
        if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || entrySupportLazyState.initThread() == Thread.currentThread()) {
            if (bl2) {
                LOGGER.log(Level.FINER, "Cannot wait for finished initialization " + this + " on " + Thread.currentThread() + " read access: " + Children.MUTEX.isReadAccess() + " write access: " + Children.MUTEX.isWriteAccess() + " initThread: " + entrySupportLazyState.initThread());
            }
            this.notifySetEntries();
            return false;
        }
        object = this.LOCK;
        synchronized (object) {
            EntrySupportLazyState entrySupportLazyState2;
            while ((entrySupportLazyState2 = this.internal.get()).initThread() != null) {
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    final int getSnapshotCount() {
        assert (Thread.holdsLock(this.LOCK));
        return this.snapshotCount;
    }

    final void incrementCount() {
        assert (Thread.holdsLock(this.LOCK));
        ++this.snapshotCount;
    }

    final void decrementCount() {
        assert (Thread.holdsLock(this.LOCK));
        ++this.snapshotCount;
    }

    @Override
    List<Node> snapshot() {
        this.checkInit();
        try {
            Children.PR.enterReadAccess();
            LazySnapshot lazySnapshot = this.createSnapshot();
            return lazySnapshot;
        }
        finally {
            Children.PR.exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerNode(int n, EntrySupportLazyState.EntryInfo entryInfo) {
        if (n == -1) {
            try {
                Children.PR.enterWriteAccess();
                boolean bl = false;
                LOGGER.finer("register node");
                Object object = this.LOCK;
                synchronized (object) {
                    EntrySupportLazyState entrySupportLazyState = this.internal.get();
                    int n2 = 0;
                    boolean bl2 = false;
                    if ((n2 += this.getSnapshotCount()) == 0) {
                        for (Children.Entry entry : EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries())) {
                            EntrySupportLazyState.EntryInfo entryInfo2 = entrySupportLazyState.getEntryToInfo().get(entry);
                            if (entryInfo2.currentNode() != null) {
                                ++n2;
                                break;
                            }
                            if (entryInfo2 != entryInfo) continue;
                            bl2 = true;
                        }
                    }
                    boolean bl3 = bl = n2 == 0 && (bl2 || entryInfo == null);
                    if (bl) {
                        this.setState(entrySupportLazyState, entrySupportLazyState.changeInited(false).changeThread(null).changeProgress(false));
                        if (this.children.getEntrySupport() == this) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("callRemoveNotify() " + this);
                            }
                            this.children.callRemoveNotify();
                        }
                    }
                }
            }
            finally {
                Children.PR.exitWriteAccess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNodeAt(int n) {
        if (!this.checkInit()) {
            return null;
        }
        Object object = null;
        do {
            try {
                Children.Entry entry;
                Children.PR.enterReadAccess();
                EntrySupportLazyState entrySupportLazyState = this.internal.get();
                List<Children.Entry> list = EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries());
                if (n >= list.size()) {
                    entry = object;
                    return entry;
                }
                entry = list.get(n);
                EntrySupportLazyState.EntryInfo entryInfo = entrySupportLazyState.getEntryToInfo().get(entry);
                object = entryInfo.getNode();
                if (!EntrySupportLazy.isDummyNode((Node)object)) {
                    Object object2 = object;
                    return object2;
                }
                this.hideEmpty(null, entry);
            }
            finally {
                Children.PR.exitReadAccess();
            }
        } while (!Children.MUTEX.isReadAccess());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node[] getNodes(boolean bl) {
        Node[] nodeArray;
        if (!this.checkInit()) {
            return new Node[0];
        }
        Node node = null;
        if (bl) {
            node = this.children.findChild(null);
        }
        Children.LOG.log(Level.FINEST, "findChild returns: {0}", node);
        Children.LOG.log(Level.FINEST, "after findChild: {0}", bl);
        do {
            HashSet<Children.Entry> hashSet = null;
            nodeArray = null;
            try {
                Children.PR.enterReadAccess();
                EntrySupportLazyState entrySupportLazyState = this.internal.get();
                List<Children.Entry> list = EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries());
                ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
                for (Children.Entry entry : list) {
                    EntrySupportLazyState.EntryInfo entryInfo = entrySupportLazyState.getEntryToInfo().get(entry);
                    assert (!entryInfo.isHidden());
                    Node node2 = entryInfo.getNode();
                    if (EntrySupportLazy.isDummyNode(node2)) {
                        if (hashSet == null) {
                            hashSet = new HashSet<Children.Entry>();
                        }
                        hashSet.add(entry);
                    }
                    arrayList.add(node2);
                }
                nodeArray = arrayList.toArray(new Node[0]);
                if (hashSet == null) {
                    Node[] nodeArray2 = nodeArray;
                    return nodeArray2;
                }
                this.hideEmpty(hashSet, null);
            }
            finally {
                Children.PR.exitReadAccess();
            }
        } while (!Children.MUTEX.isReadAccess());
        return nodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node[] testNodes() {
        EntrySupportLazyState entrySupportLazyState = this.internal.get();
        if (!entrySupportLazyState.isInited()) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        try {
            Children.PR.enterReadAccess();
            for (Children.Entry entry : EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries())) {
                EntrySupportLazyState.EntryInfo entryInfo = entrySupportLazyState.getEntryToInfo().get(entry);
                Node node = entryInfo.currentNode();
                if (node == null) continue;
                arrayList.add(node);
            }
        }
        finally {
            Children.PR.exitReadAccess();
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new Node[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodesCount(boolean bl) {
        this.checkInit();
        try {
            Children.PR.enterReadAccess();
            EntrySupportLazyState entrySupportLazyState = this.internal.get();
            int n = EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries()).size();
            return n;
        }
        finally {
            Children.PR.exitReadAccess();
        }
    }

    @Override
    public boolean isInitialized() {
        EntrySupportLazyState entrySupportLazyState = this.internal.get();
        return entrySupportLazyState.isInited();
    }

    Children.Entry entryForNode(Node node) {
        EntrySupportLazyState entrySupportLazyState = this.internal.get();
        for (Map.Entry<Children.Entry, EntrySupportLazyState.EntryInfo> entry : entrySupportLazyState.getEntryToInfo().entrySet()) {
            if (entry.getValue().currentNode() != node) continue;
            return entry.getKey();
        }
        return null;
    }

    static boolean isDummyNode(Node node) {
        return node.getClass() == DummyNode.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void refreshEntry(Children.Entry entry) {
        EntrySupportLazyState[] entrySupportLazyStateArray;
        assert (Children.MUTEX.isWriteAccess());
        boolean bl = LOGGER.isLoggable(Level.FINER);
        if (bl) {
            LOGGER.finer("refreshEntry() " + this);
            LOGGER.finer("    entry: " + entry);
        }
        if (!(entrySupportLazyStateArray = new EntrySupportLazyState[]{this.internal.get()})[0].isInited()) {
            return;
        }
        EntrySupportLazyState.EntryInfo entryInfo = entrySupportLazyStateArray[0].getEntryToInfo().get(entry);
        if (entryInfo == null) {
            if (bl) {
                LOGGER.finer("    no such entry: " + entry);
            }
            return;
        }
        Node node = entryInfo.currentNode();
        EntrySupportLazyState.EntryInfo entryInfo2 = null;
        Node node2 = null;
        if (entryInfo.isHidden()) {
            node2 = entryInfo.getNode(true, null);
            entryInfo2 = entryInfo.changeIndex(-1);
        } else {
            entryInfo2 = entryInfo.changeNode(null);
            node2 = entryInfo2.getNode(true, null);
        }
        boolean bl2 = EntrySupportLazy.isDummyNode(node2);
        if (bl2 && entryInfo.isHidden()) {
            return;
        }
        if (node2.equals(node)) {
            return;
        }
        if (!entryInfo.isHidden() || bl2) {
            this.removeEntries(entrySupportLazyStateArray, null, entry, entryInfo2, true, true);
        }
        if (bl2) {
            return;
        }
        EntrySupportLazyState entrySupportLazyState = entrySupportLazyStateArray[0];
        HashMap<Children.Entry, EntrySupportLazyState.EntryInfo> hashMap = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(entrySupportLazyState.getEntryToInfo());
        int n = 0;
        int n2 = -1;
        ArrayList<Children.Entry> arrayList = new ArrayList<Children.Entry>();
        for (Children.Entry entry2 : entrySupportLazyState.getEntries()) {
            EntrySupportLazyState.EntryInfo entryInfo3 = null;
            if (entry2.equals(entry)) {
                entryInfo3 = entryInfo2;
                n2 = n;
            }
            if (entryInfo3 == null) {
                entryInfo3 = entrySupportLazyState.getEntryToInfo().get(entry2);
            }
            if (entryInfo3.isHidden()) continue;
            hashMap.put(entry2, entryInfo3.changeIndex(n++));
            arrayList.add(entry2);
        }
        assert (n2 != -1);
        Object object = this.LOCK;
        synchronized (object) {
            this.setState(entrySupportLazyState, entrySupportLazyState.changeEntries(null, arrayList, hashMap));
        }
        this.fireSubNodesChangeIdx(true, new int[]{n2}, entry, this.createSnapshot(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void notifySetEntries() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("notifySetEntries() " + this);
        }
        Object object = this.LOCK;
        synchronized (object) {
            EntrySupportLazyState entrySupportLazyState = this.internal.get();
            this.setState(entrySupportLazyState, entrySupportLazyState.changeMustNotify(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    void setEntries(Collection<? extends Children.Entry> collection, boolean bl) {
        Object object;
        Object object2;
        int n;
        Object object3;
        EntrySupportLazyState entrySupportLazyState;
        assert (Children.MUTEX.isWriteAccess());
        while (true) {
            EntrySupportLazyState[] entrySupportLazyStateArray;
            Set<Children.Entry> set;
            if ((set = this.setEntriesSimple(entrySupportLazyStateArray = new EntrySupportLazyState[]{null}, collection)) == null) {
                return;
            }
            if (!set.isEmpty()) {
                this.removeEntries(entrySupportLazyStateArray, set, null, null, false, false);
            }
            List<Children.Entry> list = this.updateOrder(entrySupportLazyStateArray, collection);
            entrySupportLazyState = entrySupportLazyStateArray[0];
            if (list.isEmpty()) return;
            ArrayList<Children.Entry> arrayList = new ArrayList<Children.Entry>(collection);
            object3 = new int[list.size()];
            n = 0;
            int n2 = 0;
            boolean bl2 = list.size() == 2 && prefetchCount > 0;
            ArrayList<Children.Entry> arrayList2 = new ArrayList<Children.Entry>();
            HashMap<Children.Entry, EntrySupportLazyState.EntryInfo> hashMap = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(entrySupportLazyState.getEntryToInfo());
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = arrayList.get(i);
                EntrySupportLazyState.EntryInfo entryInfo = (EntrySupportLazyState.EntryInfo)hashMap.get(object2);
                if (entryInfo == null) {
                    Node node;
                    entryInfo = new EntrySupportLazyState.EntryInfo(this, (Children.Entry)object2);
                    if (bl2 && EntrySupportLazy.isDummyNode(node = entryInfo.getNode())) {
                        hashMap.put((Children.Entry)object2, entryInfo.changeIndex(-2));
                        continue;
                    }
                    object3[n++] = n2;
                }
                if (entryInfo.isHidden()) continue;
                hashMap.put((Children.Entry)object2, entryInfo.changeIndex(n2++));
                arrayList2.add((Children.Entry)object2);
            }
            object = this.LOCK;
            // MONITORENTER : object
            object2 = entrySupportLazyState.changeEntries(arrayList, arrayList2, hashMap);
            if (this.internal.get() == entrySupportLazyState) break;
            entrySupportLazyState = this.internal.get();
            // MONITOREXIT : object
        }
        this.setState(entrySupportLazyState, (EntrySupportLazyState)object2);
        // MONITOREXIT : object
        if (n == 0) {
            return;
        }
        if (((int[])object3).length != n) {
            object = new int[n];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = object3[i];
            }
            object3 = object;
        }
        this.fireSubNodesChangeIdx(true, (int[])object3, null, this.createSnapshot(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Children.Entry> updateOrder(EntrySupportLazyState[] entrySupportLazyStateArray, Collection<? extends Children.Entry> collection) {
        assert (Children.MUTEX.isWriteAccess());
        EntrySupportLazyState entrySupportLazyState = entrySupportLazyStateArray[0];
        LinkedList<Children.Entry> linkedList = new LinkedList<Children.Entry>();
        int[] nArray = new int[entrySupportLazyState.getVisibleEntries().size()];
        int n = 0;
        int n2 = 0;
        LinkedList<Children.Entry> linkedList2 = null;
        ArrayList<Children.Entry> arrayList = null;
        HashMap<Children.Entry, EntrySupportLazyState.EntryInfo> hashMap = null;
        Map<Children.Entry, EntrySupportLazyState.EntryInfo> map = entrySupportLazyState.getEntryToInfo();
        for (Children.Entry object2 : collection) {
            EntrySupportLazyState.EntryInfo entryInfo = map.get(object2);
            if (entryInfo == null) {
                linkedList.add(object2);
                continue;
            }
            if (linkedList2 == null) {
                linkedList2 = new LinkedList<Children.Entry>();
                arrayList = new ArrayList<Children.Entry>();
                hashMap = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(map);
            }
            linkedList2.add(object2);
            if (entryInfo.isHidden()) continue;
            arrayList.add(object2);
            int n3 = entryInfo.getIndex();
            if (n != n3) {
                hashMap.put(object2, entryInfo.changeIndex(n));
                nArray[n3] = 1 + n;
                ++n2;
            }
            ++n;
        }
        if (n2 > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    nArray[i] = i;
                    continue;
                }
                int n4 = i;
                nArray[n4] = nArray[n4] - 1;
            }
            Object object = this.LOCK;
            synchronized (object) {
                EntrySupportLazyState entrySupportLazyState2 = entrySupportLazyState.changeEntries(linkedList2, arrayList, hashMap);
                this.setState(entrySupportLazyState, entrySupportLazyState2);
                entrySupportLazyStateArray[0] = entrySupportLazyState2;
            }
            object = this.children.parent;
            if (object != null) {
                ((Node)object).fireReorderChange(nArray);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getNode(Children.Entry entry) {
        this.checkInit();
        try {
            Children.PR.enterReadAccess();
            EntrySupportLazyState entrySupportLazyState = this.internal.get();
            EntrySupportLazyState.EntryInfo entryInfo = entrySupportLazyState.getEntryToInfo().get(entry);
            if (entryInfo == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("getNode() " + this);
                    LOGGER.finer("    no such entry: " + entry);
                }
                Node node = null;
                return node;
            }
            Node node = entryInfo.getNode();
            Node node2 = EntrySupportLazy.isDummyNode(node) ? null : node;
            return node2;
        }
        finally {
            Children.PR.exitReadAccess();
        }
    }

    protected void fireSubNodesChangeIdx(boolean bl, int[] nArray, Children.Entry entry, List<Node> list, List<Node> list2) {
        if (this.children.parent != null && this.children.getEntrySupport() == this) {
            this.children.parent.fireSubNodesChangeIdx(bl, nArray, entry, list, list2);
        }
    }

    static <T> List<T> notNull(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    static String dumpEntriesInfos(List<Children.Entry> list, Map<Children.Entry, EntrySupportLazyState.EntryInfo> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Children.Entry object : list) {
            stringBuilder.append("\n").append(++n).append(" entry ").append(object).append(" -> ").append(map.get(object));
        }
        stringBuilder.append("\n\n");
        for (Map.Entry entry : map.entrySet()) {
            if (list.contains(entry.getKey())) {
                stringBuilder.append("\n").append(" contained ").append(entry.getValue());
                continue;
            }
            stringBuilder.append("\n").append(" missing   ").append(entry.getValue()).append(" for ").append(entry.getKey());
        }
        return stringBuilder.toString();
    }

    @Override
    protected List<Children.Entry> getEntries() {
        EntrySupportLazyState entrySupportLazyState = this.internal.get();
        return entrySupportLazyState.getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Children.Entry> setEntriesSimple(EntrySupportLazyState[] entrySupportLazyStateArray, Collection<? extends Children.Entry> collection) {
        AbstractCollection abstractCollection;
        EntrySupportLazyState entrySupportLazyState;
        while (true) {
            Object object;
            entrySupportLazyState = entrySupportLazyStateArray[0] = this.internal.get();
            boolean bl = LOGGER.isLoggable(Level.FINER);
            if (bl) {
                LOGGER.finer("setEntries(): " + this);
                LOGGER.finer("    inited: " + entrySupportLazyState.isInited());
                LOGGER.finer("    mustNotifySetEnties: " + entrySupportLazyState.isMustNotify());
                LOGGER.finer("    newEntries size: " + collection.size() + " data:" + collection);
                LOGGER.finer("    entries size: " + entrySupportLazyState.getEntries().size() + " data:" + entrySupportLazyState.getEntries());
                LOGGER.finer("    visibleEntries size: " + EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries()).size() + " data:" + entrySupportLazyState.getVisibleEntries());
                LOGGER.finer("    entryToInfo size: " + entrySupportLazyState.getEntryToInfo().size());
            }
            int n = 0;
            int n2 = 0;
            assert ((n = entrySupportLazyState.getEntries().size()) >= 0);
            assert ((n2 = entrySupportLazyState.getEntryToInfo().size()) >= 0);
            assert (entrySupportLazyState.getEntries().size() == entrySupportLazyState.getEntryToInfo().size()) : "Entries: " + entrySupportLazyState.getEntries().size() + "; vis. entries: " + EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries()).size() + "; Infos: " + entrySupportLazyState.getEntryToInfo().size() + "; entriesSize: " + n + "; entryToInfoSize: " + n2 + EntrySupportLazy.dumpEntriesInfos(entrySupportLazyState.getEntries(), entrySupportLazyState.getEntryToInfo());
            if (entrySupportLazyState.isMustNotify() || entrySupportLazyState.isInited()) break;
            abstractCollection = new ArrayList<Children.Entry>(collection);
            ArrayList<Children.Entry> arrayList = new ArrayList<Children.Entry>(collection);
            HashMap<Children.Entry, EntrySupportLazyState.EntryInfo> hashMap = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>();
            Object object2 = entrySupportLazyState.getEntryToInfo();
            for (Children.Entry entry : collection) {
                EntrySupportLazyState.EntryInfo entryInfo = object2.get(entry);
                if (entryInfo == null) continue;
                hashMap.put(entry, entryInfo);
            }
            for (int i = 0; i < ((ArrayList)abstractCollection).size(); ++i) {
                void var12_17;
                object = (Children.Entry)((ArrayList)abstractCollection).get(i);
                EntrySupportLazyState.EntryInfo entryInfo = (EntrySupportLazyState.EntryInfo)hashMap.get(object);
                if (entryInfo == null) {
                    EntrySupportLazyState.EntryInfo entryInfo2 = new EntrySupportLazyState.EntryInfo(this, (Children.Entry)object);
                }
                hashMap.put((Children.Entry)object, var12_17.changeIndex(i));
            }
            object2 = this.LOCK;
            synchronized (object2) {
                if (entrySupportLazyState == this.internal.get()) {
                    object = entrySupportLazyState.changeEntries((List<Children.Entry>)((Object)abstractCollection), arrayList, hashMap);
                    this.setState(entrySupportLazyState, (EntrySupportLazyState)object);
                    entrySupportLazyStateArray[0] = object;
                    return null;
                }
            }
        }
        abstractCollection = new HashSet<Children.Entry>(entrySupportLazyState.getEntries());
        EntrySupportLazy.removeAllOpt(abstractCollection, collection);
        return abstractCollection;
    }

    private static boolean removeAllOpt(Set<Children.Entry> set, Collection<? extends Children.Entry> collection) {
        if (collection instanceof ArrayList && collection.size() > 100 && collection.size() >= set.size()) {
            HashSet<? extends Children.Entry> hashSet = new HashSet<Children.Entry>();
            hashSet.addAll(collection);
            return set.removeAll(hashSet);
        }
        return set.removeAll(collection);
    }

    void hideEmpty(final Set<Children.Entry> set, final Children.Entry entry) {
        Children.MUTEX.postWriteRequest(new Runnable(){

            @Override
            public void run() {
                EntrySupportLazyState[] entrySupportLazyStateArray = new EntrySupportLazyState[]{EntrySupportLazy.this.internal.get()};
                EntrySupportLazy.this.removeEntries(entrySupportLazyStateArray, set, entry, null, true, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntries(EntrySupportLazyState[] entrySupportLazyStateArray, Set<Children.Entry> set, Children.Entry entry, EntrySupportLazyState.EntryInfo entryInfo, boolean bl, boolean bl2) {
        assert (Children.MUTEX.isWriteAccess());
        boolean bl3 = LOGGER.isLoggable(Level.FINER);
        if (bl3) {
            LOGGER.finer("removeEntries(): " + this);
            LOGGER.finer("    entriesToRemove: " + set);
            LOGGER.finer("    entryToRemove: " + entry);
            LOGGER.finer("    newEntryInfo: " + entryInfo);
            LOGGER.finer("    justHide: " + bl);
            LOGGER.finer("    delayed: " + bl2);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = set != null ? set.size() : 1;
        int[] nArray = new int[n4];
        EntrySupportLazyState entrySupportLazyState = entrySupportLazyStateArray[0];
        List<Children.Entry> list = entrySupportLazyState.getVisibleEntries();
        HashMap<Children.Entry, EntrySupportLazyState.EntryInfo> hashMap = null;
        HashMap<Children.Entry, EntrySupportLazyState.EntryInfo> hashMap2 = null;
        ArrayList<Children.Entry> arrayList = bl ? null : new ArrayList<Children.Entry>();
        Node[] nodeArray = null;
        ArrayList<Children.Entry> arrayList2 = new ArrayList<Children.Entry>();
        Map<Children.Entry, EntrySupportLazyState.EntryInfo> map = entrySupportLazyState.getEntryToInfo();
        for (Children.Entry object2 : entrySupportLazyState.getEntries()) {
            Node[] nodeArray2 = map.get(object2);
            if (nodeArray2 == null) continue;
            int n5 = set != null ? set.remove(object2) : entry.equals(object2);
            if (n5 != 0) {
                if (nodeArray2.isHidden()) {
                    if (bl) continue;
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(map);
                    }
                    hashMap2.remove(object2);
                    continue;
                }
                nArray[n2++] = nodeArray2.getIndex();
                if (hashMap == null) {
                    hashMap = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(map);
                }
                Node node = nodeArray2.currentNode();
                if (!nodeArray2.isHidden() && node != null && !EntrySupportLazy.isDummyNode(node)) {
                    if (nodeArray == null) {
                        nodeArray = new Node[n4];
                    }
                    nodeArray[n3++] = node;
                }
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(map);
                }
                if (bl) {
                    EntrySupportLazyState.EntryInfo entryInfo2 = entryInfo != null ? entryInfo : nodeArray2.changeNode(null);
                    hashMap2.put(nodeArray2.entry(), entryInfo2.changeIndex(-2));
                    continue;
                }
                hashMap2.remove(object2);
                continue;
            }
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(map);
            }
            if (!nodeArray2.isHidden()) {
                arrayList2.add(nodeArray2.entry());
                hashMap2.put(nodeArray2.entry(), nodeArray2.changeIndex(n++));
            } else {
                hashMap2.put(nodeArray2.entry(), nodeArray2.changeIndex(-2));
            }
            if (bl) continue;
            arrayList.add(nodeArray2.entry());
        }
        if (!bl) {
            // empty if block
        }
        Object object4 = this.LOCK;
        synchronized (object4) {
            EntrySupportLazyState entrySupportLazyState2 = entrySupportLazyState.changeEntries(arrayList, arrayList2, hashMap2);
            this.setState(entrySupportLazyState, entrySupportLazyState2);
            entrySupportLazyStateArray[0] = entrySupportLazyState2;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 < nArray.length) {
            nArray = (int[])EntrySupportLazy.resizeArray(nArray, n2);
        }
        object4 = this.createSnapshot(arrayList2, new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(hashMap2), bl2);
        LazySnapshot lazySnapshot = this.createSnapshot(list, hashMap, false);
        this.fireSubNodesChangeIdx(false, nArray, entry, (List<Node>)object4, lazySnapshot);
        if (n3 > 0) {
            if (n3 < nodeArray.length) {
                nodeArray = (Node[])EntrySupportLazy.resizeArray(nodeArray, n3);
            }
            if (this.children.parent != null) {
                for (Node node : nodeArray) {
                    node.deassignFrom(this.children);
                    node.fireParentNodeChange(this.children.parent, null);
                }
            }
            this.children.destroyNodes(nodeArray);
        }
    }

    private static Object resizeArray(Object object, int n) {
        int n2 = Array.getLength(object);
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        int n3 = Math.min(n2, n);
        if (n3 > 0) {
            System.arraycopy(object, 0, object2, 0, n3);
        }
        return object2;
    }

    LazySnapshot createSnapshot() {
        EntrySupportLazyState entrySupportLazyState = this.internal.get();
        return this.createSnapshot(entrySupportLazyState.getVisibleEntries(), new HashMap<Children.Entry, EntrySupportLazyState.EntryInfo>(entrySupportLazyState.getEntryToInfo()), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LazySnapshot createSnapshot(List<Children.Entry> list, Map<Children.Entry, EntrySupportLazyState.EntryInfo> map, boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            return bl ? new DelayedLazySnapshot(list, map) : new LazySnapshot(list, map);
        }
    }

    final class DelayedLazySnapshot
    extends LazySnapshot {
        public DelayedLazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntrySupportLazyState.EntryInfo> map) {
            super(list, map);
        }
    }

    class LazySnapshot
    extends AbstractList<Node> {
        final List<Children.Entry> entries;
        final Map<Children.Entry, EntrySupportLazyState.EntryInfo> entryToInfo;

        public LazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntrySupportLazyState.EntryInfo> map) {
            EntrySupportLazy.this.incrementCount();
            this.entries = list;
            assert (list != null);
            Map<Children.Entry, EntrySupportLazyState.EntryInfo> map2 = this.entryToInfo = map != null ? map : Collections.emptyMap();
            assert (list.size() <= this.entryToInfo.size());
        }

        @Override
        public Node get(int n) {
            Children.Entry entry = this.entries.get(n);
            return this.get(entry);
        }

        Node get(Children.Entry entry) {
            EntrySupportLazyState.EntryInfo entryInfo = this.entryToInfo.get(entry);
            Node node = entryInfo.getNode();
            if (EntrySupportLazy.isDummyNode(node)) {
                EntrySupportLazy.this.hideEmpty(null, entry);
            }
            return node;
        }

        @Override
        public String toString() {
            return this.entries.toString();
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            boolean bl = false;
            Object object = EntrySupportLazy.this.LOCK;
            synchronized (object) {
                EntrySupportLazy.this.decrementCount();
                if (EntrySupportLazy.this.getSnapshotCount() == 0) {
                    bl = true;
                }
            }
            if (bl) {
                EntrySupportLazy.this.registerNode(-1, null);
            }
        }
    }

    static class DummyNode
    extends AbstractNode {
        public DummyNode() {
            super(Children.LEAF);
        }
    }
}

