/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.settings.wizards.impl;

import com.almworks.tracklink.settings.wizards.PatternSettingsWizard;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaSettingsWizard
implements PatternSettingsWizard {
    @Override
    @Nullable
    public Pair<String, String> requestUser(@NotNull Component dialogInvoker) {
        if (dialogInvoker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/settings/wizards/impl/BugzillaSettingsWizard.requestUser must not be null");
        }
        BugzillaDialogWrapper bugzillaDialogWrapper = new BugzillaDialogWrapper(dialogInvoker);
        bugzillaDialogWrapper.show();
        if (bugzillaDialogWrapper.getExitCode() == 0) {
            try {
                return BugzillaSettingsWizard.createPatterns(bugzillaDialogWrapper.getURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Pair<String, String> createPatterns(String url) throws MalformedURLException {
        String bugzillaURL = Utils.normalizeBugzillaURL(url);
        String searchPattern = "#(\\d+)\\b";
        String replacePattern = bugzillaURL + "show_bug.cgi?id=$1";
        return Pair.create((Object)searchPattern, (Object)replacePattern);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string = StringBundle.get("codelink.edit.bugzilla.button", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/settings/wizards/impl/BugzillaSettingsWizard.getName must not return null");
        }
        return string;
    }

    private static class BugzillaForm {
        private JTextField myURLField;
        private JLabel myIconLabel;
        private JPanel myWholePanel;
        private JLabel myUrlLabel;

        public BugzillaForm() {
            this.$$$setupUI$$$();
            this.myIconLabel.setIcon(Messages.getQuestionIcon());
            this.myUrlLabel.setLabelFor(this.myURLField);
        }

        public String getURL() {
            return this.myURLField.getText();
        }

        public JComponent getWholePanel() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JLabel jLabel;
            JLabel jLabel2;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myIconLabel = jLabel2 = new JLabel();
            jLabel2.setText("");
            jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myUrlLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.bugzilla.url"));
            jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myURLField = jTextField = new JTextField();
            jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.bugzilla.helptext"));
            jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class BugzillaDialogWrapper
    extends DialogWrapper {
        private final BugzillaForm myForm;

        public BugzillaDialogWrapper(Component parent) {
            super(parent, false);
            this.myForm = new BugzillaForm();
            this.setTitle(StringBundle.get("codelink.edit.bugzilla.title", new Object[0]));
            this.init();
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        BugzillaDialogWrapper.this.close(1);
                    }
                }
            });
        }

        protected JComponent createCenterPanel() {
            return this.myForm.getWholePanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myForm.myURLField;
        }

        public String getURL() {
            return this.myForm.getURL();
        }
    }
}

