/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.writer.AnnotationSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;

class BuilderAnnotationPool
extends BaseBuilderPool
implements AnnotationSection<BuilderStringReference, BuilderTypeReference, BuilderAnnotation, BuilderAnnotationElement, BuilderEncodedValues.BuilderEncodedValue> {
    @Nonnull
    private final ConcurrentMap<Annotation, BuilderAnnotation> internedItems = Maps.newConcurrentMap();

    public BuilderAnnotationPool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    @Nonnull
    public BuilderAnnotation internAnnotation(@Nonnull Annotation annotation) {
        BuilderAnnotation ret = (BuilderAnnotation)this.internedItems.get(annotation);
        if (ret != null) {
            return ret;
        }
        BuilderAnnotation dexBuilderAnnotation = new BuilderAnnotation(annotation.getVisibility(), ((BuilderTypePool)this.dexBuilder.typeSection).internType(annotation.getType()), this.dexBuilder.internAnnotationElements(annotation.getElements()));
        ret = this.internedItems.putIfAbsent(dexBuilderAnnotation, dexBuilderAnnotation);
        return ret == null ? dexBuilderAnnotation : ret;
    }

    @Override
    public int getVisibility(@Nonnull BuilderAnnotation key) {
        return key.visibility;
    }

    @Override
    @Nonnull
    public BuilderTypeReference getType(@Nonnull BuilderAnnotation key) {
        return key.type;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderAnnotationElement> getElements(@Nonnull BuilderAnnotation key) {
        return key.elements;
    }

    @Override
    @Nonnull
    public BuilderStringReference getElementName(@Nonnull BuilderAnnotationElement element) {
        return element.name;
    }

    @Override
    @Nonnull
    public BuilderEncodedValues.BuilderEncodedValue getElementValue(@Nonnull BuilderAnnotationElement element) {
        return element.value;
    }

    @Override
    public int getItemOffset(@Nonnull BuilderAnnotation key) {
        return key.offset;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderAnnotation, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderAnnotation>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderAnnotation key) {
                return key.offset;
            }

            @Override
            protected int setValue(@Nonnull BuilderAnnotation key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

