/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.OctetString;

public class Opaque
extends OctetString {
    private static final long serialVersionUID = -17056771587100877L;

    public Opaque() {
    }

    public Opaque(byte[] bytes) {
        super(bytes);
    }

    @Override
    public int getSyntax() {
        return 68;
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeString(outputStream, (byte)68, this.getValue());
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        byte[] v = BER.decodeString(inputStream, type);
        if (type.getValue() != 68) {
            throw new IOException("Wrong type encountered when decoding OctetString: " + type.getValue());
        }
        this.setValue(v);
    }

    public void setValue(OctetString value) {
        this.setValue(new byte[0]);
        this.append(value);
    }

    @Override
    public String toString() {
        return super.toHexString();
    }

    @Override
    public Object clone() {
        return new Opaque(super.getValue());
    }
}

