/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.util;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.util.ActionBuilder;
import org.openhab.core.automation.util.ConditionBuilder;
import org.openhab.core.automation.util.TriggerBuilder;
import org.openhab.core.config.core.Configuration;

@NonNullByDefault
public abstract class ModuleBuilder<B extends ModuleBuilder<B, T>, T extends Module> {
    private @Nullable String id;
    private @Nullable String typeUID;
    protected @Nullable Configuration configuration;
    protected @Nullable String label;
    protected @Nullable String description;

    public static ActionBuilder createAction() {
        return ActionBuilder.create();
    }

    public static ActionBuilder createAction(Action action) {
        return ActionBuilder.create(action);
    }

    public static ConditionBuilder createCondition() {
        return ConditionBuilder.create();
    }

    public static ConditionBuilder createCondition(Condition condition) {
        return ConditionBuilder.create(condition);
    }

    public static TriggerBuilder createTrigger() {
        return TriggerBuilder.create();
    }

    public static TriggerBuilder createTrigger(Trigger trigger) {
        return TriggerBuilder.create(trigger);
    }

    /*
     * WARNING - void declaration
     */
    public static <B extends ModuleBuilder<B, T>, T extends Module> ModuleBuilder<B, T> create(Module module) {
        Module module2 = module;
        if (module2 instanceof Action) {
            void action;
            Action action2 = (Action)module2;
            Action cfr_ignored_0 = (Action)module2;
            return ModuleBuilder.createAction((Action)action);
        }
        Module module3 = module;
        if (module3 instanceof Condition) {
            void condition;
            Condition condition2 = (Condition)module3;
            Condition cfr_ignored_1 = (Condition)module3;
            return ModuleBuilder.createCondition((Condition)condition);
        }
        Module module4 = module;
        if (module4 instanceof Trigger) {
            void trigger;
            Trigger trigger2 = (Trigger)module4;
            Trigger cfr_ignored_2 = (Trigger)module4;
            return ModuleBuilder.createTrigger((Trigger)trigger);
        }
        throw new IllegalArgumentException("Parameter must be an instance of Action, Condition or Trigger.");
    }

    protected ModuleBuilder() {
    }

    protected ModuleBuilder(T module) {
        this.id = module.getId();
        this.typeUID = module.getTypeUID();
        this.configuration = new Configuration(module.getConfiguration());
        this.label = module.getLabel();
        this.description = module.getDescription();
    }

    public B withId(String id) {
        this.id = id;
        return this.myself();
    }

    public B withTypeUID(String typeUID) {
        this.typeUID = typeUID;
        return this.myself();
    }

    public B withConfiguration(Configuration configuration) {
        this.configuration = new Configuration(configuration);
        return this.myself();
    }

    public B withLabel(@Nullable String label) {
        this.label = label;
        return this.myself();
    }

    public B withDescription(@Nullable String description) {
        this.description = description;
        return this.myself();
    }

    private B myself() {
        return (B)this;
    }

    protected String getId() {
        String id = this.id;
        if (id == null) {
            throw new IllegalStateException("The ID must not be null.");
        }
        return id;
    }

    protected String getTypeUID() {
        String typeUID = this.typeUID;
        if (typeUID == null) {
            throw new IllegalStateException("The type UID must not be null.");
        }
        return typeUID;
    }

    public abstract T build();
}

