/*	$OpenBSD: spleen6x12.h,v 1.3 2021/03/12 14:39:37 fcambus Exp $ */

/*
 * Copyright (c) 2018-2021 Frederic Cambus <fcambus@openbsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

static u_char spleen6x12_data[];

struct wsdisplay_font spleen6x12 = {
	.name		= "Spleen 6x12",
	.index		= 0,
	.firstchar	= ' ',
	.numchars	= 256 - ' ',
	.encoding	= WSDISPLAY_FONTENC_ISO,
	.fontwidth	= 6,
	.fontheight	= 12,
	.stride		= 1,
	.bitorder	= WSDISPLAY_FONTORDER_L2R,
	.byteorder	= WSDISPLAY_FONTORDER_L2R,
	.cookie		= NULL,
	.data		= spleen6x12_data
};

static u_char spleen6x12_data[] = {
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x50, 	/* .*.*.... */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0xf8, 	/* *****... */
	0x50, 	/* .*.*.... */
	0x50, 	/* .*.*.... */
	0x50, 	/* .*.*.... */
	0xf8, 	/* *****... */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x78, 	/* .****... */
	0xa0, 	/* *.*..... */
	0xa0, 	/* *.*..... */
	0x70, 	/* .***.... */
	0x28, 	/* ..*.*... */
	0x28, 	/* ..*.*... */
	0x28, 	/* ..*.*... */
	0xf0, 	/* ****.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x08, 	/* ....*... */
	0x48, 	/* .*..*... */
	0x50, 	/* .*.*.... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x28, 	/* ..*.*... */
	0x48, 	/* .*..*... */
	0x40, 	/* .*...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x94, 	/* *..*.*.. */
	0x88, 	/* *...*... */
	0x74, 	/* .***.*.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x18, 	/* ...**... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x60, 	/* .**..... */
	0x10, 	/* ...*.... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0xfc, 	/* ******.. */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0xf8, 	/* *****... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x98, 	/* *..**... */
	0xa8, 	/* *.*.*... */
	0xc8, 	/* **..*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x70, 	/* .***.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x08, 	/* ....*... */
	0x30, 	/* ..**.... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0xf8, 	/* *****... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x08, 	/* ....*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xb8, 	/* *.***... */
	0xb8, 	/* *.***... */
	0xb8, 	/* *.***... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xb8, 	/* *.***... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x90, 	/* *..*.... */
	0xe0, 	/* ***..... */
	0x90, 	/* *..*.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0xd8, 	/* **.**... */
	0xf8, 	/* *****... */
	0xa8, 	/* *.*.*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0xc8, 	/* **..*... */
	0xc8, 	/* **..*... */
	0xa8, 	/* *.*.*... */
	0xa8, 	/* *.*.*... */
	0x98, 	/* *..**... */
	0x98, 	/* *..**... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xa8, 	/* *.*.*... */
	0xf8, 	/* *****... */
	0xd8, 	/* **.**... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x50, 	/* .*.*.... */
	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x78, 	/* .****... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0xf0, 	/* ****.... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x90, 	/* *..*.... */
	0xa0, 	/* *.*..... */
	0xc0, 	/* **...... */
	0xa0, 	/* *.*..... */
	0x90, 	/* *..*.... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0xa8, 	/* *.*.*... */
	0xa8, 	/* *.*.*... */
	0xa8, 	/* *.*.*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0xe0, 	/* ***..... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x50, 	/* .*.*.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xa8, 	/* *.*.*... */
	0xf8, 	/* *****... */
	0xd8, 	/* **.**... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x18, 	/* ...**... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x60, 	/* .**..... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x48, 	/* .*..*... */
	0xb0, 	/* *.**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x78, 	/* .****... */
	0xa0, 	/* *.*..... */
	0xa0, 	/* *.*..... */
	0xa0, 	/* *.*..... */
	0xa0, 	/* *.*..... */
	0x78, 	/* .****... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x40, 	/* .*...... */
	0x40, 	/* .*...... */
	0xf0, 	/* ****.... */
	0x40, 	/* .*...... */
	0x80, 	/* *....... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x50, 	/* .*.*.... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x10, 	/* ...*.... */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x84, 	/* *....*.. */
	0x94, 	/* *..*.*.. */
	0xa4, 	/* *.*..*.. */
	0xa4, 	/* *.*..*.. */
	0xb4, 	/* *.**.*.. */
	0x84, 	/* *....*.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x08, 	/* ....*... */
	0x38, 	/* ..***... */
	0x48, 	/* .*..*... */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x24, 	/* ..*..*.. */
	0x48, 	/* .*..*... */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0x48, 	/* .*..*... */
	0x24, 	/* ..*..*.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x84, 	/* *....*.. */
	0xb4, 	/* *.**.*.. */
	0xac, 	/* *.*.**.. */
	0xb4, 	/* *.**.*.. */
	0xac, 	/* *.*.**.. */
	0x84, 	/* *....*.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0xf8, 	/* *****... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x10, 	/* ...*.... */
	0x08, 	/* ....*... */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0xe8, 	/* ***.*... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0xa8, 	/* *.*.*... */
	0xa8, 	/* *.*.*... */
	0x68, 	/* .**.*... */
	0x28, 	/* ..*.*... */
	0x28, 	/* ..*.*... */
	0x28, 	/* ..*.*... */
	0x28, 	/* ..*.*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x90, 	/* *..*.... */
	0x48, 	/* .*..*... */
	0x24, 	/* ..*..*.. */
	0x24, 	/* ..*..*.. */
	0x48, 	/* .*..*... */
	0x90, 	/* *..*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x40, 	/* .*...... */
	0xc0, 	/* **...... */
	0x40, 	/* .*...... */
	0x44, 	/* .*...*.. */
	0x48, 	/* .*..*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0xa8, 	/* *.*.*... */
	0x3c, 	/* ..****.. */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */

	0x40, 	/* .*...... */
	0xc0, 	/* **...... */
	0x40, 	/* .*...... */
	0x44, 	/* .*...*.. */
	0x48, 	/* .*..*... */
	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x58, 	/* .*.**... */
	0xa4, 	/* *.*..*.. */
	0x08, 	/* ....*... */
	0x10, 	/* ...*.... */
	0x3c, 	/* ..****.. */

	0x60, 	/* .**..... */
	0x90, 	/* *..*.... */
	0x20, 	/* ..*..... */
	0x14, 	/* ...*.*.. */
	0x98, 	/* *..**... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0xa8, 	/* *.*.*... */
	0x3c, 	/* ..****.. */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */

	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0x80, 	/* *....... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x48, 	/* .*..*... */
	0xb0, 	/* *.**.... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0xa0, 	/* *.*..... */
	0xa0, 	/* *.*..... */
	0xa0, 	/* *.*..... */
	0xf8, 	/* *****... */
	0xa0, 	/* *.*..... */
	0xa0, 	/* *.*..... */
	0xb8, 	/* *.***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */

	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0xe8, 	/* ***.*... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x48, 	/* .*..*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x48, 	/* .*..*... */
	0xb0, 	/* *.**.... */
	0x88, 	/* *...*... */
	0xc8, 	/* **..*... */
	0xc8, 	/* **..*... */
	0xa8, 	/* *.*.*... */
	0xa8, 	/* *.*.*... */
	0x98, 	/* *..**... */
	0x98, 	/* *..**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x48, 	/* .*..*... */
	0xb0, 	/* *.**.... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x48, 	/* .*..*... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x48, 	/* .*..*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x08, 	/* ....*... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x98, 	/* *..**... */
	0xa8, 	/* *.*.*... */
	0xa8, 	/* *.*.*... */
	0xc8, 	/* **..*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x90, 	/* *..*.... */
	0x90, 	/* *..*.... */
	0xa0, 	/* *.*..... */
	0x90, 	/* *..*.... */
	0x88, 	/* *...*... */
	0xc8, 	/* **..*... */
	0xb0, 	/* *.**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x48, 	/* .*..*... */
	0xb0, 	/* *.**.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x20, 	/* ..*..... */
	0x70, 	/* .***.... */
	0x08, 	/* ....*... */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xd8, 	/* **.**... */
	0x28, 	/* ..*.*... */
	0x68, 	/* .**.*... */
	0xb8, 	/* *.***... */
	0xa0, 	/* *.*..... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */

	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf8, 	/* *****... */
	0x80, 	/* *....... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0xa0, 	/* *.*..... */
	0x40, 	/* .*...... */
	0xa0, 	/* *.*..... */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x48, 	/* .*..*... */
	0xb0, 	/* *.**.... */
	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x48, 	/* .*..*... */
	0xb0, 	/* *.**.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x08, 	/* ....*... */
	0x70, 	/* .***.... */
	0x98, 	/* *..**... */
	0xa8, 	/* *.*.*... */
	0xc8, 	/* **..*... */
	0x88, 	/* *...*... */
	0x70, 	/* .***.... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x20, 	/* ..*..... */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x10, 	/* ...*.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */

	0x00, 	/* ........ */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0xf0, 	/* ****.... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0xf0, 	/* ****.... */
	0x80, 	/* *....... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x50, 	/* .*.*.... */
	0x00, 	/* ........ */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x88, 	/* *...*... */
	0x78, 	/* .****... */
	0x08, 	/* ....*... */
	0x08, 	/* ....*... */
	0xf0, 	/* ****.... */
};
