/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Iterator;
import java.util.List;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.internal.Utils;

class FilteredParameters
implements Iterator<Object[]> {
    private int index = 0;
    private boolean hasWarn = false;
    private final Iterator<Object[]> parameters;
    private final ITestNGMethod testMethod;
    private final String dataProviderName;
    private final List<Integer> indices;

    public FilteredParameters(Iterator<Object[]> parameters, ITestNGMethod testMethod, String dataProviderName, List<Integer> indices) {
        this.parameters = parameters;
        this.testMethod = testMethod;
        this.dataProviderName = dataProviderName;
        this.indices = indices;
    }

    @Override
    public boolean hasNext() {
        if (this.index == 0 && !this.parameters.hasNext() && !this.hasWarn) {
            this.hasWarn = true;
            String msg = String.format("The test method '%s' will be skipped since its data provider '%s' returned an empty array or iterator. ", this.testMethod.getQualifiedName(), this.dataProviderName);
            Utils.warn(msg);
        }
        return this.parameters.hasNext();
    }

    @Override
    public Object[] next() {
        this.testMethod.setParameterInvocationCount(this.index);
        Object[] next = this.parameters.next();
        if (next == null) {
            throw new TestNGException("Parameters must not be null");
        }
        if (!this.indices.isEmpty() && !this.indices.contains(this.index)) {
            next = null;
        }
        ++this.index;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

