/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.pool.ConnectionPool;
import io.agroal.pool.Pool;
import io.agroal.pool.Poolless;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public final class DataSource
implements AgroalDataSource {
    private static final long serialVersionUID = 6485903416474487024L;
    private final AgroalDataSourceConfiguration configuration;
    private final Pool connectionPool;

    public DataSource(AgroalDataSourceConfiguration dataSourceConfiguration, AgroalDataSourceListener ... listeners) {
        this.configuration = dataSourceConfiguration;
        this.connectionPool = this.configuration.dataSourceImplementation() == AgroalDataSourceConfiguration.DataSourceImplementation.AGROAL_POOLLESS ? new Poolless(dataSourceConfiguration.connectionPoolConfiguration(), listeners) : new ConnectionPool(dataSourceConfiguration.connectionPoolConfiguration(), listeners);
        dataSourceConfiguration.registerMetricsEnabledListener((AgroalDataSourceConfiguration.MetricsEnabledListener)this.connectionPool);
        this.connectionPool.onMetricsEnabled(dataSourceConfiguration.metricsEnabled());
        this.connectionPool.init();
    }

    public void setPoolInterceptors(Collection<? extends AgroalPoolInterceptor> interceptors) {
        this.connectionPool.setPoolInterceptors(interceptors == null ? Collections.emptyList() : interceptors);
    }

    public List<AgroalPoolInterceptor> getPoolInterceptors() {
        return this.connectionPool.getPoolInterceptors();
    }

    public AgroalDataSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public AgroalDataSourceMetrics getMetrics() {
        return this.connectionPool.getMetrics();
    }

    public void flush(AgroalDataSource.FlushMode mode) {
        this.connectionPool.flushPool(mode);
    }

    public boolean isHealthy(boolean newConnection) throws SQLException {
        return this.connectionPool.isHealthy(newConnection);
    }

    public void close() {
        this.connectionPool.close();
    }

    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("username and password combination invalid on a pooled data source!");
    }

    public <T> T unwrap(Class<T> target) throws SQLException {
        return target.cast(this);
    }

    public boolean isWrapperFor(Class<?> target) throws SQLException {
        return target.isInstance(this);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not Supported");
    }
}

