/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawUnixSHACryptPassword;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public interface UnixSHACryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_CRYPT_SHA_256 = "crypt-sha-256";
    public static final String ALGORITHM_CRYPT_SHA_512 = "crypt-sha-512";
    public static final int SALT_SIZE = 16;
    public static final int DEFAULT_ITERATION_COUNT = 5000;

    public byte[] getSalt();

    public byte[] getHash();

    public int getIterationCount();

    @Override
    default public IteratedSaltedPasswordAlgorithmSpec getParameterSpec() {
        return new IteratedSaltedPasswordAlgorithmSpec(this.getIterationCount(), this.getSalt());
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"parameterSpec", (Object)parameterSpec);
        if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
            IteratedSaltedPasswordAlgorithmSpec spec = (IteratedSaltedPasswordAlgorithmSpec)parameterSpec;
            return this.getIterationCount() <= spec.getIterationCount() && Arrays.equals(this.getSalt(), spec.getSalt());
        }
        if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
            return Arrays.equals(this.getSalt(), ((SaltedPasswordAlgorithmSpec)parameterSpec).getSalt());
        }
        if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
            return this.getIterationCount() <= ((IteratedPasswordAlgorithmSpec)parameterSpec).getIterationCount();
        }
        return false;
    }

    @Override
    public UnixSHACryptPassword clone();

    public static UnixSHACryptPassword createRaw(String algorithm, byte[] salt, byte[] hash, int iterationCount) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        return new RawUnixSHACryptPassword(algorithm, salt, hash, iterationCount);
    }
}

