/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.util.logging.Log;

public class PartitionHandlingConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<PartitionHandlingConfiguration> {
    private final AttributeSet attributes = PartitionHandlingConfiguration.attributeDefinitionSet();

    public PartitionHandlingConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    PartitionHandling whenSplit() {
        return (PartitionHandling)((Object)this.attributes.attribute(PartitionHandlingConfiguration.WHEN_SPLIT).get());
    }

    public PartitionHandlingConfigurationBuilder whenSplit(PartitionHandling partitionHandling) {
        this.attributes.attribute(PartitionHandlingConfiguration.WHEN_SPLIT).set((Object)partitionHandling);
        return this;
    }

    public PartitionHandlingConfigurationBuilder mergePolicy(EntryMergePolicy mergePolicy) {
        this.attributes.attribute(PartitionHandlingConfiguration.MERGE_POLICY).set((Object)mergePolicy);
        return this;
    }

    public void validate() {
        if (this.attributes.attribute(PartitionHandlingConfiguration.WHEN_SPLIT).get() != PartitionHandling.ALLOW_READ_WRITES && this.clustering().cacheMode().isInvalidation()) {
            throw Log.CONFIG.invalidationPartitionHandlingNotSuported();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public PartitionHandlingConfiguration create() {
        return new PartitionHandlingConfiguration(this.attributes.protect());
    }

    public Builder<?> read(PartitionHandlingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

