/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.micrometer.v1_5.Bridging;
import io.opentelemetry.instrumentation.micrometer.v1_5.RemovableMeter;
import io.opentelemetry.instrumentation.micrometer.v1_5.UnsupportedReadLogger;
import java.util.Collections;

final class OpenTelemetryCounter
extends AbstractMeter
implements Counter,
RemovableMeter {
    private final DoubleCounter otelCounter;
    private final Attributes attributes;
    private volatile boolean removed = false;

    OpenTelemetryCounter(Meter.Id id, NamingConvention namingConvention, Meter otelMeter) {
        super(id);
        this.attributes = Bridging.tagsAsAttributes(id, namingConvention);
        String conventionName = Bridging.name(id, namingConvention);
        this.otelCounter = otelMeter.counterBuilder(conventionName).setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).ofDoubles().build();
    }

    public void increment(double v) {
        if (this.removed) {
            return;
        }
        this.otelCounter.add(v, this.attributes);
    }

    public double count() {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.removed = true;
    }
}

