/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import org.hibernate.Incubating;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;

@Incubating
public class ManagedResultConsumer
implements ResultsConsumer<Void, Object> {
    public static final ManagedResultConsumer INSTANCE = new ManagedResultConsumer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<Object> rowReader) {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        RuntimeException ex = null;
        persistenceContext.beforeLoad();
        persistenceContext.getLoadContexts().register(jdbcValuesSourceProcessingState);
        try {
            rowReader.startLoading(rowProcessingState);
            while (rowProcessingState.next()) {
                rowReader.readRow(rowProcessingState);
                rowProcessingState.finishRowProcessing(true);
            }
            rowReader.finishUp(rowProcessingState);
            jdbcValuesSourceProcessingState.finishUp(true);
            Void void_ = null;
            return void_;
        }
        catch (RuntimeException e) {
            ex = e;
            return ex;
        }
        finally {
            try {
                jdbcValues.finishUp(session);
                persistenceContext.afterLoad();
                persistenceContext.getLoadContexts().deregister(jdbcValuesSourceProcessingState);
                persistenceContext.initializeNonLazyCollections();
            }
            catch (RuntimeException e) {
                if (ex != null) {
                    ex.addSuppressed(e);
                }
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) throw new IllegalStateException("Should not reach this");
                throw ex;
            }
        }
    }

    @Override
    public boolean canResultsBeCached() {
        return false;
    }
}

