/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObjectMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OBJECTTYPE;

    public XrSceneObjectMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneObjectMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSceneObjectTypeMSFT")
    public int objectType() {
        return XrSceneObjectMSFT.nobjectType(this.address());
    }

    public XrSceneObjectMSFT objectType(@NativeType(value="XrSceneObjectTypeMSFT") int value) {
        XrSceneObjectMSFT.nobjectType(this.address(), value);
        return this;
    }

    public XrSceneObjectMSFT set(XrSceneObjectMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneObjectMSFT malloc() {
        return (XrSceneObjectMSFT)XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneObjectMSFT calloc() {
        return (XrSceneObjectMSFT)XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneObjectMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneObjectMSFT)XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneObjectMSFT create(long address) {
        return (XrSceneObjectMSFT)XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneObjectMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneObjectMSFT)XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneObjectMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneObjectMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneObjectMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObjectMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneObjectMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneObjectMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneObjectMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneObjectMSFT malloc(MemoryStack stack) {
        return (XrSceneObjectMSFT)XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneObjectMSFT calloc(MemoryStack stack) {
        return (XrSceneObjectMSFT)XrSceneObjectMSFT.wrap(XrSceneObjectMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneObjectMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneObjectMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    static {
        Struct.Layout layout = XrSceneObjectMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneObjectMSFT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OBJECTTYPE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObjectMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObjectMSFT ELEMENT_FACTORY = XrSceneObjectMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneObjectMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSceneObjectTypeMSFT")
        public int objectType() {
            return XrSceneObjectMSFT.nobjectType(this.address());
        }

        public Buffer objectType(@NativeType(value="XrSceneObjectTypeMSFT") int value) {
            XrSceneObjectMSFT.nobjectType(this.address(), value);
            return this;
        }
    }
}

