/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindAccelerationStructureMemoryInfoNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ACCELERATIONSTRUCTURE;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int DEVICEINDEXCOUNT;
    public static final int PDEVICEINDICES;

    public VkBindAccelerationStructureMemoryInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindAccelerationStructureMemoryInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindAccelerationStructureMemoryInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindAccelerationStructureMemoryInfoNV.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureNV")
    public long accelerationStructure() {
        return VkBindAccelerationStructureMemoryInfoNV.naccelerationStructure(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkBindAccelerationStructureMemoryInfoNV.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkBindAccelerationStructureMemoryInfoNV.nmemoryOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceIndexCount() {
        return VkBindAccelerationStructureMemoryInfoNV.ndeviceIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pDeviceIndices() {
        return VkBindAccelerationStructureMemoryInfoNV.npDeviceIndices(this.address());
    }

    public VkBindAccelerationStructureMemoryInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkBindAccelerationStructureMemoryInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkBindAccelerationStructureMemoryInfoNV sType$Default() {
        return this.sType(1000165006);
    }

    public VkBindAccelerationStructureMemoryInfoNV pNext(@NativeType(value="void const *") long value) {
        VkBindAccelerationStructureMemoryInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkBindAccelerationStructureMemoryInfoNV accelerationStructure(@NativeType(value="VkAccelerationStructureNV") long value) {
        VkBindAccelerationStructureMemoryInfoNV.naccelerationStructure(this.address(), value);
        return this;
    }

    public VkBindAccelerationStructureMemoryInfoNV memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindAccelerationStructureMemoryInfoNV.nmemory(this.address(), value);
        return this;
    }

    public VkBindAccelerationStructureMemoryInfoNV memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindAccelerationStructureMemoryInfoNV.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkBindAccelerationStructureMemoryInfoNV pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBindAccelerationStructureMemoryInfoNV.npDeviceIndices(this.address(), value);
        return this;
    }

    public VkBindAccelerationStructureMemoryInfoNV set(int sType, long pNext, long accelerationStructure, long memory, long memoryOffset, @Nullable IntBuffer pDeviceIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.accelerationStructure(accelerationStructure);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.pDeviceIndices(pDeviceIndices);
        return this;
    }

    public VkBindAccelerationStructureMemoryInfoNV set(VkBindAccelerationStructureMemoryInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindAccelerationStructureMemoryInfoNV malloc() {
        return (VkBindAccelerationStructureMemoryInfoNV)VkBindAccelerationStructureMemoryInfoNV.wrap(VkBindAccelerationStructureMemoryInfoNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBindAccelerationStructureMemoryInfoNV calloc() {
        return (VkBindAccelerationStructureMemoryInfoNV)VkBindAccelerationStructureMemoryInfoNV.wrap(VkBindAccelerationStructureMemoryInfoNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBindAccelerationStructureMemoryInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBindAccelerationStructureMemoryInfoNV)VkBindAccelerationStructureMemoryInfoNV.wrap(VkBindAccelerationStructureMemoryInfoNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBindAccelerationStructureMemoryInfoNV create(long address) {
        return (VkBindAccelerationStructureMemoryInfoNV)VkBindAccelerationStructureMemoryInfoNV.wrap(VkBindAccelerationStructureMemoryInfoNV.class, (long)address);
    }

    @Nullable
    public static VkBindAccelerationStructureMemoryInfoNV createSafe(long address) {
        return address == 0L ? null : (VkBindAccelerationStructureMemoryInfoNV)VkBindAccelerationStructureMemoryInfoNV.wrap(VkBindAccelerationStructureMemoryInfoNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBindAccelerationStructureMemoryInfoNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBindAccelerationStructureMemoryInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBindAccelerationStructureMemoryInfoNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindAccelerationStructureMemoryInfoNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBindAccelerationStructureMemoryInfoNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBindAccelerationStructureMemoryInfoNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBindAccelerationStructureMemoryInfoNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkBindAccelerationStructureMemoryInfoNV mallocStack() {
        return VkBindAccelerationStructureMemoryInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindAccelerationStructureMemoryInfoNV callocStack() {
        return VkBindAccelerationStructureMemoryInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindAccelerationStructureMemoryInfoNV mallocStack(MemoryStack stack) {
        return VkBindAccelerationStructureMemoryInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkBindAccelerationStructureMemoryInfoNV callocStack(MemoryStack stack) {
        return VkBindAccelerationStructureMemoryInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindAccelerationStructureMemoryInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindAccelerationStructureMemoryInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindAccelerationStructureMemoryInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindAccelerationStructureMemoryInfoNV.calloc(capacity, stack);
    }

    public static VkBindAccelerationStructureMemoryInfoNV malloc(MemoryStack stack) {
        return (VkBindAccelerationStructureMemoryInfoNV)VkBindAccelerationStructureMemoryInfoNV.wrap(VkBindAccelerationStructureMemoryInfoNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindAccelerationStructureMemoryInfoNV calloc(MemoryStack stack) {
        return (VkBindAccelerationStructureMemoryInfoNV)VkBindAccelerationStructureMemoryInfoNV.wrap(VkBindAccelerationStructureMemoryInfoNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBindAccelerationStructureMemoryInfoNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBindAccelerationStructureMemoryInfoNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long naccelerationStructure(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACCELERATIONSTRUCTURE);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYOFFSET);
    }

    public static int ndeviceIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npDeviceIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEVICEINDICES)), (int)VkBindAccelerationStructureMemoryInfoNV.ndeviceIndexCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void naccelerationStructure(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ACCELERATIONSTRUCTURE, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORYOFFSET, value);
    }

    public static void ndeviceIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEINDEXCOUNT, value);
    }

    public static void npDeviceIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEVICEINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkBindAccelerationStructureMemoryInfoNV.ndeviceIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBindAccelerationStructureMemoryInfoNV.ndeviceIndexCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEVICEINDICES)));
        }
    }

    static {
        Struct.Layout layout = VkBindAccelerationStructureMemoryInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkBindAccelerationStructureMemoryInfoNV.__member((int)4), VkBindAccelerationStructureMemoryInfoNV.__member((int)POINTER_SIZE), VkBindAccelerationStructureMemoryInfoNV.__member((int)8), VkBindAccelerationStructureMemoryInfoNV.__member((int)8), VkBindAccelerationStructureMemoryInfoNV.__member((int)8), VkBindAccelerationStructureMemoryInfoNV.__member((int)4), VkBindAccelerationStructureMemoryInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ACCELERATIONSTRUCTURE = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
        DEVICEINDEXCOUNT = layout.offsetof(5);
        PDEVICEINDICES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkBindAccelerationStructureMemoryInfoNV, Buffer>
    implements NativeResource {
        private static final VkBindAccelerationStructureMemoryInfoNV ELEMENT_FACTORY = VkBindAccelerationStructureMemoryInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBindAccelerationStructureMemoryInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindAccelerationStructureMemoryInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindAccelerationStructureMemoryInfoNV.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureNV")
        public long accelerationStructure() {
            return VkBindAccelerationStructureMemoryInfoNV.naccelerationStructure(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkBindAccelerationStructureMemoryInfoNV.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkBindAccelerationStructureMemoryInfoNV.nmemoryOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceIndexCount() {
            return VkBindAccelerationStructureMemoryInfoNV.ndeviceIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pDeviceIndices() {
            return VkBindAccelerationStructureMemoryInfoNV.npDeviceIndices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindAccelerationStructureMemoryInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000165006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindAccelerationStructureMemoryInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer accelerationStructure(@NativeType(value="VkAccelerationStructureNV") long value) {
            VkBindAccelerationStructureMemoryInfoNV.naccelerationStructure(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindAccelerationStructureMemoryInfoNV.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindAccelerationStructureMemoryInfoNV.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer pDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBindAccelerationStructureMemoryInfoNV.npDeviceIndices(this.address(), value);
            return this;
        }
    }
}

