/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCuModuleCreateInfoNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DATASIZE;
    public static final int PDATA;

    public VkCuModuleCreateInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCuModuleCreateInfoNVX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCuModuleCreateInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCuModuleCreateInfoNVX.npNext(this.address());
    }

    @NativeType(value="size_t")
    public long dataSize() {
        return VkCuModuleCreateInfoNVX.ndataSize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pData() {
        return VkCuModuleCreateInfoNVX.npData(this.address());
    }

    public VkCuModuleCreateInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkCuModuleCreateInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkCuModuleCreateInfoNVX sType$Default() {
        return this.sType(1000029000);
    }

    public VkCuModuleCreateInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkCuModuleCreateInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkCuModuleCreateInfoNVX pData(@NativeType(value="void const *") ByteBuffer value) {
        VkCuModuleCreateInfoNVX.npData(this.address(), value);
        return this;
    }

    public VkCuModuleCreateInfoNVX set(int sType, long pNext, ByteBuffer pData) {
        this.sType(sType);
        this.pNext(pNext);
        this.pData(pData);
        return this;
    }

    public VkCuModuleCreateInfoNVX set(VkCuModuleCreateInfoNVX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCuModuleCreateInfoNVX malloc() {
        return (VkCuModuleCreateInfoNVX)VkCuModuleCreateInfoNVX.wrap(VkCuModuleCreateInfoNVX.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkCuModuleCreateInfoNVX calloc() {
        return (VkCuModuleCreateInfoNVX)VkCuModuleCreateInfoNVX.wrap(VkCuModuleCreateInfoNVX.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkCuModuleCreateInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkCuModuleCreateInfoNVX)VkCuModuleCreateInfoNVX.wrap(VkCuModuleCreateInfoNVX.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkCuModuleCreateInfoNVX create(long address) {
        return (VkCuModuleCreateInfoNVX)VkCuModuleCreateInfoNVX.wrap(VkCuModuleCreateInfoNVX.class, (long)address);
    }

    @Nullable
    public static VkCuModuleCreateInfoNVX createSafe(long address) {
        return address == 0L ? null : (VkCuModuleCreateInfoNVX)VkCuModuleCreateInfoNVX.wrap(VkCuModuleCreateInfoNVX.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkCuModuleCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkCuModuleCreateInfoNVX.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkCuModuleCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCuModuleCreateInfoNVX.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkCuModuleCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkCuModuleCreateInfoNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkCuModuleCreateInfoNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkCuModuleCreateInfoNVX malloc(MemoryStack stack) {
        return (VkCuModuleCreateInfoNVX)VkCuModuleCreateInfoNVX.wrap(VkCuModuleCreateInfoNVX.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCuModuleCreateInfoNVX calloc(MemoryStack stack) {
        return (VkCuModuleCreateInfoNVX)VkCuModuleCreateInfoNVX.wrap(VkCuModuleCreateInfoNVX.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCuModuleCreateInfoNVX.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCuModuleCreateInfoNVX.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long ndataSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATASIZE));
    }

    public static ByteBuffer npData(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)), (int)((int)VkCuModuleCreateInfoNVX.ndataSize(struct)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndataSize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATASIZE), (long)value);
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        VkCuModuleCreateInfoNVX.ndataSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)));
    }

    static {
        Struct.Layout layout = VkCuModuleCreateInfoNVX.__struct((Struct.Member[])new Struct.Member[]{VkCuModuleCreateInfoNVX.__member((int)4), VkCuModuleCreateInfoNVX.__member((int)POINTER_SIZE), VkCuModuleCreateInfoNVX.__member((int)POINTER_SIZE), VkCuModuleCreateInfoNVX.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DATASIZE = layout.offsetof(2);
        PDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCuModuleCreateInfoNVX, Buffer>
    implements NativeResource {
        private static final VkCuModuleCreateInfoNVX ELEMENT_FACTORY = VkCuModuleCreateInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCuModuleCreateInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCuModuleCreateInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCuModuleCreateInfoNVX.npNext(this.address());
        }

        @NativeType(value="size_t")
        public long dataSize() {
            return VkCuModuleCreateInfoNVX.ndataSize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pData() {
            return VkCuModuleCreateInfoNVX.npData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCuModuleCreateInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000029000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCuModuleCreateInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer pData(@NativeType(value="void const *") ByteBuffer value) {
            VkCuModuleCreateInfoNVX.npData(this.address(), value);
            return this;
        }
    }
}

