/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.opus.OPEPacketFuncI;
import org.lwjgl.util.opus.Opus;
import org.lwjgl.util.opus.OpusEncCallbacks;

public class OpusEnc {
    public static final int OPE_API_VERSION = 0;
    public static final int OPE_OK = 0;
    public static final int OPE_BAD_ARG = -11;
    public static final int OPE_INTERNAL_ERROR = -13;
    public static final int OPE_UNIMPLEMENTED = -15;
    public static final int OPE_ALLOC_FAIL = -17;
    public static final int OPE_CANNOT_OPEN = -30;
    public static final int OPE_TOO_LATE = -31;
    public static final int OPE_INVALID_PICTURE = -32;
    public static final int OPE_INVALID_ICON = -33;
    public static final int OPE_WRITE_FAIL = -34;
    public static final int OPE_CLOSE_FAIL = -35;
    public static final int OPE_SET_DECISION_DELAY_REQUEST = 14000;
    public static final int OPE_GET_DECISION_DELAY_REQUEST = 14001;
    public static final int OPE_SET_MUXING_DELAY_REQUEST = 14002;
    public static final int OPE_GET_MUXING_DELAY_REQUEST = 14003;
    public static final int OPE_SET_COMMENT_PADDING_REQUEST = 14004;
    public static final int OPE_GET_COMMENT_PADDING_REQUEST = 14005;
    public static final int OPE_SET_SERIALNO_REQUEST = 14006;
    public static final int OPE_GET_SERIALNO_REQUEST = 14007;
    public static final int OPE_SET_PACKET_CALLBACK_REQUEST = 14008;
    public static final int OPE_SET_HEADER_GAIN_REQUEST = 14010;
    public static final int OPE_GET_HEADER_GAIN_REQUEST = 14011;
    public static final int OPE_GET_NB_STREAMS_REQUEST = 14013;
    public static final int OPE_GET_NB_COUPLED_STREAMS_REQUEST = 14015;

    protected OpusEnc() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="OggOpusComments *")
    public static long ope_comments_create() {
        long __functionAddress = Functions.comments_create;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="OggOpusComments *")
    public static long ope_comments_copy(@NativeType(value="OggOpusComments *") long comments) {
        long __functionAddress = Functions.comments_copy;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        return JNI.invokePP((long)comments, (long)__functionAddress);
    }

    public static void ope_comments_destroy(@NativeType(value="OggOpusComments *") long comments) {
        long __functionAddress = Functions.comments_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        JNI.invokePV((long)comments, (long)__functionAddress);
    }

    public static int nope_comments_add(long comments, long tag, long val) {
        long __functionAddress = Functions.comments_add;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        return JNI.invokePPPI((long)comments, (long)tag, (long)val, (long)__functionAddress);
    }

    public static int ope_comments_add(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") ByteBuffer tag, @NativeType(value="char const *") ByteBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)tag);
            Checks.checkNT1((ByteBuffer)val);
        }
        return OpusEnc.nope_comments_add(comments, MemoryUtil.memAddress((ByteBuffer)tag), MemoryUtil.memAddress((ByteBuffer)val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ope_comments_add(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") CharSequence tag, @NativeType(value="char const *") CharSequence val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(tag, true);
            long tagEncoded = stack.getPointerAddress();
            stack.nUTF8(val, true);
            long valEncoded = stack.getPointerAddress();
            int n = OpusEnc.nope_comments_add(comments, tagEncoded, valEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nope_comments_add_string(long comments, long tag_and_val) {
        long __functionAddress = Functions.comments_add_string;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        return JNI.invokePPI((long)comments, (long)tag_and_val, (long)__functionAddress);
    }

    public static int ope_comments_add_string(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") ByteBuffer tag_and_val) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)tag_and_val);
        }
        return OpusEnc.nope_comments_add_string(comments, MemoryUtil.memAddress((ByteBuffer)tag_and_val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ope_comments_add_string(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") CharSequence tag_and_val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(tag_and_val, true);
            long tag_and_valEncoded = stack.getPointerAddress();
            int n = OpusEnc.nope_comments_add_string(comments, tag_and_valEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nope_comments_add_picture(long comments, long filename, int picture_type, long description) {
        long __functionAddress = Functions.comments_add_picture;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        return JNI.invokePPPI((long)comments, (long)filename, (int)picture_type, (long)description, (long)__functionAddress);
    }

    public static int ope_comments_add_picture(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") ByteBuffer filename, int picture_type, @Nullable @NativeType(value="char const *") ByteBuffer description) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.checkNT1Safe((ByteBuffer)description);
        }
        return OpusEnc.nope_comments_add_picture(comments, MemoryUtil.memAddress((ByteBuffer)filename), picture_type, MemoryUtil.memAddressSafe((ByteBuffer)description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ope_comments_add_picture(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") CharSequence filename, int picture_type, @Nullable @NativeType(value="char const *") CharSequence description) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            stack.nUTF8Safe(description, true);
            long descriptionEncoded = description == null ? 0L : stack.getPointerAddress();
            int n = OpusEnc.nope_comments_add_picture(comments, filenameEncoded, picture_type, descriptionEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nope_comments_add_picture_from_memory(long comments, long ptr, long size, int picture_type, long description) {
        long __functionAddress = Functions.comments_add_picture_from_memory;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        return JNI.invokePPPPI((long)comments, (long)ptr, (long)size, (int)picture_type, (long)description, (long)__functionAddress);
    }

    public static int ope_comments_add_picture_from_memory(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") ByteBuffer ptr, int picture_type, @Nullable @NativeType(value="char const *") ByteBuffer description) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)description);
        }
        return OpusEnc.nope_comments_add_picture_from_memory(comments, MemoryUtil.memAddress((ByteBuffer)ptr), ptr.remaining(), picture_type, MemoryUtil.memAddressSafe((ByteBuffer)description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ope_comments_add_picture_from_memory(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="char const *") ByteBuffer ptr, int picture_type, @Nullable @NativeType(value="char const *") CharSequence description) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(description, true);
            long descriptionEncoded = description == null ? 0L : stack.getPointerAddress();
            int n = OpusEnc.nope_comments_add_picture_from_memory(comments, MemoryUtil.memAddress((ByteBuffer)ptr), ptr.remaining(), picture_type, descriptionEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nope_encoder_create_file(long path, long comments, int rate, int channels, int family, long error) {
        long __functionAddress = Functions.encoder_create_file;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        return JNI.invokePPPP((long)path, (long)comments, (int)rate, (int)channels, (int)family, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OggOpusEnc *")
    public static long ope_encoder_create_file(@NativeType(value="char const *") ByteBuffer path, @NativeType(value="OggOpusComments *") long comments, @NativeType(value="opus_int32") int rate, int channels, int family, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return OpusEnc.nope_encoder_create_file(MemoryUtil.memAddress((ByteBuffer)path), comments, rate, channels, family, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="OggOpusEnc *")
    public static long ope_encoder_create_file(@NativeType(value="char const *") CharSequence path, @NativeType(value="OggOpusComments *") long comments, @NativeType(value="opus_int32") int rate, int channels, int family, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = OpusEnc.nope_encoder_create_file(pathEncoded, comments, rate, channels, family, MemoryUtil.memAddressSafe((IntBuffer)error));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nope_encoder_create_callbacks(long callbacks, long user_data, long comments, int rate, int channels, int family, long error) {
        long __functionAddress = Functions.encoder_create_callbacks;
        if (Checks.CHECKS) {
            OpusEncCallbacks.validate(callbacks);
            Checks.check((long)user_data);
            Checks.check((long)comments);
        }
        return JNI.invokePPPPP((long)callbacks, (long)user_data, (long)comments, (int)rate, (int)channels, (int)family, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OggOpusEnc *")
    public static long ope_encoder_create_callbacks(@NativeType(value="OpusEncCallbacks const *") OpusEncCallbacks callbacks, @NativeType(value="void *") long user_data, @NativeType(value="OggOpusComments *") long comments, @NativeType(value="opus_int32") int rate, int channels, int family, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return OpusEnc.nope_encoder_create_callbacks(callbacks.address(), user_data, comments, rate, channels, family, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static long nope_encoder_create_pull(long comments, int rate, int channels, int family, long error) {
        long __functionAddress = Functions.encoder_create_pull;
        if (Checks.CHECKS) {
            Checks.check((long)comments);
        }
        return JNI.invokePPP((long)comments, (int)rate, (int)channels, (int)family, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OggOpusEnc *")
    public static long ope_encoder_create_pull(@NativeType(value="OggOpusComments *") long comments, @NativeType(value="opus_int32") int rate, int channels, int family, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return OpusEnc.nope_encoder_create_pull(comments, rate, channels, family, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static int nope_encoder_deferred_init_with_mapping(long enc, int family, int streams, int coupled_streams, long mapping) {
        long __functionAddress = Functions.encoder_deferred_init_with_mapping;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        return JNI.invokePPI((long)enc, (int)family, (int)streams, (int)coupled_streams, (long)mapping, (long)__functionAddress);
    }

    public static int ope_encoder_deferred_init_with_mapping(@NativeType(value="OggOpusEnc *") long enc, int family, int streams, int coupled_streams, @NativeType(value="unsigned char const *") ByteBuffer mapping) {
        return OpusEnc.nope_encoder_deferred_init_with_mapping(enc, family, streams, coupled_streams, MemoryUtil.memAddress((ByteBuffer)mapping));
    }

    public static int nope_encoder_write_float(long enc, long pcm, int samples_per_channel) {
        long __functionAddress = Functions.encoder_write_float;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        return JNI.invokePPI((long)enc, (long)pcm, (int)samples_per_channel, (long)__functionAddress);
    }

    public static int ope_encoder_write_float(@NativeType(value="OggOpusEnc *") long enc, @NativeType(value="float const *") FloatBuffer pcm, int samples_per_channel) {
        return OpusEnc.nope_encoder_write_float(enc, MemoryUtil.memAddress((FloatBuffer)pcm), samples_per_channel);
    }

    public static int nope_encoder_write(long enc, long pcm, int samples_per_channel) {
        long __functionAddress = Functions.encoder_write;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        return JNI.invokePPI((long)enc, (long)pcm, (int)samples_per_channel, (long)__functionAddress);
    }

    public static int ope_encoder_write(@NativeType(value="OggOpusEnc *") long enc, @NativeType(value="opus_int16 const *") ShortBuffer pcm, int samples_per_channel) {
        return OpusEnc.nope_encoder_write(enc, MemoryUtil.memAddress((ShortBuffer)pcm), samples_per_channel);
    }

    public static int nope_encoder_get_page(long enc, long page, long len, int flush) {
        long __functionAddress = Functions.encoder_get_page;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        return JNI.invokePPPI((long)enc, (long)page, (long)len, (int)flush, (long)__functionAddress);
    }

    @NativeType(value="int")
    public static boolean ope_encoder_get_page(@NativeType(value="OggOpusEnc *") long enc, @NativeType(value="unsigned char **") PointerBuffer page, @NativeType(value="opus_int32 *") IntBuffer len, @NativeType(value="int") boolean flush) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)page, (int)1);
            Checks.check((Buffer)len, (int)1);
        }
        return OpusEnc.nope_encoder_get_page(enc, MemoryUtil.memAddress((CustomBuffer)page), MemoryUtil.memAddress((IntBuffer)len), flush ? 1 : 0) != 0;
    }

    public static int ope_encoder_drain(@NativeType(value="OggOpusEnc *") long enc) {
        long __functionAddress = Functions.encoder_drain;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        return JNI.invokePI((long)enc, (long)__functionAddress);
    }

    public static void ope_encoder_destroy(@NativeType(value="OggOpusEnc *") long enc) {
        long __functionAddress = Functions.encoder_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        JNI.invokePV((long)enc, (long)__functionAddress);
    }

    public static int ope_encoder_chain_current(@NativeType(value="OggOpusEnc *") long enc, @NativeType(value="OggOpusComments *") long comments) {
        long __functionAddress = Functions.encoder_chain_current;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
            Checks.check((long)comments);
        }
        return JNI.invokePPI((long)enc, (long)comments, (long)__functionAddress);
    }

    public static int nope_encoder_continue_new_file(long enc, long path, long comments) {
        long __functionAddress = Functions.encoder_continue_new_file;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
            Checks.check((long)comments);
        }
        return JNI.invokePPPI((long)enc, (long)path, (long)comments, (long)__functionAddress);
    }

    public static int ope_encoder_continue_new_file(@NativeType(value="OggOpusEnc *") long enc, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="OggOpusComments *") long comments) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
        }
        return OpusEnc.nope_encoder_continue_new_file(enc, MemoryUtil.memAddress((ByteBuffer)path), comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ope_encoder_continue_new_file(@NativeType(value="OggOpusEnc *") long enc, @NativeType(value="char const *") CharSequence path, @NativeType(value="OggOpusComments *") long comments) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            int n = OpusEnc.nope_encoder_continue_new_file(enc, pathEncoded, comments);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ope_encoder_continue_new_callbacks(@NativeType(value="OggOpusEnc *") long enc, @NativeType(value="void *") long user_data, @NativeType(value="OggOpusComments *") long comments) {
        long __functionAddress = Functions.encoder_continue_new_callbacks;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
            Checks.check((long)user_data);
            Checks.check((long)comments);
        }
        return JNI.invokePPPI((long)enc, (long)user_data, (long)comments, (long)__functionAddress);
    }

    public static int ope_encoder_flush_header(@NativeType(value="OggOpusEnc *") long enc) {
        long __functionAddress = Functions.encoder_flush_header;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        return JNI.invokePI((long)enc, (long)__functionAddress);
    }

    private static int ope_encoder_ctl(@NativeType(value="OggOpusEnc *") long enc) {
        long __functionAddress = Functions.encoder_ctl;
        if (Checks.CHECKS) {
            Checks.check((long)enc);
        }
        return JNI.invokePI((long)enc, (long)__functionAddress);
    }

    public static long nope_strerror(int error) {
        long __functionAddress = Functions.strerror;
        return JNI.invokeP((int)error, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String ope_strerror(int error) {
        long __result = OpusEnc.nope_strerror(error);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nope_get_version_string() {
        long __functionAddress = Functions.get_version_string;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String ope_get_version_string() {
        long __result = OpusEnc.nope_get_version_string();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static int ope_get_abi_version() {
        long __functionAddress = Functions.get_abi_version;
        return JNI.invokeI((long)__functionAddress);
    }

    public static int ope_encoder_ctl(@NativeType(value="OggOpusEnc *") long enc, int request) {
        return new Opus.CTLRequestV(request).apply(enc, Functions.encoder_ctl);
    }

    public static int ope_encoder_ctl(@NativeType(value="OggOpusEnc *") long enc, Opus.CTLRequest request) {
        return request.apply(enc, Functions.encoder_ctl);
    }

    public static Opus.CTLRequest OPE_SET_DECISION_DELAY_REQUEST(int value) {
        return new Opus.CTLRequestI(14000, value);
    }

    public static Opus.CTLRequest OPE_GET_DECISION_DELAY_REQUEST(IntBuffer __result) {
        return new Opus.CTLRequestP(14001, MemoryUtil.memAddress((IntBuffer)__result));
    }

    public static Opus.CTLRequest OPE_SET_MUXING_DELAY_REQUEST(int value) {
        return new Opus.CTLRequestI(14002, value);
    }

    public static Opus.CTLRequest OPE_GET_MUXING_DELAY_REQUEST(IntBuffer __result) {
        return new Opus.CTLRequestP(14003, MemoryUtil.memAddress((IntBuffer)__result));
    }

    public static Opus.CTLRequest OPE_SET_COMMENT_PADDING_REQUEST(int value) {
        return new Opus.CTLRequestI(14004, value);
    }

    public static Opus.CTLRequest OPE_GET_COMMENT_PADDING_REQUEST(IntBuffer __result) {
        return new Opus.CTLRequestP(14005, MemoryUtil.memAddress((IntBuffer)__result));
    }

    public static Opus.CTLRequest OPE_SET_SERIALNO_REQUEST(int value) {
        return new Opus.CTLRequestI(14006, value);
    }

    public static Opus.CTLRequest OPE_GET_SERIALNO_REQUEST(IntBuffer __result) {
        return new Opus.CTLRequestP(14007, MemoryUtil.memAddress((IntBuffer)__result));
    }

    public static Opus.CTLRequest OPE_SET_PACKET_CALLBACK_REQUEST(OPEPacketFuncI value) {
        return new Opus.CTLRequestP(14008, value.address());
    }

    public static Opus.CTLRequest OPE_SET_HEADER_GAIN_REQUEST(int value) {
        return new Opus.CTLRequestI(14010, value);
    }

    public static Opus.CTLRequest OPE_GET_HEADER_GAIN_REQUEST(IntBuffer __result) {
        return new Opus.CTLRequestP(14011, MemoryUtil.memAddress((IntBuffer)__result));
    }

    public static Opus.CTLRequest OPE_GET_NB_STREAMS_REQUEST(IntBuffer __result) {
        return new Opus.CTLRequestP(14013, MemoryUtil.memAddress((IntBuffer)__result));
    }

    public static Opus.CTLRequest OPE_GET_NB_COUPLED_STREAMS_REQUEST(IntBuffer __result) {
        return new Opus.CTLRequestP(14015, MemoryUtil.memAddress((IntBuffer)__result));
    }

    public static final class Functions {
        public static final long comments_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_comments_create");
        public static final long comments_copy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_comments_copy");
        public static final long comments_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_comments_destroy");
        public static final long comments_add = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_comments_add");
        public static final long comments_add_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_comments_add_string");
        public static final long comments_add_picture = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_comments_add_picture");
        public static final long comments_add_picture_from_memory = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_comments_add_picture_from_memory");
        public static final long encoder_create_file = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_create_file");
        public static final long encoder_create_callbacks = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_create_callbacks");
        public static final long encoder_create_pull = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_create_pull");
        public static final long encoder_deferred_init_with_mapping = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_deferred_init_with_mapping");
        public static final long encoder_write_float = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_write_float");
        public static final long encoder_write = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_write");
        public static final long encoder_get_page = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_get_page");
        public static final long encoder_drain = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_drain");
        public static final long encoder_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_destroy");
        public static final long encoder_chain_current = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_chain_current");
        public static final long encoder_continue_new_file = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_continue_new_file");
        public static final long encoder_continue_new_callbacks = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_continue_new_callbacks");
        public static final long encoder_flush_header = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_flush_header");
        public static final long encoder_ctl = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_encoder_ctl");
        public static final long strerror = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_strerror");
        public static final long get_version_string = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_get_version_string");
        public static final long get_abi_version = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"ope_get_abi_version");

        private Functions() {
        }
    }
}

