/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PatternUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternUtil.class);

    private PatternUtil() {
    }

    public static MatchResult checkPattern(String pattern, String input) {
        if (!ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp")) {
            throw new RuntimeException("PatternUtil usage detected");
        }
        MatchResult result = new MatchResult();
        for (int i = 0; i < pattern.length(); ++i) {
            try {
                Matcher matcher = Pattern.compile("(" + pattern.substring(0, i) + ")[\\s\\S]*").matcher(input);
                if (!matcher.matches()) continue;
                result.patternMatch = pattern.substring(0, i);
                result.patternTail = pattern.substring(i);
                result.stringMatch = matcher.group(1);
                result.stringTail = input.substring(matcher.group(1).length());
                continue;
            }
            catch (PatternSyntaxException error) {
                LOGGER.warn("Pattern matching error", (Throwable)error);
            }
        }
        return result;
    }

    public static class MatchResult {
        private String patternMatch;
        private String patternTail;
        private String stringMatch;
        private String stringTail;

        public String getPatternMatch() {
            return this.patternMatch;
        }

        public String getPatternTail() {
            return this.patternTail;
        }

        public String getStringMatch() {
            return this.stringMatch;
        }

        public String getStringTail() {
            return this.stringTail;
        }
    }
}

