/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.util.ArrayUnenforcedSet;

public class EdmondsBlossomShrinking<V, E>
implements MatchingAlgorithm<V, E> {
    private UndirectedGraph<V, E> graph;
    private Set<E> matching;
    private Map<V, V> match;
    private Map<V, V> path;
    private Map<V, V> contracted;

    @Deprecated
    public EdmondsBlossomShrinking() {
    }

    public EdmondsBlossomShrinking(UndirectedGraph<V, E> G) {
        this.graph = G;
    }

    @Deprecated
    public Set<E> findMatch(UndirectedGraph<V, E> g) {
        return new EdmondsBlossomShrinking<V, E>(g).getMatching();
    }

    @Override
    public Set<E> getMatching() {
        if (this.matching == null) {
            this.matching = this.findMatch();
        }
        return Collections.unmodifiableSet(this.matching);
    }

    private Set<E> findMatch() {
        ArrayUnenforcedSet result = new ArrayUnenforcedSet();
        this.match = new HashMap<V, V>();
        this.path = new HashMap<V, V>();
        this.contracted = new HashMap<V, V>();
        for (Object i : this.graph.vertexSet()) {
            if (this.match.containsKey(i)) continue;
            Object v = this.findPath(i);
            while (v != null) {
                V pv = this.path.get(v);
                V ppv = this.match.get(pv);
                this.match.put(v, pv);
                this.match.put(pv, v);
                v = ppv;
            }
        }
        HashSet<V> seen = new HashSet<V>();
        for (Object v : this.graph.vertexSet()) {
            if (seen.contains(v) || !this.match.containsKey(v)) continue;
            seen.add(v);
            seen.add(this.match.get(v));
            result.add(this.graph.getEdge(v, this.match.get(v)));
        }
        return result;
    }

    private V findPath(V root) {
        HashSet used = new HashSet();
        ArrayDeque q = new ArrayDeque();
        this.path.clear();
        this.contracted.clear();
        for (Object i : this.graph.vertexSet()) {
            this.contracted.put(i, i);
        }
        used.add(root);
        q.add(root);
        while (!q.isEmpty()) {
            Object v = q.remove();
            for (Object e : this.graph.edgesOf(v)) {
                Object to = this.graph.getEdgeSource(e);
                if (to == v) {
                    to = this.graph.getEdgeTarget(e);
                }
                if (this.contracted.get(v) == this.contracted.get(to) || this.match.get(v) == to) continue;
                if (to == root || this.match.containsKey(to) && this.path.containsKey(this.match.get(to))) {
                    Object stem = this.lca(v, to);
                    HashSet blossom = new HashSet();
                    this.markPath(v, to, stem, blossom);
                    this.markPath(to, v, stem, blossom);
                    for (Object i : this.graph.vertexSet()) {
                        if (!this.contracted.containsKey(i) || !blossom.contains(this.contracted.get(i))) continue;
                        this.contracted.put(i, stem);
                        if (used.contains(i)) continue;
                        used.add(i);
                        q.add(i);
                    }
                    continue;
                }
                if (this.path.containsKey(to)) continue;
                this.path.put(to, v);
                if (!this.match.containsKey(to)) {
                    return to;
                }
                to = this.match.get(to);
                used.add(to);
                q.add(to);
            }
        }
        return null;
    }

    private void markPath(V v, V child, V stem, Set<V> blossom) {
        while (this.contracted.get(v) != stem) {
            blossom.add(this.contracted.get(v));
            blossom.add(this.contracted.get(this.match.get(v)));
            this.path.put(v, child);
            child = this.match.get(v);
            v = this.path.get(this.match.get(v));
        }
    }

    private V lca(V a, V b) {
        HashSet<V> seen = new HashSet<V>();
        while (true) {
            a = this.contracted.get(a);
            seen.add(a);
            if (!this.match.containsKey(a)) break;
            a = this.path.get(this.match.get(a));
        }
        while (!seen.contains(b = this.contracted.get(b))) {
            b = this.path.get(this.match.get(b));
        }
        return b;
    }
}

