/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarTimeStamps;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarPageTimings {
    public static String TABLE_NAME = "page_timings";
    private Long onContentLoad;
    private Long onLoad;
    private String comment;
    private HarTimeStamps timeStamps;
    private HarCustomFields customFields = new HarCustomFields();

    public HarPageTimings() {
    }

    public HarPageTimings(long onContentLoad, long onLoad, String comment) {
        this.onContentLoad = onContentLoad;
        this.onLoad = onLoad;
        this.comment = comment;
    }

    public HarPageTimings(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"pageTimings\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("onContentLoad".equals(name)) {
                this.setOnContentLoad(jp.getValueAsLong());
                continue;
            }
            if ("onLoad".equals(name)) {
                this.setOnLoad(jp.getValueAsLong());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if ("_timeStamps".equals(name)) {
                this.setTimeStamps(new HarTimeStamps(jp, warnings));
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' with Value '" + jp.getText() + "' in page element", jp.getCurrentLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarPageTimings(HarDatabaseConfig config, long pageId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT page_timings_id,on_content_load,on_load,comment FROM " + tableName + " WHERE page_id=?");
            ps.setLong(1, pageId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarPage for page id " + pageId + " found in database");
            }
            long pageTimingsId = rs.getLong(1);
            this.setOnContentLoad(rs.getLong(2));
            this.setOnLoad(rs.getLong(3));
            this.setComment(rs.getString(4));
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARPAGETIMING, pageTimingsId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("pageTimings");
        if (this.onContentLoad != null) {
            g.writeNumberField("onContentLoad", this.onContentLoad.longValue());
        }
        if (this.onLoad != null) {
            g.writeNumberField("onLoad", this.onLoad.longValue());
        }
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    public void writeJDBC(long pageId, HarDatabaseConfig config, PreparedStatement timingPs, long logId) throws SQLException {
        if (this.onContentLoad == null) {
            timingPs.setNull(1, -5);
        } else {
            timingPs.setLong(1, this.onContentLoad);
        }
        if (this.onLoad == null) {
            timingPs.setNull(2, -5);
        } else {
            timingPs.setLong(2, this.onLoad);
        }
        if (this.comment == null) {
            timingPs.setNull(3, -1);
        } else {
            timingPs.setString(3, this.comment);
        }
        timingPs.setLong(4, pageId);
        timingPs.executeUpdate();
        ResultSet rs = timingPs.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException("The database did not generate a key for an HarEntry row");
        }
        long pageTimingId = rs.getLong(1);
        this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARPAGETIMING, pageTimingId, logId);
    }

    public long getOnContentLoad() {
        return this.onContentLoad;
    }

    public void setOnContentLoad(long onContentLoad) {
        this.onContentLoad = onContentLoad;
    }

    public long getOnLoad() {
        return this.onLoad;
    }

    public void setOnLoad(long onLoad) {
        this.onLoad = onLoad;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarTimeStamps getTimeStamps() {
        return this.timeStamps;
    }

    public void setTimeStamps(HarTimeStamps timeStamps) {
        this.timeStamps = timeStamps;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "\"pageTimings\": { \"onContentLoad\": " + this.onContentLoad + ",\"onLoad\":" + this.onLoad + ", \"comment\": \"" + this.comment + "\", " + this.customFields + " }";
    }
}

