/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemProvider;
import org.openhab.core.items.dto.GroupFunctionDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.library.CoreItemFactory;
import org.openhab.core.model.yaml.YamlModelListener;
import org.openhab.core.model.yaml.YamlModelUtils;
import org.openhab.core.model.yaml.internal.items.YamlChannelLinkProvider;
import org.openhab.core.model.yaml.internal.items.YamlGroupDTO;
import org.openhab.core.model.yaml.internal.items.YamlItemDTO;
import org.openhab.core.model.yaml.internal.items.YamlMetadataDTO;
import org.openhab.core.model.yaml.internal.items.YamlMetadataProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ItemProvider.class, YamlItemProvider.class, YamlModelListener.class})
public class YamlItemProvider
extends AbstractProvider<Item>
implements ItemProvider,
YamlModelListener<YamlItemDTO> {
    private final Logger logger = LoggerFactory.getLogger(YamlItemProvider.class);
    private CoreItemFactory itemFactory;
    private final YamlChannelLinkProvider itemChannelLinkProvider;
    private final YamlMetadataProvider metaDataProvider;
    private final Map<String, Collection<Item>> itemsMap = new ConcurrentHashMap<String, Collection<Item>>();

    @Activate
    public YamlItemProvider(@Reference CoreItemFactory itemFactory, @Reference YamlChannelLinkProvider itemChannelLinkProvider, @Reference YamlMetadataProvider metaDataProvider, Map<String, Object> properties) {
        this.itemFactory = itemFactory;
        this.itemChannelLinkProvider = itemChannelLinkProvider;
        this.metaDataProvider = metaDataProvider;
    }

    @Deactivate
    public void deactivate() {
        this.itemsMap.clear();
    }

    public Collection<Item> getAll() {
        return this.itemsMap.keySet().stream().filter(name -> !YamlModelUtils.isIsolatedModel(name)).map(name -> this.itemsMap.getOrDefault(name, List.of())).flatMap(list -> list.stream()).toList();
    }

    public Collection<Item> getAllFromModel(String modelName) {
        return this.itemsMap.getOrDefault(modelName, List.of());
    }

    @Override
    public Class<YamlItemDTO> getElementClass() {
        return YamlItemDTO.class;
    }

    @Override
    public boolean isVersionSupported(int version) {
        return version >= 1;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public void addedModel(String modelName, Collection<YamlItemDTO> elements) {
        LinkedHashMap<Item, YamlItemDTO> added = new LinkedHashMap<Item, YamlItemDTO>();
        elements.forEach(elt -> {
            Item item = this.mapItem((YamlItemDTO)elt);
            if (item != null) {
                added.put(item, (YamlItemDTO)elt);
            }
        });
        Collection modelItems = Objects.requireNonNull(this.itemsMap.computeIfAbsent(modelName, k -> new ArrayList()));
        modelItems.addAll(added.keySet());
        added.forEach((item, itemDTO) -> {
            String name = item.getName();
            this.logger.debug("model {} added item {}", (Object)modelName, (Object)name);
            if (!YamlModelUtils.isIsolatedModel(modelName)) {
                this.notifyListenersAboutAddedElement(item);
            }
            this.processChannelLinks(modelName, name, (YamlItemDTO)itemDTO);
            this.processMetadata(modelName, name, (YamlItemDTO)itemDTO);
        });
    }

    @Override
    public void updatedModel(String modelName, Collection<YamlItemDTO> elements) {
        LinkedHashMap<Item, YamlItemDTO> updated = new LinkedHashMap<Item, YamlItemDTO>();
        elements.forEach(elt -> {
            Item item = this.mapItem((YamlItemDTO)elt);
            if (item != null) {
                updated.put(item, (YamlItemDTO)elt);
            }
        });
        Collection modelItems = Objects.requireNonNull(this.itemsMap.computeIfAbsent(modelName, k -> new ArrayList()));
        updated.forEach((item, itemDTO) -> {
            String name = item.getName();
            modelItems.stream().filter(i -> i.getName().equals(name)).findFirst().ifPresentOrElse(oldItem -> {
                modelItems.remove(oldItem);
                modelItems.add(item);
                this.logger.debug("model {} updated item {}", (Object)modelName, (Object)name);
                if (!YamlModelUtils.isIsolatedModel(modelName)) {
                    this.notifyListenersAboutUpdatedElement(oldItem, item);
                }
            }, () -> {
                modelItems.add(item);
                this.logger.debug("model {} added item {}", (Object)modelName, (Object)name);
                if (!YamlModelUtils.isIsolatedModel(modelName)) {
                    this.notifyListenersAboutAddedElement(item);
                }
            });
            this.processChannelLinks(modelName, name, (YamlItemDTO)itemDTO);
            this.processMetadata(modelName, name, (YamlItemDTO)itemDTO);
        });
    }

    @Override
    public void removedModel(String modelName, Collection<YamlItemDTO> elements) {
        List<Item> removed = elements.stream().map(elt -> this.mapItem((YamlItemDTO)elt)).filter(Objects::nonNull).toList();
        Collection modelItems = this.itemsMap.getOrDefault(modelName, List.of());
        removed.forEach(item -> {
            String name = item.getName();
            modelItems.stream().filter(i -> i.getName().equals(name)).findFirst().ifPresentOrElse(oldItem -> {
                modelItems.remove(oldItem);
                this.logger.debug("model {} removed item {}", (Object)modelName, (Object)name);
                if (!YamlModelUtils.isIsolatedModel(modelName)) {
                    this.notifyListenersAboutRemovedElement(oldItem);
                }
            }, () -> this.logger.debug("model {} item {} not found", (Object)modelName, (Object)name));
            this.processChannelLinks(modelName, name, null);
            this.processMetadata(modelName, name, null);
        });
        if (modelItems.isEmpty()) {
            this.itemsMap.remove(modelName);
        }
    }

    private @Nullable Item mapItem(YamlItemDTO itemDTO) {
        Item item;
        String name = itemDTO.name;
        try {
            if ("Group".equalsIgnoreCase(itemDTO.type)) {
                YamlGroupDTO groupDTO = itemDTO.group;
                if (groupDTO != null) {
                    Item baseItem = this.createItemOfType(groupDTO.getBaseType(), name);
                    if (baseItem != null) {
                        GroupFunctionDTO groupFunctionDto = new GroupFunctionDTO();
                        groupFunctionDto.name = groupDTO.getFunction();
                        groupFunctionDto.params = groupDTO.getParameters().toArray(new String[0]);
                        item = new GroupItem(name, baseItem, ItemDTOMapper.mapFunction((Item)baseItem, (GroupFunctionDTO)groupFunctionDto));
                    } else {
                        item = new GroupItem(name);
                    }
                } else {
                    item = new GroupItem(name);
                }
            } else {
                item = this.createItemOfType(itemDTO.getType(), name);
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Error creating item '{}', item will be ignored: {}", (Object)name, (Object)e.getMessage());
            item = null;
        }
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.setLabel(itemDTO.label);
            genericItem.setCategory(itemDTO.icon);
            for (String tag : itemDTO.getTags()) {
                genericItem.addTag(tag);
            }
            for (String groupName : itemDTO.getGroups()) {
                genericItem.addGroupName(groupName);
            }
        }
        return item;
    }

    private @Nullable Item createItemOfType(@Nullable String itemType, String itemName) {
        if (itemType == null) {
            return null;
        }
        GenericItem item = this.itemFactory.createItem(itemType, itemName);
        if (item != null) {
            this.logger.debug("Created item '{}' of type '{}'", (Object)itemName, (Object)itemType);
            return item;
        }
        this.logger.warn("CoreItemFactory cannot create item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }

    private void processChannelLinks(String modelName, String itemName, @Nullable YamlItemDTO itemDTO) {
        HashMap<String, Configuration> channelLinks = new HashMap<String, Configuration>(2);
        if (itemDTO != null) {
            if (itemDTO.channel != null) {
                channelLinks.put(itemDTO.channel, new Configuration());
            }
            if (itemDTO.channels != null) {
                itemDTO.channels.forEach((channelUID, config) -> channelLinks.put((String)channelUID, new Configuration(config)));
            }
        }
        try {
            this.itemChannelLinkProvider.updateItemChannelLinks(modelName, itemName, channelLinks);
        }
        catch (Exception e) {
            this.logger.warn("Channel links configuration of item '{}' could not be parsed correctly.", (Object)itemName, (Object)e);
        }
    }

    private void processMetadata(String modelName, String itemName, @Nullable YamlItemDTO itemDTO) {
        HashMap<String, YamlMetadataDTO> metadata = new HashMap<String, YamlMetadataDTO>();
        if (itemDTO != null) {
            YamlMetadataDTO mdDTO;
            boolean hasAutoUpdateMetadata = false;
            boolean hasUnitMetadata = false;
            boolean hasStateDescriptionMetadata = false;
            if (itemDTO.metadata != null) {
                for (Map.Entry<String, YamlMetadataDTO> entry : itemDTO.metadata.entrySet()) {
                    if ("autoupdate".equals(entry.getKey())) {
                        hasAutoUpdateMetadata = true;
                    } else if ("unit".equals(entry.getKey())) {
                        hasUnitMetadata = true;
                    } else if ("stateDescription".equals(entry.getKey())) {
                        hasStateDescriptionMetadata = true;
                    }
                    Map<String, Object> config = entry.getValue().config;
                    if (itemDTO.format != null && "stateDescription".equals(entry.getKey()) && (entry.getValue().config == null || entry.getValue().config.get("pattern") == null)) {
                        config = new HashMap<String, Object>();
                        if (entry.getValue().config != null) {
                            for (Map.Entry<String, Object> confEntry : entry.getValue().config.entrySet()) {
                                config.put(confEntry.getKey(), confEntry.getValue());
                            }
                            config.put("pattern", itemDTO.format);
                        }
                    }
                    YamlMetadataDTO mdDTO2 = new YamlMetadataDTO();
                    mdDTO2.value = entry.getValue().value;
                    mdDTO2.config = config;
                    metadata.put(entry.getKey(), mdDTO2);
                }
            }
            if (!hasAutoUpdateMetadata && itemDTO.autoupdate != null) {
                mdDTO = new YamlMetadataDTO();
                mdDTO.value = String.valueOf(itemDTO.autoupdate);
                metadata.put("autoupdate", mdDTO);
            }
            if (!hasUnitMetadata && itemDTO.unit != null) {
                mdDTO = new YamlMetadataDTO();
                mdDTO.value = itemDTO.unit;
                metadata.put("unit", mdDTO);
            }
            if (!hasStateDescriptionMetadata && itemDTO.format != null) {
                mdDTO = new YamlMetadataDTO();
                mdDTO.config = Map.of("pattern", itemDTO.format);
                metadata.put("stateDescription", mdDTO);
            }
        }
        this.metaDataProvider.updateMetadata(modelName, itemName, metadata);
    }
}

