/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ErrorMessages;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.AbstractKeywordValidator;
import com.networknt.schema.keyword.Keyword;
import java.util.Collection;
import java.util.Map;

public abstract class BaseKeywordValidator
extends AbstractKeywordValidator {
    protected final SchemaContext schemaContext;
    protected final Schema parentSchema;
    protected final Map<String, String> errorMessage;

    public BaseKeywordValidator(Keyword keyword, JsonNode schemaNode, SchemaLocation schemaLocation, Schema parentSchema, SchemaContext schemaContext) {
        super(keyword, schemaNode, schemaLocation);
        this.schemaContext = schemaContext;
        this.parentSchema = parentSchema;
        this.errorMessage = keyword != null && parentSchema != null && schemaContext.getSchemaRegistryConfig().getErrorMessageKeyword() != null ? ErrorMessages.getErrorMessage(parentSchema, schemaContext.getSchemaRegistryConfig().getErrorMessageKeyword(), keyword.getValue()) : null;
    }

    protected BaseKeywordValidator(Keyword keyword, JsonNode schemaNode, SchemaLocation schemaLocation, SchemaContext schemaContext, Schema parentSchema, Map<String, String> errorMessage) {
        super(keyword, schemaNode, schemaLocation);
        this.schemaContext = schemaContext;
        this.parentSchema = parentSchema;
        this.errorMessage = errorMessage;
    }

    public Schema getParentSchema() {
        return this.parentSchema;
    }

    protected String getNodeFieldType() {
        JsonNode typeField = this.getParentSchema().getSchemaNode().get("type");
        if (typeField != null) {
            return typeField.asText();
        }
        return null;
    }

    protected void preloadSchemas(Collection<Schema> schemas) {
        for (Schema schema : schemas) {
            schema.initializeValidators();
        }
    }

    protected MessageSourceError.Builder error() {
        return (MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)MessageSourceError.builder(this.schemaContext.getSchemaRegistryConfig().getMessageSource(), this.errorMessage).schemaNode(this.schemaNode)).schemaLocation(this.schemaLocation)).keyword(this.getKeyword())).messageKey(this.getKeyword());
    }
}

