/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Pattern;

final class PatternInterner {
    private static final int INIT_SIZE = 256;
    private static final float LOAD_FACTOR = 0.3f;
    private Pattern[] table;
    private int used;
    private int usedLimit;

    PatternInterner() {
        this.table = null;
        this.used = 0;
        this.usedLimit = 0;
    }

    PatternInterner(PatternInterner patternInterner) {
        this.table = patternInterner.table;
        if (this.table != null) {
            this.table = (Pattern[])this.table.clone();
        }
        this.used = patternInterner.used;
        this.usedLimit = patternInterner.usedLimit;
    }

    Pattern intern(Pattern pattern) {
        int n;
        if (this.table == null) {
            this.table = new Pattern[256];
            this.usedLimit = 76;
            n = this.firstIndex(pattern);
        } else {
            n = this.firstIndex(pattern);
            while (this.table[n] != null) {
                if (pattern.samePattern(this.table[n])) {
                    return this.table[n];
                }
                n = this.nextIndex(n);
            }
        }
        if (this.used >= this.usedLimit) {
            Pattern[] patternArray = this.table;
            this.table = new Pattern[this.table.length << 1];
            int n2 = patternArray.length;
            while (n2 > 0) {
                if (patternArray[--n2] == null) continue;
                int n3 = this.firstIndex(patternArray[n2]);
                while (this.table[n3] != null) {
                    n3 = this.nextIndex(n3);
                }
                this.table[n3] = patternArray[n2];
            }
            n = this.firstIndex(pattern);
            while (this.table[n] != null) {
                n = this.nextIndex(n);
            }
            this.usedLimit = (int)((float)this.table.length * 0.3f);
        }
        ++this.used;
        this.table[n] = pattern;
        return pattern;
    }

    private int firstIndex(Pattern pattern) {
        return pattern.patternHashCode() & this.table.length - 1;
    }

    private int nextIndex(int n) {
        return n == 0 ? this.table.length - 1 : n - 1;
    }
}

