<?php
/**
 * NotificationRuleBase
 *
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Model;

use \ArrayAccess;
use \InfluxDB2\ObjectSerializer;

/**
 * NotificationRuleBase Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class NotificationRuleBase implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'NotificationRuleBase';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'latest_completed' => '\DateTime',
        'last_run_status' => 'string',
        'last_run_error' => 'string',
        'id' => 'string',
        'endpoint_id' => 'string',
        'org_id' => 'string',
        'task_id' => 'string',
        'owner_id' => 'string',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'status' => '\InfluxDB2\Model\TaskStatusType',
        'name' => 'string',
        'sleep_until' => 'string',
        'every' => 'string',
        'offset' => 'string',
        'runbook_link' => 'string',
        'limit_every' => 'int',
        'limit' => 'int',
        'tag_rules' => '\InfluxDB2\Model\TagRule[]',
        'description' => 'string',
        'status_rules' => '\InfluxDB2\Model\StatusRule[]',
        'labels' => '\InfluxDB2\Model\Label[]',
        'links' => '\InfluxDB2\Model\NotificationRuleBaseLinks'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'latest_completed' => 'date-time',
        'last_run_status' => null,
        'last_run_error' => null,
        'id' => null,
        'endpoint_id' => null,
        'org_id' => null,
        'task_id' => null,
        'owner_id' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'status' => null,
        'name' => null,
        'sleep_until' => null,
        'every' => null,
        'offset' => null,
        'runbook_link' => null,
        'limit_every' => 'int32',
        'limit' => 'int32',
        'tag_rules' => null,
        'description' => null,
        'status_rules' => null,
        'labels' => null,
        'links' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'latest_completed' => 'latestCompleted',
        'last_run_status' => 'lastRunStatus',
        'last_run_error' => 'lastRunError',
        'id' => 'id',
        'endpoint_id' => 'endpointID',
        'org_id' => 'orgID',
        'task_id' => 'taskID',
        'owner_id' => 'ownerID',
        'created_at' => 'createdAt',
        'updated_at' => 'updatedAt',
        'status' => 'status',
        'name' => 'name',
        'sleep_until' => 'sleepUntil',
        'every' => 'every',
        'offset' => 'offset',
        'runbook_link' => 'runbookLink',
        'limit_every' => 'limitEvery',
        'limit' => 'limit',
        'tag_rules' => 'tagRules',
        'description' => 'description',
        'status_rules' => 'statusRules',
        'labels' => 'labels',
        'links' => 'links'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'latest_completed' => 'setLatestCompleted',
        'last_run_status' => 'setLastRunStatus',
        'last_run_error' => 'setLastRunError',
        'id' => 'setId',
        'endpoint_id' => 'setEndpointId',
        'org_id' => 'setOrgId',
        'task_id' => 'setTaskId',
        'owner_id' => 'setOwnerId',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'status' => 'setStatus',
        'name' => 'setName',
        'sleep_until' => 'setSleepUntil',
        'every' => 'setEvery',
        'offset' => 'setOffset',
        'runbook_link' => 'setRunbookLink',
        'limit_every' => 'setLimitEvery',
        'limit' => 'setLimit',
        'tag_rules' => 'setTagRules',
        'description' => 'setDescription',
        'status_rules' => 'setStatusRules',
        'labels' => 'setLabels',
        'links' => 'setLinks'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'latest_completed' => 'getLatestCompleted',
        'last_run_status' => 'getLastRunStatus',
        'last_run_error' => 'getLastRunError',
        'id' => 'getId',
        'endpoint_id' => 'getEndpointId',
        'org_id' => 'getOrgId',
        'task_id' => 'getTaskId',
        'owner_id' => 'getOwnerId',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'status' => 'getStatus',
        'name' => 'getName',
        'sleep_until' => 'getSleepUntil',
        'every' => 'getEvery',
        'offset' => 'getOffset',
        'runbook_link' => 'getRunbookLink',
        'limit_every' => 'getLimitEvery',
        'limit' => 'getLimit',
        'tag_rules' => 'getTagRules',
        'description' => 'getDescription',
        'status_rules' => 'getStatusRules',
        'labels' => 'getLabels',
        'links' => 'getLinks'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const LAST_RUN_STATUS_FAILED = 'failed';
    const LAST_RUN_STATUS_SUCCESS = 'success';
    const LAST_RUN_STATUS_CANCELED = 'canceled';



    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getLastRunStatusAllowableValues()
    {
        return [
            self::LAST_RUN_STATUS_FAILED,
            self::LAST_RUN_STATUS_SUCCESS,
            self::LAST_RUN_STATUS_CANCELED,
        ];
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->container['latest_completed'] = isset($data['latest_completed']) ? $data['latest_completed'] : null;
        $this->container['last_run_status'] = isset($data['last_run_status']) ? $data['last_run_status'] : null;
        $this->container['last_run_error'] = isset($data['last_run_error']) ? $data['last_run_error'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['endpoint_id'] = isset($data['endpoint_id']) ? $data['endpoint_id'] : null;
        $this->container['org_id'] = isset($data['org_id']) ? $data['org_id'] : null;
        $this->container['task_id'] = isset($data['task_id']) ? $data['task_id'] : null;
        $this->container['owner_id'] = isset($data['owner_id']) ? $data['owner_id'] : null;
        $this->container['created_at'] = isset($data['created_at']) ? $data['created_at'] : null;
        $this->container['updated_at'] = isset($data['updated_at']) ? $data['updated_at'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['sleep_until'] = isset($data['sleep_until']) ? $data['sleep_until'] : null;
        $this->container['every'] = isset($data['every']) ? $data['every'] : null;
        $this->container['offset'] = isset($data['offset']) ? $data['offset'] : null;
        $this->container['runbook_link'] = isset($data['runbook_link']) ? $data['runbook_link'] : null;
        $this->container['limit_every'] = isset($data['limit_every']) ? $data['limit_every'] : null;
        $this->container['limit'] = isset($data['limit']) ? $data['limit'] : null;
        $this->container['tag_rules'] = isset($data['tag_rules']) ? $data['tag_rules'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['status_rules'] = isset($data['status_rules']) ? $data['status_rules'] : null;
        $this->container['labels'] = isset($data['labels']) ? $data['labels'] : null;
        $this->container['links'] = isset($data['links']) ? $data['links'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getLastRunStatusAllowableValues();
        if (!is_null($this->container['last_run_status']) && !in_array($this->container['last_run_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'last_run_status', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['endpoint_id'] === null) {
            $invalidProperties[] = "'endpoint_id' can't be null";
        }
        if ($this->container['org_id'] === null) {
            $invalidProperties[] = "'org_id' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['status_rules'] === null) {
            $invalidProperties[] = "'status_rules' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets latest_completed
     *
     * @return \DateTime|null
     */
    public function getLatestCompleted()
    {
        return $this->container['latest_completed'];
    }

    /**
     * Sets latest_completed
     *
     * @param \DateTime|null $latest_completed A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)) of the latest scheduled and completed run.
     *
     * @return $this
     */
    public function setLatestCompleted($latest_completed)
    {
        $this->container['latest_completed'] = $latest_completed;

        return $this;
    }

    /**
     * Gets last_run_status
     *
     * @return string|null
     */
    public function getLastRunStatus()
    {
        return $this->container['last_run_status'];
    }

    /**
     * Sets last_run_status
     *
     * @param string|null $last_run_status last_run_status
     *
     * @return $this
     */
    public function setLastRunStatus($last_run_status)
    {
        $allowedValues = $this->getLastRunStatusAllowableValues();
        if (!is_null($last_run_status) && !in_array($last_run_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'last_run_status', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['last_run_status'] = $last_run_status;

        return $this;
    }

    /**
     * Gets last_run_error
     *
     * @return string|null
     */
    public function getLastRunError()
    {
        return $this->container['last_run_error'];
    }

    /**
     * Sets last_run_error
     *
     * @param string|null $last_run_error last_run_error
     *
     * @return $this
     */
    public function setLastRunError($last_run_error)
    {
        $this->container['last_run_error'] = $last_run_error;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets endpoint_id
     *
     * @return string
     */
    public function getEndpointId()
    {
        return $this->container['endpoint_id'];
    }

    /**
     * Sets endpoint_id
     *
     * @param string $endpoint_id endpoint_id
     *
     * @return $this
     */
    public function setEndpointId($endpoint_id)
    {
        $this->container['endpoint_id'] = $endpoint_id;

        return $this;
    }

    /**
     * Gets org_id
     *
     * @return string
     */
    public function getOrgId()
    {
        return $this->container['org_id'];
    }

    /**
     * Sets org_id
     *
     * @param string $org_id The ID of the organization that owns this notification rule.
     *
     * @return $this
     */
    public function setOrgId($org_id)
    {
        $this->container['org_id'] = $org_id;

        return $this;
    }

    /**
     * Gets task_id
     *
     * @return string|null
     */
    public function getTaskId()
    {
        return $this->container['task_id'];
    }

    /**
     * Sets task_id
     *
     * @param string|null $task_id The ID of the task associated with this notification rule.
     *
     * @return $this
     */
    public function setTaskId($task_id)
    {
        $this->container['task_id'] = $task_id;

        return $this;
    }

    /**
     * Gets owner_id
     *
     * @return string|null
     */
    public function getOwnerId()
    {
        return $this->container['owner_id'];
    }

    /**
     * Sets owner_id
     *
     * @param string|null $owner_id The ID of creator used to create this notification rule.
     *
     * @return $this
     */
    public function setOwnerId($owner_id)
    {
        $this->container['owner_id'] = $owner_id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at created_at
     *
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at updated_at
     *
     * @return $this
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \InfluxDB2\Model\TaskStatusType
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \InfluxDB2\Model\TaskStatusType $status status
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Human-readable name describing the notification rule.
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets sleep_until
     *
     * @return string|null
     */
    public function getSleepUntil()
    {
        return $this->container['sleep_until'];
    }

    /**
     * Sets sleep_until
     *
     * @param string|null $sleep_until sleep_until
     *
     * @return $this
     */
    public function setSleepUntil($sleep_until)
    {
        $this->container['sleep_until'] = $sleep_until;

        return $this;
    }

    /**
     * Gets every
     *
     * @return string|null
     */
    public function getEvery()
    {
        return $this->container['every'];
    }

    /**
     * Sets every
     *
     * @param string|null $every The notification repetition interval.
     *
     * @return $this
     */
    public function setEvery($every)
    {
        $this->container['every'] = $every;

        return $this;
    }

    /**
     * Gets offset
     *
     * @return string|null
     */
    public function getOffset()
    {
        return $this->container['offset'];
    }

    /**
     * Sets offset
     *
     * @param string|null $offset Duration to delay after the schedule, before executing check.
     *
     * @return $this
     */
    public function setOffset($offset)
    {
        $this->container['offset'] = $offset;

        return $this;
    }

    /**
     * Gets runbook_link
     *
     * @return string|null
     */
    public function getRunbookLink()
    {
        return $this->container['runbook_link'];
    }

    /**
     * Sets runbook_link
     *
     * @param string|null $runbook_link runbook_link
     *
     * @return $this
     */
    public function setRunbookLink($runbook_link)
    {
        $this->container['runbook_link'] = $runbook_link;

        return $this;
    }

    /**
     * Gets limit_every
     *
     * @return int|null
     */
    public function getLimitEvery()
    {
        return $this->container['limit_every'];
    }

    /**
     * Sets limit_every
     *
     * @param int|null $limit_every Don't notify me more than <limit> times every <limitEvery> seconds. If set, limit cannot be empty.
     *
     * @return $this
     */
    public function setLimitEvery($limit_every)
    {
        $this->container['limit_every'] = $limit_every;

        return $this;
    }

    /**
     * Gets limit
     *
     * @return int|null
     */
    public function getLimit()
    {
        return $this->container['limit'];
    }

    /**
     * Sets limit
     *
     * @param int|null $limit Don't notify me more than <limit> times every <limitEvery> seconds. If set, limitEvery cannot be empty.
     *
     * @return $this
     */
    public function setLimit($limit)
    {
        $this->container['limit'] = $limit;

        return $this;
    }

    /**
     * Gets tag_rules
     *
     * @return \InfluxDB2\Model\TagRule[]|null
     */
    public function getTagRules()
    {
        return $this->container['tag_rules'];
    }

    /**
     * Sets tag_rules
     *
     * @param \InfluxDB2\Model\TagRule[]|null $tag_rules List of tag rules the notification rule attempts to match.
     *
     * @return $this
     */
    public function setTagRules($tag_rules)
    {
        $this->container['tag_rules'] = $tag_rules;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description An optional description of the notification rule.
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets status_rules
     *
     * @return \InfluxDB2\Model\StatusRule[]
     */
    public function getStatusRules()
    {
        return $this->container['status_rules'];
    }

    /**
     * Sets status_rules
     *
     * @param \InfluxDB2\Model\StatusRule[] $status_rules List of status rules the notification rule attempts to match.
     *
     * @return $this
     */
    public function setStatusRules($status_rules)
    {
        $this->container['status_rules'] = $status_rules;

        return $this;
    }

    /**
     * Gets labels
     *
     * @return \InfluxDB2\Model\Label[]|null
     */
    public function getLabels()
    {
        return $this->container['labels'];
    }

    /**
     * Sets labels
     *
     * @param \InfluxDB2\Model\Label[]|null $labels labels
     *
     * @return $this
     */
    public function setLabels($labels)
    {
        $this->container['labels'] = $labels;

        return $this;
    }

    /**
     * Gets links
     *
     * @return \InfluxDB2\Model\NotificationRuleBaseLinks|null
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     *
     * @param \InfluxDB2\Model\NotificationRuleBaseLinks|null $links links
     *
     * @return $this
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


